/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.util.DataObjectListCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionWizard
extends JDialog
implements ActionListener,
DocumentListener {
    public static final String SELECTED_ITEMS_PROPERTY = "selectedItems";
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int ADD_ALL = 2;
    private static final int REMOVE_ALL = 3;
    private static final int ACCEPT = 4;
    private static final int CANCEL = 5;
    private static final int RESET = 6;
    private static final int ADD_NEW = 7;
    private static final Dimension DEFAULT_SIZE = new Dimension(500, 500);
    private List<Object> originalItems;
    private List<Object> originalSelectedItems;
    private Collection<Object> availableItems;
    private Collection<Object> selectedItems;
    private JList availableItemsListbox;
    private JList selectedItemsListbox;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private JButton acceptButton;
    private JButton resetButton;
    private JButton cancelButton;
    private ViewerSorter sorter;
    private Class type;
    private JButton addNewButton;
    private JTextField addField;

    private void initComponents() {
        this.sorter = new ViewerSorter();
        this.availableItemsListbox = new JList();
        this.availableItemsListbox.setCellRenderer(new DataObjectListCellRenderer());
        this.selectedItemsListbox = new JList();
        this.selectedItemsListbox.setCellRenderer(new DataObjectListCellRenderer());
        IconManager icons = IconManager.getInstance();
        this.addButton = new JButton(icons.getIcon(86));
        this.removeButton = new JButton(icons.getIcon(87));
        this.addAllButton = new JButton(icons.getIcon(84));
        this.removeAllButton = new JButton(icons.getIcon(85));
        this.acceptButton = new JButton("Accept");
        this.acceptButton.setToolTipText("Accept the selection.");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Cancel the selection.");
        this.resetButton = new JButton("Reset");
        this.resetButton.setToolTipText("Reset the selection.");
        this.addNewButton = new JButton("Add");
        this.addNewButton.setEnabled(false);
        this.addNewButton.setToolTipText("Add the new elements to the selection.");
        this.addNewButton.setActionCommand("7");
        this.addNewButton.addActionListener(this);
        this.addButton.setActionCommand("0");
        this.addButton.addActionListener(this);
        this.addAllButton.setActionCommand("2");
        this.addAllButton.addActionListener(this);
        this.removeButton.setActionCommand("1");
        this.removeButton.addActionListener(this);
        this.removeAllButton.setActionCommand("3");
        this.removeAllButton.addActionListener(this);
        this.acceptButton.setActionCommand("4");
        this.acceptButton.addActionListener(this);
        this.acceptButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.cancelButton.setActionCommand("5");
        this.cancelButton.addActionListener(this);
        this.resetButton.setActionCommand("6");
        this.resetButton.addActionListener(this);
        this.addField = new JTextField(20);
        this.addField.getDocument().addDocumentListener(this);
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    private void createOriginalSelections() {
        this.originalItems = new ArrayList<Object>();
        for (Object item : this.availableItems) {
            this.originalItems.add(item);
        }
        this.originalSelectedItems = new ArrayList<Object>();
        for (Object item : this.selectedItems) {
            this.originalSelectedItems.add(item);
        }
    }

    private void addItem() {
        if (this.availableItemsListbox.getSelectedIndex() == -1) {
            return;
        }
        int[] indexes = this.availableItemsListbox.getSelectedIndices();
        DefaultListModel model = (DefaultListModel)this.availableItemsListbox.getModel();
        for (int i = 0; i < indexes.length; ++i) {
            Object object = model.getElementAt(indexes[i]);
            if (!this.availableItems.contains(object)) continue;
            this.selectedItems.add(object);
            this.availableItems.remove(object);
        }
        this.sortLists();
        this.populateSelectedItems();
        this.populateAvailableItems();
        this.setButtonsEnabled();
    }

    private void sortLists() {
        this.availableItems = this.sorter.sort(this.availableItems);
        this.selectedItems = this.sorter.sort(this.selectedItems);
    }

    private void addAllItems() {
        for (Object item : this.availableItems) {
            this.selectedItems.add(item);
        }
        this.availableItems.clear();
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setButtonsEnabled();
    }

    private void removeItem() {
        if (this.selectedItemsListbox.getSelectedIndex() == -1) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.selectedItemsListbox.getModel();
        int[] indexes = this.selectedItemsListbox.getSelectedIndices();
        for (int i = 0; i < indexes.length; ++i) {
            Object object = model.getElementAt(indexes[i]);
            if (!this.selectedItems.contains(object)) continue;
            this.selectedItems.remove(object);
            if (TagAnnotationData.class.equals((Object)this.type)) {
                TagAnnotationData tag = (TagAnnotationData)object;
                if (tag.getId() <= 0L) continue;
                this.availableItems.add(object);
                continue;
            }
            this.availableItems.add(object);
        }
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setButtonsEnabled();
    }

    private void removeAllItems() {
        if (TagAnnotationData.class.equals((Object)this.type)) {
            for (Object item : this.selectedItems) {
                TagAnnotationData tag = (TagAnnotationData)item;
                if (tag.getId() <= 0L) continue;
                this.availableItems.add(item);
            }
        } else {
            for (Object item : this.selectedItems) {
                this.availableItems.add(item);
            }
        }
        this.selectedItems.clear();
        this.sortLists();
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setButtonsEnabled();
    }

    private void setButtonsEnabled() {
        if (this.originalSelectedItems.size() != this.selectedItems.size()) {
            this.acceptButton.setEnabled(true);
            this.resetButton.setEnabled(true);
        } else {
            boolean b = false;
            int n = 0;
            Iterator<Object> i = this.selectedItems.iterator();
            while (i.hasNext()) {
                if (!this.originalSelectedItems.contains(i.next())) continue;
                ++n;
            }
            b = n != this.originalSelectedItems.size();
            this.acceptButton.setEnabled(b);
            this.resetButton.setEnabled(b);
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void accept() {
        HashMap<Class, Collection<Object>> r = new HashMap<Class, Collection<Object>>();
        r.put(this.type, this.selectedItems);
        this.firePropertyChange(SELECTED_ITEMS_PROPERTY, null, r);
        this.cancel();
    }

    private void reset() {
        this.availableItems.clear();
        this.selectedItems.clear();
        for (Object item : this.originalItems) {
            this.availableItems.add(item);
        }
        for (Object item : this.originalSelectedItems) {
            this.selectedItems.add(item);
        }
        this.populateAvailableItems();
        this.populateSelectedItems();
        this.setButtonsEnabled();
    }

    private JPanel layoutSelectionPane() {
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        double[][] size = new double[][]{{-1.0, 40.0, -1.0}, {-2.0}};
        container.setLayout((LayoutManager)new TableLayout((double[][])size));
        container.add((Component)this.createAvailableItemsPane(), "0, 0");
        container.add((Component)this.createSelectionPane(), "1, 0, c, c");
        container.add((Component)this.createSelectedItemsPane(), "2, 0");
        return container;
    }

    private void buildUI(boolean addCreation) {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        if (!addCreation) {
            c.add((Component)this.layoutSelectionPane(), "Center");
        } else {
            JPanel container = new JPanel();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.layoutSelectionPane());
            container.add(this.createAdditionPane());
            c.add((Component)container, "Center");
        }
        c.add((Component)this.createControlsPane(), "South");
    }

    private JPanel createControlsPane() {
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(false);
        controlPanel.setLayout(new FlowLayout());
        controlPanel.add(this.resetButton);
        controlPanel.add(this.acceptButton);
        controlPanel.add(this.cancelButton);
        return UIUtilities.buildComponentPanelRight(controlPanel);
    }

    private JPanel createSelectedItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)UIUtilities.setTextFont("Selected:"), "North");
        p.add((Component)new JScrollPane(this.selectedItemsListbox), "Center");
        this.populateSelectedItems();
        return p;
    }

    private JPanel createSelectionPane() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(Box.createVerticalStrut(30));
        buttonPanel.add(this.addButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.addAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        buttonPanel.add(this.removeAllButton);
        buttonPanel.add(Box.createVerticalStrut(10));
        return buttonPanel;
    }

    private JPanel createAdditionPane() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        String text = null;
        String tip = null;
        if (TagAnnotationData.class.equals((Object)this.type)) {
            tip = "Enter the new Tags, use comma to separate them.";
            text = "New Tag: ";
        }
        if (tip != null) {
            p.add((Component)new JLabel(tip), "0, 0, l, t");
        }
        if (text != null) {
            JPanel pane = new JPanel();
            pane.setLayout(new BoxLayout(pane, 0));
            pane.add(UIUtilities.setTextFont(text));
            pane.add(this.addField);
            pane.add(this.addNewButton);
            p.add((Component)pane, "0, 1, l, t");
        }
        return p;
    }

    private JPanel createAvailableItemsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)UIUtilities.setTextFont("Available:"), "North");
        p.add((Component)new JScrollPane(this.availableItemsListbox), "Center");
        this.populateAvailableItems();
        return p;
    }

    private void populateAvailableItems() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object item : this.availableItems) {
            listModel.addElement(item);
        }
        this.availableItemsListbox.setModel(listModel);
    }

    private boolean doesTagExist(TagAnnotationData object) {
        Iterator<Object> i = this.availableItems.iterator();
        String value = object.getTagValue();
        while (i.hasNext()) {
            TagAnnotationData tagAnnotationData = (TagAnnotationData)i.next();
            if (!tagAnnotationData.getTagValue().equals(value)) continue;
            return true;
        }
        for (TagAnnotationData tagAnnotationData : this.selectedItems) {
            if (!tagAnnotationData.getTagValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private void addNewObjects() {
        if (TagAnnotationData.class.equals((Object)this.type)) {
            String text = this.addField.getText();
            if (text == null || text.trim().length() == 0) {
                return;
            }
            String[] names = text.split(",");
            for (int i = 0; i < names.length; ++i) {
                TagAnnotationData data;
                if (names[i] == null || names[i].length() <= 0 || this.doesTagExist(data = new TagAnnotationData(names[i].trim()))) continue;
                this.selectedItems.add(data);
            }
        }
        this.sortLists();
        this.populateSelectedItems();
        this.addField.setText("");
        this.setButtonsEnabled();
    }

    private void populateSelectedItems() {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        for (Object item : this.selectedItems) {
            listModel.addElement(item);
        }
        this.selectedItemsListbox.setModel(listModel);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class type) {
        this(owner, available, null, type);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Class type, boolean addCreation) {
        this(owner, available, null, type, addCreation);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class type) {
        this(owner, available, selected, type, false);
    }

    public SelectionWizard(JFrame owner, Collection<Object> available, Collection<Object> selected, Class type, boolean addCreation) {
        super(owner);
        this.setModal(true);
        if (this.selectedItems == null) {
            this.selectedItems = new ArrayList<Object>();
        }
        this.availableItems = available;
        this.selectedItems = selected;
        this.type = type;
        this.createOriginalSelections();
        this.initComponents();
        this.sortLists();
        this.buildUI(addCreation);
        this.setSize(DEFAULT_SIZE);
    }

    public void setTitle(String title, String text) {
        this.setTitle(title, text, null);
    }

    public void setTitle(String title, String text, Icon titleIcon) {
        this.setTitle(title);
        if (titleIcon == null) {
            IconManager icons = IconManager.getInstance();
            titleIcon = icons.getIcon(89);
        }
        TitlePanel tp = new TitlePanel(title, text, titleIcon);
        this.getContentPane().add((Component)((Object)tp), "North");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int id = Integer.parseInt(evt.getActionCommand());
        switch (id) {
            case 0: {
                this.addItem();
                break;
            }
            case 2: {
                this.addAllItems();
                break;
            }
            case 1: {
                this.removeItem();
                break;
            }
            case 3: {
                this.removeAllItems();
                break;
            }
            case 4: {
                this.accept();
                break;
            }
            case 5: {
                this.cancel();
                break;
            }
            case 6: {
                this.reset();
                break;
            }
            case 7: {
                this.addNewObjects();
            }
        }
    }

    public void setAcceptButtonText(String text) {
        if (this.acceptButton != null) {
            this.acceptButton.setText(text);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        String text = this.addField.getText();
        boolean b = text != null && text.trim().length() > 0;
        this.addNewButton.setEnabled(b);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        String text = this.addField.getText();
        boolean b = text != null && text.trim().length() > 0;
        this.addNewButton.setEnabled(b);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

