/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Font;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import omero.RDouble;
import omero.model.PlaneInfo;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMEComboBoxUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.WellData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorUtil {
    public static final Map<Integer, String> LETTERS = new HashMap<Integer, String>();
    public static final String DATE_NOT_AVAILABLE = "Not available";
    public static final String DEFAULT_GROUP = "Main Group";
    public static final String MANDATORY_SYMBOL = " *";
    public static final String MANDATORY_DESCRIPTION = "* indicates the required fields.";
    public static final String LAST_NAME = "Last Name";
    public static final String FIRST_NAME = "First Name";
    public static final String INSTITUTION = "Institution";
    public static final String OWNER = "Owner: ";
    public static final String GROUP = "Group: ";
    public static final String WORLD = "Others: ";
    public static final String READ = "Read";
    public static final String WRITE = "Write";
    public static final String PUBLIC = "public";
    public static final String PUBLIC_DESCRIPTION = "Visible to Group members only.";
    public static final String PRIVATE = "private";
    public static final String GROUPS = "Belongs to the following groups: ";
    public static final String WAVELENGTHS = "Emissions wavelengths";
    public static final String EMAIL = "E-mail";
    public static final String MICRONS = "(\u00b5m)";
    public static final String CELCIUS = "(\u2103)";
    public static final String PERCENT = "(%)";
    public static final String MILLIBARS = "(mb)";
    public static final String SIZE_X = "Size X";
    public static final String SIZE_Y = "Size Y";
    public static final String PIXEL_SIZE_X = "Pixel size X (\u00b5m)";
    public static final String PIXEL_SIZE_Y = "Pixel size Y (\u00b5m)";
    public static final String PIXEL_SIZE_Z = "Pixel size Z (\u00b5m)";
    public static final String SECTIONS = "Number of sections";
    public static final String TIMEPOINTS = "Number of timepoints";
    public static final String PIXEL_TYPE = "Pixel Type";
    public static final String NAME = "Name";
    public static final String ACQUISITION_DATE = "Acquisition date";
    public static final String EM_WAVE = "Emission";
    public static final String EX_WAVE = "Excitation";
    public static final String PIN_HOLE_SIZE = "Pin hole size (\u00b5m)";
    public static final String ND_FILTER = "ND Filter (%)";
    public static final String FLUOR = "Fluor";
    public static final String ILLUMINATION = "Illumination";
    public static final String CONTRAST_METHOD = "Contrast Method";
    public static final String MODE = "Mode";
    public static final String POCKEL_CELL_SETTINGS = "Pockel Cell";
    public static final String NOMINAL_MAGNIFICATION = "Nominal Magnification";
    public static final String CALIBRATED_MAGNIFICATION = "Calibrated Magnification";
    public static final String LENSNA = "Lens NA";
    public static final String WORKING_DISTANCE = "Working Distance";
    public static final String IMMERSION = "Immersion";
    public static final String CORRECTION = "Correction";
    public static final String CORRECTION_COLLAR = "Correction Collar";
    public static final String MEDIUM = "Medium";
    public static final String REFRACTIVE_INDEX = "Refractive index";
    public static final String TEMPERATURE = "Temperature (\u2103)";
    public static final String AIR_PRESSURE = "Air Pressure (mb)";
    public static final String HUMIDITY = "Humidy (%)";
    public static final String CO2_PERCENT = "CO2 Percent (%)";
    public static final String MODEL = "Model";
    public static final String MANUFACTURER = "Manufacturer";
    public static final String SERIAL_NUMBER = "Serial Number";
    public static final String POSITION_X = "Position X";
    public static final String POSITION_Y = "Position Y";
    public static final String POSITION_Z = "Position Z";
    public static final String TYPE = "Type";
    public static final String VOLTAGE = "Voltage";
    public static final String GAIN = "Gain";
    public static final String OFFSET = "Offset";
    public static final String READ_OUT_RATE = "Read out rate";
    public static final String BINNING = "Binning";
    public static final String AMPLIFICATION = "Amplification Gain";
    public static final String ZOOM = "Zoom";
    public static final String EXPOSURE_TIME = "Exposure Time";
    public static final String DELTA_T = "DeltaT";
    public static final String POWER = "Power";
    public static final String LIGHT_TYPE = "Light";
    public static final String TUNEABLE = "Tuneable";
    public static final String PULSE = "Pulse";
    public static final String POCKEL_CELL = "PockelCell";
    public static final String REPETITION_RATE = "Repetition Rate (Hz)";
    public static final String PUMP = "Pump";
    public static final String WAVELENGTH = "Wavelength";
    public static final String FREQUENCY_MULTIPLICATION = "Frequency Multiplication";
    public static final String IRIS = "Iris";
    public static final String NOT_SET = "NotSet";
    public static final Map<String, String> PIXELS_TYPE_DESCRIPTION;
    public static final Map<String, String> PIXELS_TYPE;
    private static final EditorFileFilter editorFilter;

    public static Map<String, String> transformExperimenterData(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(2);
        if (data == null) {
            details.put(OWNER, "");
            details.put(EMAIL, "");
        } else {
            try {
                details.put(OWNER, data.getFirstName() + " " + data.getLastName());
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(OWNER, "");
                details.put(EMAIL, "");
            }
        }
        return details;
    }

    public static Map<String, String> transformPixelsData(PixelsData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(9);
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, PIXELS_TYPE_DESCRIPTION.get("" + data.getPixelType()));
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put(WAVELENGTHS, "");
        return details;
    }

    public static Map<String, String> transformImageData(ImageData image) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(10);
        if (image == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
            details.put(WAVELENGTHS, "");
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
            return details;
        }
        PixelsData data = image.getDefaultPixels();
        if (data == null) {
            details.put(SIZE_X, "");
            details.put(SIZE_Y, "");
            details.put(SECTIONS, "");
            details.put(TIMEPOINTS, "");
            details.put(PIXEL_SIZE_X, "");
            details.put(PIXEL_SIZE_Y, "");
            details.put(PIXEL_SIZE_Z, "");
            details.put(PIXEL_TYPE, "");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            details.put(SIZE_X, "" + data.getSizeX());
            details.put(SIZE_Y, "" + data.getSizeY());
            details.put(SECTIONS, "" + data.getSizeZ());
            details.put(TIMEPOINTS, "" + data.getSizeT());
            try {
                details.put(PIXEL_SIZE_X, nf.format(data.getPixelSizeX()));
                details.put(PIXEL_SIZE_Y, nf.format(data.getPixelSizeY()));
                details.put(PIXEL_SIZE_Z, nf.format(data.getPixelSizeZ()));
                details.put(PIXEL_TYPE, PIXELS_TYPE_DESCRIPTION.get("" + data.getPixelType()));
            }
            catch (Exception e) {
                details.put(PIXEL_SIZE_X, "");
                details.put(PIXEL_SIZE_Y, "");
                details.put(PIXEL_SIZE_Z, "");
                details.put(PIXEL_TYPE, "");
            }
        }
        details.put(WAVELENGTHS, "");
        Timestamp date = EditorUtil.getAcquisitionTime(image);
        if (date == null) {
            details.put(ACQUISITION_DATE, DATE_NOT_AVAILABLE);
        } else {
            details.put(ACQUISITION_DATE, UIUtilities.formatTime(date));
        }
        return details;
    }

    public static Timestamp getAcquisitionTime(ImageData image) {
        if (image == null) {
            return null;
        }
        Timestamp date = null;
        try {
            date = image.getAcquisitionDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String formatExperimenter(ExperimenterData exp) {
        if (exp == null) {
            return "";
        }
        return exp.getFirstName() + " " + exp.getLastName();
    }

    public static Map<String, String> convertExperimenter(ExperimenterData data) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>(3);
        if (data == null) {
            details.put(FIRST_NAME, "");
            details.put(LAST_NAME, "");
            details.put(EMAIL, "");
            details.put(INSTITUTION, "");
        } else {
            try {
                details.put(FIRST_NAME, data.getFirstName());
            }
            catch (Exception e) {
                details.put(FIRST_NAME, "");
            }
            try {
                details.put(LAST_NAME, data.getLastName());
            }
            catch (Exception e) {
                details.put(LAST_NAME, "");
            }
            try {
                details.put(EMAIL, data.getEmail());
            }
            catch (Exception e) {
                details.put(EMAIL, "");
            }
            try {
                details.put(INSTITUTION, data.getInstitution());
            }
            catch (Exception e) {
                details.put(INSTITUTION, "");
            }
        }
        return details;
    }

    public static boolean isAnnotated(Object object) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        }
        return counts != null && counts.size() != 0;
    }

    public static boolean isAnnotatedByCurrentUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        return counts.keySet().contains(userID);
    }

    public static boolean isAnnotatedByOtherUser(Object object, long userID) {
        if (object == null) {
            return false;
        }
        Map counts = null;
        if (object instanceof ImageData) {
            counts = ((ImageData)object).getAnnotationsCounts();
        } else if (object instanceof DatasetData) {
            counts = ((DatasetData)object).getAnnotationsCounts();
        } else if (object instanceof ProjectData) {
            counts = ((ProjectData)object).getAnnotationsCounts();
        } else if (object instanceof ScreenData) {
            counts = ((ScreenData)object).getAnnotationsCounts();
        } else if (object instanceof PlateData) {
            counts = ((PlateData)object).getAnnotationsCounts();
        } else if (object instanceof WellData) {
            counts = ((WellData)object).getAnnotationsCounts();
        }
        if (counts == null || counts.size() == 0) {
            return false;
        }
        Set set = counts.keySet();
        if (set.size() > 1) {
            return true;
        }
        return !set.contains(userID);
    }

    public static String getPartialName(String originalName) {
        String[] l = UIUtilities.splitString(originalName);
        if (l != null) {
            int n = l.length;
            switch (n) {
                case 0: {
                    return originalName;
                }
                case 1: {
                    return l[0];
                }
                case 2: {
                    return l[n - 2] + "/" + l[n - 1];
                }
            }
            return "..." + l[n - 2] + "/" + l[n - 1];
        }
        return originalName;
    }

    public static boolean isReadable(Object ho, long userID, long groupID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        if (userID == data.getOwner().getId()) {
            return permissions.isUserRead();
        }
        return permissions.isGroupRead();
    }

    public static boolean isWritable(Object ho, long userID, long groupID) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        if (userID == data.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }

    public static boolean isGroupWritable(Object ho) {
        if (ho == null || ho instanceof ExperimenterData || ho instanceof String) {
            return false;
        }
        if (!(ho instanceof DataObject)) {
            return false;
        }
        DataObject data = (DataObject)ho;
        PermissionData permissions = data.getPermissions();
        return permissions.isGroupWrite();
    }

    public static String removeFileExtension(String originalName) {
        int n;
        String name = originalName;
        String[] l = UIUtilities.splitString(originalName);
        if (l != null) {
            n = l.length;
            if (n >= 1) {
                name = l[n - 1];
            }
        } else {
            return name;
        }
        if (Pattern.compile(".").matcher(name).find() && (l = name.split("\\.")).length >= 1) {
            name = "";
            n = l.length - 1;
            for (int i = 0; i < n; ++i) {
                name = name + l[i];
                if (i >= n - 1) continue;
                name = name + ".";
            }
        }
        return name;
    }

    public static Map<String, Object> transformChannelData(ChannelData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(10);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(EM_WAVE, 0);
        details.put(EX_WAVE, 0);
        details.put(ND_FILTER, Float.valueOf(0.0f));
        details.put(PIN_HOLE_SIZE, Float.valueOf(0.0f));
        details.put(FLUOR, "");
        details.put(ILLUMINATION, "");
        details.put(CONTRAST_METHOD, "");
        details.put(MODE, "");
        details.put(POCKEL_CELL_SETTINGS, 0);
        if (data == null) {
            notSet.add(NAME);
            notSet.add(EM_WAVE);
            notSet.add(EX_WAVE);
            notSet.add(ND_FILTER);
            notSet.add(PIN_HOLE_SIZE);
            notSet.add(FLUOR);
            notSet.add(ILLUMINATION);
            notSet.add(CONTRAST_METHOD);
            notSet.add(MODE);
            notSet.add(POCKEL_CELL_SETTINGS);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getName();
        if (s == null || s.trim().length() == 0) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        int i = data.getEmissionWavelength();
        if (i < 0) {
            i = 0;
            notSet.add(EM_WAVE);
        }
        details.put(EM_WAVE, i);
        i = data.getExcitationWavelength();
        if (i < 0) {
            i = 0;
            notSet.add(EX_WAVE);
        }
        details.put(EX_WAVE, i);
        double f = data.getNDFilter();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(ND_FILTER);
        }
        details.put(ND_FILTER, f * 100.0);
        f = data.getPinholeSize();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(PIN_HOLE_SIZE);
        }
        details.put(PIN_HOLE_SIZE, f);
        s = data.getFluor();
        if (s == null || s.trim().length() == 0) {
            notSet.add(FLUOR);
        }
        details.put(FLUOR, s);
        s = data.getIllumination();
        if (s == null || s.trim().length() == 0) {
            notSet.add(ILLUMINATION);
        }
        details.put(ILLUMINATION, s);
        s = data.getContrastMethod();
        if (s == null || s.trim().length() == 0) {
            notSet.add(CONTRAST_METHOD);
        }
        details.put(CONTRAST_METHOD, s);
        try {
            s = data.getMode();
        }
        catch (Exception e) {
            s = null;
        }
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODE);
        }
        details.put(MODE, s);
        i = data.getPockelCell();
        if (i < 0) {
            i = 0;
            notSet.add(POCKEL_CELL_SETTINGS);
        }
        details.put(POCKEL_CELL_SETTINGS, i);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformObjective(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(9);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(NOMINAL_MAGNIFICATION, 0);
        details.put(CALIBRATED_MAGNIFICATION, Float.valueOf(0.0f));
        details.put(LENSNA, new Float(0.0f));
        details.put(IMMERSION, "");
        details.put(CORRECTION, "");
        details.put(WORKING_DISTANCE, Float.valueOf(0.0f));
        details.put(CORRECTION_COLLAR, Float.valueOf(0.0f));
        details.put(MEDIUM, "");
        details.put(REFRACTIVE_INDEX, Float.valueOf(0.0f));
        details.put(IRIS, null);
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(NOMINAL_MAGNIFICATION);
            notSet.add(CALIBRATED_MAGNIFICATION);
            notSet.add(LENSNA);
            notSet.add(IMMERSION);
            notSet.add(CORRECTION);
            notSet.add(WORKING_DISTANCE);
            notSet.add(CORRECTION_COLLAR);
            notSet.add(MEDIUM);
            notSet.add(REFRACTIVE_INDEX);
            notSet.add(IRIS);
            details.put(NOT_SET, notSet);
            return details;
        }
        Object o = data.hasIris();
        if (o == null) {
            notSet.add(IRIS);
        }
        details.put(IRIS, o);
        String s = data.getModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        int i = data.getNominalMagnification();
        if (i < 0) {
            i = 0;
            notSet.add(NOMINAL_MAGNIFICATION);
        }
        details.put(NOMINAL_MAGNIFICATION, i);
        double f = data.getCalibratedMagnification();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CALIBRATED_MAGNIFICATION);
        }
        details.put(CALIBRATED_MAGNIFICATION, f);
        f = data.getLensNA();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(LENSNA);
        }
        details.put(LENSNA, f);
        s = data.getImmersion();
        if (s == null || s.trim().length() == 0) {
            notSet.add(IMMERSION);
        }
        details.put(IMMERSION, s);
        s = data.getCorrection();
        if (s == null || s.trim().length() == 0) {
            notSet.add(CORRECTION);
        }
        details.put(CORRECTION, s);
        f = data.getWorkingDistance();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(WORKING_DISTANCE);
        }
        details.put(WORKING_DISTANCE, f);
        f = data.getCorrectionCollar();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(CORRECTION_COLLAR);
        }
        details.put(CORRECTION_COLLAR, f);
        s = data.getMedium();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MEDIUM);
        }
        details.put(MEDIUM, s);
        f = data.getRefractiveIndex();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(REFRACTIVE_INDEX);
        }
        details.put(REFRACTIVE_INDEX, f);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformImageEnvironment(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(TEMPERATURE, new Double(0.0));
        details.put(AIR_PRESSURE, new Double(0.0));
        details.put(HUMIDITY, new Double(0.0));
        details.put(CO2_PERCENT, new Double(0.0));
        if (data == null) {
            notSet.add(TEMPERATURE);
            notSet.add(AIR_PRESSURE);
            notSet.add(HUMIDITY);
            notSet.add(CO2_PERCENT);
            details.put(NOT_SET, notSet);
            return details;
        }
        Object o = data.getTemperature();
        double f = 0.0;
        if (o == null) {
            notSet.add(TEMPERATURE);
        } else {
            f = (Double)o;
        }
        details.put(TEMPERATURE, f);
        f = data.getAirPressure();
        if (f < 0.0) {
            notSet.add(AIR_PRESSURE);
            f = 0.0;
        }
        details.put(AIR_PRESSURE, f);
        f = data.getHumidity();
        if (f < 0.0) {
            notSet.add(HUMIDITY);
            f = 0.0;
        }
        details.put(HUMIDITY, f * 100.0);
        f = data.getCo2Percent();
        if (f < 0.0) {
            notSet.add(CO2_PERCENT);
            f = 0.0;
        }
        details.put(CO2_PERCENT, f * 100.0);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformStageLabel(ImageAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(NAME, "");
        details.put(POSITION_X, new Double(0.0));
        details.put(POSITION_Y, new Double(0.0));
        details.put(POSITION_Z, new Double(0.0));
        if (data == null) {
            notSet.add(NAME);
            notSet.add(POSITION_X);
            notSet.add(POSITION_Y);
            notSet.add(POSITION_Z);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLabelName();
        if (s == null || s.trim().length() == 0) {
            notSet.add(NAME);
        }
        details.put(NAME, s);
        Object o = data.getPositionX();
        double f = 0.0;
        if (o == null) {
            notSet.add(POSITION_X);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_X, f);
        f = 0.0;
        if (o == null) {
            notSet.add(POSITION_Y);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_Y, f);
        f = 0.0;
        if (o == null) {
            notSet.add(POSITION_Z);
        } else {
            f = (Double)o;
        }
        details.put(POSITION_Z, f);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformLightSource(String kind, ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(LIGHT_TYPE, "");
        details.put(POWER, new Double(0.0));
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(LIGHT_TYPE);
            notSet.add(POWER);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getLightSourceModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getLightSourceManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getLightSourceSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        s = data.getLightSourceKind();
        details.put(LIGHT_TYPE, s);
        double f = data.getLightSourcePower();
        if (f < 0.0) {
            notSet.add(POWER);
            f = 0.0;
        }
        details.put(POWER, f);
        s = data.getLightType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        s = kind == null ? data.getLightSourceKind() : kind;
        if (ChannelAcquisitionData.LASER.equals(s)) {
            s = data.getLaserMedium();
            if (s == null || s.trim().length() == 0) {
                notSet.add(MEDIUM);
            }
            details.put(MEDIUM, s);
            int i = data.getLaserWavelength();
            if (i < 0) {
                i = 0;
                notSet.add(WAVELENGTH);
            }
            details.put(WAVELENGTH, i);
            i = data.getLaserFrequencyMultiplication();
            if (i < 0) {
                i = 0;
                notSet.add(FREQUENCY_MULTIPLICATION);
            }
            details.put(FREQUENCY_MULTIPLICATION, i);
            Object o = data.getLaserTuneable();
            if (o == null) {
                notSet.add(TUNEABLE);
            }
            details.put(TUNEABLE, o);
            s = data.getLaserPulse();
            if (s == null || s.trim().length() == 0) {
                notSet.add(PULSE);
            }
            details.put(PULSE, s);
            f = data.getLaserRepetitionRate();
            if (f < 0.0) {
                f = 0.0;
                notSet.add(REPETITION_RATE);
            }
            details.put(REPETITION_RATE, f);
            o = data.getLaserPockelCell();
            if (o == null) {
                notSet.add(POCKEL_CELL);
            }
            details.put(POCKEL_CELL, o);
        }
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformDetector(ChannelAcquisitionData data) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(11);
        ArrayList<String> notSet = new ArrayList<String>();
        details.put(MODEL, "");
        details.put(MANUFACTURER, "");
        details.put(SERIAL_NUMBER, "");
        details.put(GAIN, new Double(0.0));
        details.put(VOLTAGE, new Double(0.0));
        details.put(OFFSET, new Double(0.0));
        details.put(READ_OUT_RATE, new Double(0.0));
        details.put(BINNING, "");
        details.put(ZOOM, new Double(0.0));
        details.put(AMPLIFICATION, "");
        details.put(TYPE, "");
        if (data == null) {
            notSet.add(MODEL);
            notSet.add(MANUFACTURER);
            notSet.add(SERIAL_NUMBER);
            notSet.add(GAIN);
            notSet.add(VOLTAGE);
            notSet.add(READ_OUT_RATE);
            notSet.add(BINNING);
            notSet.add(ZOOM);
            notSet.add(AMPLIFICATION);
            notSet.add(TYPE);
            details.put(NOT_SET, notSet);
            return details;
        }
        String s = data.getDetectorModel();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MODEL);
        }
        details.put(MODEL, s);
        s = data.getDetectorManufacturer();
        if (s == null || s.trim().length() == 0) {
            notSet.add(MANUFACTURER);
        }
        details.put(MANUFACTURER, s);
        s = data.getDetectorSerialNumber();
        if (s == null || s.trim().length() == 0) {
            notSet.add(SERIAL_NUMBER);
        }
        details.put(SERIAL_NUMBER, s);
        double f = data.getDetectorSettingsGain();
        if (f > 0.0) {
            details.put(GAIN, f);
        } else {
            f = data.getDetectorGain();
            if (f < 0.0) {
                f = 0.0;
                notSet.add(GAIN);
            }
            details.put(GAIN, f);
        }
        f = data.getDetectorSettingsVoltage();
        if (f > 0.0) {
            details.put(VOLTAGE, f);
        } else {
            f = data.getDetectorVoltage();
            if (f < 0.0) {
                f = 0.0;
                notSet.add(VOLTAGE);
            }
            details.put(VOLTAGE, f);
        }
        f = data.getDetectorSettingsOffset();
        if (f > 0.0) {
            details.put(OFFSET, f);
        } else {
            f = data.getDetectorOffset();
            if (f < 0.0) {
                f = 0.0;
                notSet.add(OFFSET);
            }
            details.put(OFFSET, f);
        }
        f = data.getDetectorSettingsReadOutRate();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(READ_OUT_RATE);
        }
        details.put(READ_OUT_RATE, f);
        s = data.getDetectorSettingsBinning();
        if (s == null || s.trim().length() == 0) {
            notSet.add(BINNING);
        }
        details.put(BINNING, s);
        f = data.getDetectorZoom();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(ZOOM);
        }
        details.put(ZOOM, f);
        f = data.getDetectorAmplificationGain();
        if (f < 0.0) {
            f = 0.0;
            notSet.add(AMPLIFICATION);
        }
        details.put(AMPLIFICATION, f);
        s = data.getDetectorType();
        if (s == null || s.trim().length() == 0) {
            notSet.add(TYPE);
        }
        details.put(TYPE, s);
        details.put(NOT_SET, notSet);
        return details;
    }

    public static Map<String, Object> transformPlaneInfo(PlaneInfo plane) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(4);
        details.put(DELTA_T, new Double(0.0));
        details.put(EXPOSURE_TIME, new Double(0.0));
        details.put(POSITION_X, new Double(0.0));
        details.put(POSITION_Y, new Double(0.0));
        details.put(POSITION_Z, new Double(0.0));
        if (plane != null) {
            RDouble o = plane.getDeltaT();
            if (o != null) {
                details.put(DELTA_T, o.getValue());
            }
            if ((o = plane.getExposureTime()) != null) {
                details.put(EXPOSURE_TIME, o.getValue());
            }
            if ((o = plane.getPositionX()) != null) {
                details.put(POSITION_X, o.getValue());
            }
            if ((o = plane.getPositionY()) != null) {
                details.put(POSITION_Y, o.getValue());
            }
            if ((o = plane.getPositionZ()) != null) {
                details.put(POSITION_Z, o.getValue());
            }
        }
        return details;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement, Color backgoundColor) {
        OMEComboBox box = new OMEComboBox(values);
        if (backgoundColor != null) {
            box.setBackground(backgoundColor);
        }
        OMEComboBoxUI ui = new OMEComboBoxUI();
        ui.setBackgroundColor(box.getBackground());
        ui.installUI(box);
        box.setUI(ui);
        Font f = box.getFont();
        int size = f.getSize() - decrement;
        box.setBorder(null);
        box.setFont(f.deriveFont(2, size));
        return box;
    }

    public static OMEComboBox createComboBox(Object[] values, int decrement) {
        return EditorUtil.createComboBox(values, decrement, UIUtilities.BACKGROUND_COLOR);
    }

    public static OMEComboBox createComboBox(Object[] values) {
        return EditorUtil.createComboBox(values, 3);
    }

    public static OMEComboBox createComboBox(List values) {
        if (values == null) {
            return null;
        }
        Iterator i = values.iterator();
        Object[] array = new Object[values.size()];
        int index = 0;
        while (i.hasNext()) {
            array[index] = i.next();
            ++index;
        }
        return EditorUtil.createComboBox(array, 3);
    }

    public static JXTaskPane createTaskPane(String title) {
        JXTaskPane taskPane = new JXTaskPane();
        taskPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        taskPane.setTitle(title);
        taskPane.setCollapsed(true);
        Font font = taskPane.getFont();
        taskPane.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        return taskPane;
    }

    public static boolean isEditorFile(String fileName) {
        return editorFilter.accept(fileName);
    }

    static {
        LETTERS.put(1, "A");
        LETTERS.put(2, "B");
        LETTERS.put(3, "C");
        LETTERS.put(4, "D");
        LETTERS.put(5, "E");
        LETTERS.put(6, "F");
        LETTERS.put(7, "G");
        LETTERS.put(8, "H");
        LETTERS.put(9, "I");
        LETTERS.put(10, "J");
        LETTERS.put(11, "K");
        LETTERS.put(12, "L");
        LETTERS.put(13, "M");
        LETTERS.put(14, "N");
        LETTERS.put(15, "O");
        LETTERS.put(16, "P");
        LETTERS.put(17, "Q");
        LETTERS.put(18, "R");
        LETTERS.put(19, "S");
        LETTERS.put(20, "T");
        LETTERS.put(21, "U");
        LETTERS.put(22, "V");
        LETTERS.put(23, "W");
        LETTERS.put(24, "X");
        LETTERS.put(25, "Y");
        LETTERS.put(26, "Z");
        PIXELS_TYPE_DESCRIPTION = new LinkedHashMap<String, String>();
        PIXELS_TYPE_DESCRIPTION.put("int8", "Signed 8-bit (1byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint8", "Unsigned 8-bit (1 byte)");
        PIXELS_TYPE_DESCRIPTION.put("int16", "Signed 16-bit (2byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint16", "Unsigned 16-bit(2byte)");
        PIXELS_TYPE_DESCRIPTION.put("int32", "Signed 32-bit(4byte)");
        PIXELS_TYPE_DESCRIPTION.put("uint32", "Unsigned 32-bit(4byte)");
        PIXELS_TYPE_DESCRIPTION.put("float", "Floating precision");
        PIXELS_TYPE_DESCRIPTION.put("double", "Double precision");
        PIXELS_TYPE = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : PIXELS_TYPE_DESCRIPTION.entrySet()) {
            PIXELS_TYPE.put(entry.getValue(), entry.getKey());
        }
        editorFilter = new EditorFileFilter();
    }
}

