/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.IconManager;
import pojos.FileAnnotationData;
import pojos.TagAnnotationData;
import pojos.URLAnnotationData;

public class DataObjectListCellRenderer
extends DefaultListCellRenderer {
    public static final Color NEW_FOREGROUND_COLOR = Color.red;
    private IconManager icons;
    private long currentUserID;
    private EditorFileFilter filter;

    public DataObjectListCellRenderer() {
        this(-1L);
    }

    public DataObjectListCellRenderer(long currentUserID) {
        this.currentUserID = currentUserID;
        this.icons = IconManager.getInstance();
        this.filter = new EditorFileFilter();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)value;
            this.setText(tag.getTagValue());
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                this.setIcon(this.icons.getIcon(65));
            } else {
                this.setIcon(this.icons.getIcon(64));
            }
            if (tag.getId() <= 0L) {
                this.setForeground(NEW_FOREGROUND_COLOR);
            }
        } else if (value instanceof FileAnnotationData) {
            FileAnnotationData fad = (FileAnnotationData)value;
            this.setText(fad.getFileName());
            if (fad.getId() <= 0L) {
                this.setForeground(NEW_FOREGROUND_COLOR);
            }
            String format = fad.getFileFormat();
            Icon icon = this.icons.getIcon(94);
            icon = "pdf".equals(format) ? this.icons.getIcon(101) : ("txt".equals(format) || "csv".equals(format) ? this.icons.getIcon(102) : ("html".equals(format) || "htm".equals(format) ? this.icons.getIcon(108) : ("ppt".equals(format) || "pps".equals(format) ? this.icons.getIcon(106) : ("doc".equals(format) ? this.icons.getIcon(104) : ("xls".equals(format) ? this.icons.getIcon(105) : ("xml".equals(format) || "rtf".equals(format) ? (this.filter.accept(fad.getFileName()) ? ("openmicroscopy.org/omero/editor/experiment".equals(fad.getNameSpace()) ? this.icons.getIcon(117) : this.icons.getIcon(103)) : this.icons.getIcon(107)) : this.icons.getIcon(94)))))));
            this.setIcon(icon);
        } else if (value instanceof URLAnnotationData) {
            URLAnnotationData url = (URLAnnotationData)value;
            this.setText(url.getURL());
            this.setIcon(this.icons.getIcon(95));
        }
        return this;
    }
}

