/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectCreator;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectRemover;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectUpdater;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.PlateWellsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ProjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RndSettingsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.TagHierarchyLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TimeIntervalsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerModel {
    private int state;
    private DataTreeViewerLoader currentLoader;
    private Map<Integer, Browser> browsers;
    private Browser selectedBrowser;
    private long rootID;
    private long userGroupID;
    private ExperimenterData experimenter;
    private Finder finder;
    private TreeImageDisplay[] nodesToCopy;
    private int copyIndex;
    private boolean recycled;
    private boolean rollOver;
    private ImageData refImage;
    private MetadataViewer metadataViewer;
    private DataBrowser dataViewer;
    private AdvancedFinder advancedFinder;
    protected TreeViewer component;

    private Map buildCopyMap(TreeImageDisplay[] parents) {
        Object uo = this.nodesToCopy[0].getUserObject();
        Object uoParent = parents[0].getUserObject();
        if (!(uo instanceof DataObject)) {
            return null;
        }
        if (!(uoParent instanceof DataObject)) {
            return null;
        }
        DataObject obj = (DataObject)uo;
        DataObject objParent = (DataObject)uoParent;
        if (objParent instanceof ProjectData && obj instanceof DatasetData || objParent instanceof DatasetData && obj instanceof ImageData || objParent instanceof ScreenData && obj instanceof PlateData) {
            HashMap map = new HashMap(parents.length);
            for (int i = 0; i < parents.length; ++i) {
                HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                for (int j = 0; j < this.nodesToCopy.length; ++j) {
                    children.add(this.nodesToCopy[j].getUserObject());
                }
                map.put(parents[i].getUserObject(), children);
            }
            return map;
        }
        if (obj instanceof TagAnnotationData && objParent instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)obj;
            TagAnnotationData tagSet = (TagAnnotationData)objParent;
            String nsSet = tagSet.getNameSpace();
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(nsSet) && ns == null) {
                HashMap map = new HashMap(parents.length);
                for (int i = 0; i < parents.length; ++i) {
                    HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                    for (int j = 0; j < this.nodesToCopy.length; ++j) {
                        children.add(this.nodesToCopy[j].getUserObject());
                    }
                    map.put(parents[i].getUserObject(), children);
                }
                return map;
            }
        }
        return null;
    }

    private Map buildCutMap(TreeImageDisplay[] nodes) {
        HashMap<Object, HashSet<Object>> map = new HashMap<Object, HashSet<Object>>();
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay child = nodes[i];
            TreeImageDisplay parent = child.getParentDisplay();
            Object po = parent.getUserObject();
            HashSet<Object> children = (HashSet<Object>)map.get(po);
            if (children == null) {
                children = new HashSet<Object>();
                map.put(po, children);
            }
            children.add(nodes[i].getUserObject());
        }
        return map;
    }

    private void createBrowsers() {
        Browser browser;
        this.selectedBrowser = browser = BrowserFactory.createBrowser(100, this.component, this.experimenter, true);
        browser.setSelected(true);
        this.browsers.put(100, browser);
        browser = BrowserFactory.createBrowser(103, this.component, this.experimenter, true);
        this.browsers.put(103, browser);
        browser = BrowserFactory.createBrowser(102, this.component, this.experimenter, true);
        this.browsers.put(102, browser);
        browser = BrowserFactory.createBrowser(101, this.component, this.experimenter, true);
        this.browsers.put(101, browser);
        browser = BrowserFactory.createBrowser(104, this.component, this.experimenter, true);
        this.browsers.put(104, browser);
    }

    private void initialize() {
        this.state = 1;
        this.browsers = new HashMap<Integer, Browser>();
        this.recycled = false;
        this.refImage = null;
    }

    protected TreeViewerModel() {
        this.initialize();
    }

    protected TreeViewerModel(ExperimenterData exp, long userGroupID) {
        this.initialize();
        this.experimenter = exp;
        this.setHierarchyRoot(exp.getId(), userGroupID);
    }

    void initialize(TreeViewer component) {
        this.component = component;
        this.createBrowsers();
    }

    void setHierarchyRoot(long rootID, long userGroupID) {
        this.rootID = rootID;
        this.userGroupID = userGroupID;
    }

    boolean isSameDisplay(TreeViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.rootID == this.rootID && other.userGroupID == this.userGroupID;
    }

    boolean isRecycled() {
        return this.recycled;
    }

    void setRecycled(boolean b) {
        this.recycled = b;
    }

    long getUserGroupID() {
        return this.userGroupID;
    }

    void setSelectedBrowser(Browser browser) {
        this.selectedBrowser = browser;
    }

    Browser getSelectedBrowser() {
        return this.selectedBrowser;
    }

    Map getBrowsers() {
        return this.browsers;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 7;
    }

    void fireObjectsDeletion(List<DeletableObject> values) {
        this.state = 3;
        this.currentLoader = new DataObjectRemover(this.component, values);
        this.currentLoader.load();
    }

    Finder getFinder() {
        return this.finder;
    }

    void setFinder(Finder finder) {
        this.finder = finder;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setState(int state) {
        this.state = state;
    }

    void fireDataExistingObjectsLoader(DataObject ho) {
        this.state = 5;
        this.currentLoader = new ExistingObjectsLoader(this.component, ho);
        this.currentLoader.load();
    }

    void fireAddExistingObjects(Set children) {
        TreeImageDisplay parent = this.selectedBrowser.getLastSelectedDisplay();
        if (parent == null) {
            return;
        }
        Object po = parent.getUserObject();
        if (po instanceof ProjectData || po instanceof DatasetData) {
            this.currentLoader = new ExistingObjectsSaver(this.component, (DataObject)po, children);
            this.currentLoader.load();
        }
        this.state = 7;
    }

    void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        this.copyIndex = index;
        this.nodesToCopy = nodes;
    }

    TreeImageDisplay[] getNodesToCopy() {
        return this.nodesToCopy;
    }

    boolean paste(TreeImageDisplay[] parents) {
        Map map = this.buildCopyMap(parents);
        if (map == null) {
            return false;
        }
        if (this.copyIndex == 400) {
            this.currentLoader = new DataObjectUpdater(this.component, map, 0);
        } else if (this.copyIndex == 401) {
            Map toRemove = this.buildCutMap(this.nodesToCopy);
            this.currentLoader = new DataObjectUpdater(this.component, map, toRemove, 1);
        }
        this.currentLoader.load();
        this.state = 3;
        this.nodesToCopy = null;
        return true;
    }

    boolean cut() {
        if (this.copyIndex != 401) {
            return false;
        }
        if (this.nodesToCopy == null || this.nodesToCopy.length == 0) {
            return false;
        }
        Map toRemove = this.buildCutMap(this.nodesToCopy);
        this.currentLoader = new DataObjectUpdater(this.component, new HashMap(), toRemove, 2);
        this.currentLoader.load();
        this.state = 3;
        return true;
    }

    Map getAvailableUserGroups() {
        return (Map)TreeViewerAgent.getRegistry().lookup("/userGroup/details");
    }

    String getExperimenterNames() {
        ExperimenterData exp = this.getExperimenter();
        return exp.getFirstName() + " " + exp.getLastName();
    }

    ExperimenterData getExperimenter() {
        if (this.experimenter == null) {
            this.experimenter = this.getUserDetails();
        }
        return this.experimenter;
    }

    boolean isRollOver() {
        return this.rollOver;
    }

    void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }

    void setRndSettings(ImageData refImage) {
        this.refImage = refImage;
    }

    boolean hasRndSettingsToPaste() {
        return this.refImage != null;
    }

    void firePasteRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, this.refImage.getDefaultPixels().getId());
        this.currentLoader.load();
    }

    void firePasteRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, this.refImage.getDefaultPixels().getId());
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, 1);
        this.currentLoader.load();
    }

    void fireResetRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, 1);
        this.currentLoader.load();
    }

    void fireSetOriginalRenderingSettings(List<Long> ids, Class klass) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, klass, ids, 2);
        this.currentLoader.load();
    }

    void fireSetOriginalRenderingSettings(TimeRefObject ref) {
        this.state = 8;
        this.currentLoader = new RndSettingsSaver(this.component, ref, 2);
        this.currentLoader.load();
    }

    void fireDataObjectCreation(DataObject object, boolean withParent) {
        Browser browser;
        TreeImageDisplay node;
        DataObject data = null;
        if (withParent && (node = (browser = this.getSelectedBrowser()).getLastSelectedDisplay()) != null) {
            Object p = node.getUserObject();
            if (!(object instanceof ProjectData)) {
                data = (DataObject)p;
            }
        }
        this.currentLoader = new DataObjectCreator(this.component, object, data);
        this.currentLoader.load();
    }

    MetadataViewer getMetadataViewer() {
        if (this.metadataViewer == null) {
            this.metadataViewer = MetadataViewerFactory.getViewer("", false);
        }
        return this.metadataViewer;
    }

    AdvancedFinder getAdvancedFinder() {
        if (this.advancedFinder == null) {
            this.advancedFinder = FinderFactory.getAdvancedFinder(TreeViewerAgent.getRegistry());
        }
        return this.advancedFinder;
    }

    void browseProject(TreeImageDisplay node) {
        this.state = 5;
        this.currentLoader = new ProjectsLoader(this.component, node);
        this.currentLoader.load();
    }

    void browsePlate(TreeImageDisplay node) {
        this.state = 5;
        Object ho = node.getUserObject();
        this.currentLoader = new PlateWellsLoader(this.component, (TreeImageSet)node, ((PlateData)ho).getId());
        this.currentLoader.load();
    }

    void browseTimeInterval(TreeImageTimeSet node) {
        this.state = 5;
        this.currentLoader = new TimeIntervalsLoader(this.component, node);
        this.currentLoader.load();
    }

    void browseTag(TreeImageDisplay node) {
        this.state = 5;
        this.currentLoader = new TagHierarchyLoader(this.component, node);
        this.currentLoader.load();
    }

    Browser getBrowser(int index) {
        return this.browsers.get(index);
    }

    String getRefImageName() {
        if (this.refImage == null) {
            return null;
        }
        return EditorUtil.getPartialName(this.refImage.getName());
    }

    Class getDataToCopyType() {
        TreeImageDisplay[] nodes = this.getNodesToCopy();
        if (nodes == null) {
            return null;
        }
        if (nodes.length == 0) {
            return null;
        }
        Object ho = nodes[0].getUserObject();
        return ho.getClass();
    }

    void setDataViewer(DataBrowser dataViewer) {
        this.dataViewer = dataViewer;
    }

    DataBrowser getDataViewer() {
        return this.dataViewer;
    }
}

