/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerComponent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.data.events.SaveEventRequest;
import org.openmicroscopy.shoola.env.data.events.SaveEventResponse;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerFactory
implements ChangeListener {
    private static final String NAME = "Data Manager";
    private static final String MENU_NAME = "Data Manager";
    private static final TreeViewerFactory singleton = new TreeViewerFactory();
    private Set<TreeViewer> viewers = new HashSet<TreeViewer>();
    private JMenu windowMenu = new JMenu("Data Manager");
    private boolean isAttached = false;

    static JMenu getWindowMenu() {
        return TreeViewerFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return TreeViewerFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (TreeViewerFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, TreeViewerFactory.singleton.windowMenu);
        TreeViewerFactory.singleton.isAttached = true;
    }

    static Set getViewers() {
        return TreeViewerFactory.singleton.viewers;
    }

    static boolean isLastViewer() {
        return TreeViewerFactory.singleton.viewers.size() <= 1;
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, null);
    }

    public static void copyRndSettings(ImageData image) {
        for (TreeViewerComponent treeViewerComponent : TreeViewerFactory.singleton.viewers) {
            treeViewerComponent.setRndSettings(image);
        }
    }

    public static void saveOnClose(SaveEventRequest evt, Object agent) {
        Iterator<TreeViewer> v = TreeViewerFactory.singleton.viewers.iterator();
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        while (v.hasNext()) {
            TreeViewerComponent comp = (TreeViewerComponent)v.next();
            comp.saveOnClose((SaveData)evt.getAnswer());
            bus.post(new SaveEventResponse(evt, (Agent)agent));
        }
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID, Rectangle bounds) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, bounds);
    }

    public static Map<String, Set> hasDataToSave() {
        HashSet<SaveEventRequest> events = new HashSet<SaveEventRequest>();
        for (TreeViewerComponent treeViewerComponent : TreeViewerFactory.singleton.viewers) {
            if (!treeViewerComponent.hasDataToSave()) continue;
            SaveData event = new SaveData(2);
            event.setMessage("Edited data");
            events.add(new SaveEventRequest(treeViewerComponent, event));
        }
        if (events.size() != 0) {
            HashMap<String, Set> m = new HashMap<String, Set>();
            m.put("Data Manager", events);
            return m;
        }
        return null;
    }

    private TreeViewerFactory() {
    }

    private TreeViewer getTreeViewer(TreeViewerModel model, Rectangle bounds) {
        for (TreeViewerComponent treeViewerComponent : this.viewers) {
            if (!model.isSameDisplay(treeViewerComponent.getModel())) continue;
            treeViewerComponent.setRecycled(true);
            return treeViewerComponent;
        }
        TreeViewerComponent treeViewerComponent = new TreeViewerComponent(model);
        model.initialize(treeViewerComponent);
        treeViewerComponent.initialize(bounds);
        treeViewerComponent.addChangeListener(this);
        this.viewers.add(treeViewerComponent);
        return treeViewerComponent;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        TreeViewerComponent comp = (TreeViewerComponent)ce.getSource();
        if (comp.getState() == 2) {
            this.viewers.remove(comp);
        }
    }
}

