/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.AddAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowseContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ClearAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CopyAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CopyRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CreateTopContainerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CutAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.DeleteAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.EditorAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ExitApplicationAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.FinderAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.NewObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PasteAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.PasteRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RefreshTreeAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RemoveExperimenterNode;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ResetRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RollOverAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SearchAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SetRndSettingsAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SwitchUserAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TaggingAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ViewImageAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CopyCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CutCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.DeleteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteRndSettingsCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

class TreeViewerControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer BROWSE = 1;
    static final Integer CREATE_OBJECT = 3;
    static final Integer COPY_OBJECT = 4;
    static final Integer PASTE_OBJECT = 5;
    static final Integer DELETE_OBJECT = 6;
    static final Integer HIERARCHY_EXPLORER = 7;
    static final Integer IMAGES_EXPLORER = 9;
    static final Integer FIND = 10;
    static final Integer EXIT = 14;
    static final Integer CLEAR = 15;
    static final Integer ADD_OBJECT = 16;
    static final Integer CREATE_TOP_PROJECT = 17;
    static final Integer REFRESH_TREE = 18;
    static final Integer MANAGER = 19;
    static final Integer CUT_OBJECT = 21;
    static final Integer ACTIVATION = 22;
    static final Integer SWITCH_USER = 23;
    static final Integer ROLL_OVER = 26;
    static final Integer REMOVE_FROM_DISPLAY = 27;
    static final Integer REFRESH_EXPERIMENTER = 29;
    static final Integer PASTE_RND_SETTINGS = 31;
    static final Integer COPY_RND_SETTINGS = 32;
    static final Integer RESET_RND_SETTINGS = 33;
    static final Integer SEARCH = 34;
    static final Integer TAGS_EXPLORER = 35;
    static final Integer SET_RND_SETTINGS = 36;
    static final Integer CREATE_TOP_DATASET = 37;
    static final Integer CREATE_TOP_TAG = 38;
    static final Integer SCREENS_EXPLORER = 39;
    static final Integer CREATE_TOP_SCREEN = 40;
    static final Integer VIEW = 41;
    static final Integer NEW_OBJECT = 42;
    static final Integer EDITOR_NO_SELECTION = 43;
    static final Integer FILES_EXPLORER = 44;
    static final Integer CREATE_TOP_TAG_SET = 45;
    static final Integer NEW_TAG_OBJECT = 46;
    static final Integer TAGGING = 47;
    static final Integer EDITOR_WITH_SELECTION = 48;
    static final Integer EDITOR_NEW_WITH_SELECTION = 49;
    private TreeViewer model;
    private TreeViewerWin view;
    private Map<Integer, TreeViewerAction> actionsMap;
    private ChangeListener tabsListener;
    private LoadingWindow loadingWindow;

    private void createActions() {
        this.actionsMap.put(BROWSE, new BrowseContainerAction(this.model));
        this.actionsMap.put(CREATE_OBJECT, new CreateAction(this.model));
        this.actionsMap.put(COPY_OBJECT, new CopyAction(this.model));
        this.actionsMap.put(DELETE_OBJECT, new DeleteAction(this.model));
        this.actionsMap.put(PASTE_OBJECT, new PasteAction(this.model));
        this.actionsMap.put(SCREENS_EXPLORER, new BrowserSelectionAction(this.model, 103));
        this.actionsMap.put(HIERARCHY_EXPLORER, new BrowserSelectionAction(this.model, 100));
        this.actionsMap.put(TAGS_EXPLORER, new BrowserSelectionAction(this.model, 102));
        this.actionsMap.put(IMAGES_EXPLORER, new BrowserSelectionAction(this.model, 101));
        this.actionsMap.put(FILES_EXPLORER, new BrowserSelectionAction(this.model, 104));
        this.actionsMap.put(FIND, new FinderAction(this.model));
        this.actionsMap.put(CLEAR, new ClearAction(this.model));
        this.actionsMap.put(EXIT, new ExitApplicationAction(this.model));
        this.actionsMap.put(ADD_OBJECT, new AddAction(this.model));
        this.actionsMap.put(CREATE_TOP_PROJECT, new CreateTopContainerAction(this.model, 0));
        this.actionsMap.put(CREATE_TOP_DATASET, new CreateTopContainerAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG, new CreateTopContainerAction(this.model, 2));
        this.actionsMap.put(REFRESH_TREE, new RefreshTreeAction(this.model));
        this.actionsMap.put(MANAGER, new ManagerAction(this.model));
        this.actionsMap.put(CUT_OBJECT, new CutAction(this.model));
        this.actionsMap.put(ACTIVATION, new ActivationAction(this.model));
        this.actionsMap.put(SWITCH_USER, new SwitchUserAction(this.model));
        this.actionsMap.put(ROLL_OVER, new RollOverAction(this.model));
        this.actionsMap.put(REMOVE_FROM_DISPLAY, new RemoveExperimenterNode(this.model));
        this.actionsMap.put(REFRESH_EXPERIMENTER, new RefreshExperimenterData(this.model));
        this.actionsMap.put(PASTE_RND_SETTINGS, new PasteRndSettingsAction(this.model));
        this.actionsMap.put(COPY_RND_SETTINGS, new CopyRndSettingsAction(this.model));
        this.actionsMap.put(RESET_RND_SETTINGS, new ResetRndSettingsAction(this.model));
        this.actionsMap.put(SEARCH, new SearchAction(this.model));
        this.actionsMap.put(SET_RND_SETTINGS, new SetRndSettingsAction(this.model));
        this.actionsMap.put(CREATE_TOP_SCREEN, new CreateTopContainerAction(this.model, 3));
        this.actionsMap.put(VIEW, new ViewImageAction(this.model));
        this.actionsMap.put(NEW_OBJECT, new NewObjectAction(this.model, 1));
        this.actionsMap.put(EDITOR_NO_SELECTION, new EditorAction(this.model, 0));
        this.actionsMap.put(EDITOR_WITH_SELECTION, new EditorAction(this.model, 1));
        this.actionsMap.put(CREATE_TOP_TAG_SET, new CreateTopContainerAction(this.model, 6));
        this.actionsMap.put(NEW_TAG_OBJECT, new NewObjectAction(this.model, 0));
        this.actionsMap.put(TAGGING, new TaggingAction(this.model));
        this.actionsMap.put(EDITOR_NEW_WITH_SELECTION, new EditorAction(this.model, 2));
    }

    private void createWindowsMenuItems(JMenu menu) {
        Set viewers = TreeViewerFactory.getViewers();
        Iterator i = viewers.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction((TreeViewer)i.next())));
        }
    }

    private void attachListeners() {
        Map browsers = this.model.getBrowsers();
        for (Browser browser : browsers.values()) {
            browser.addPropertyChangeListener(this);
            browser.addChangeListener(this);
        }
        this.model.addPropertyChangeListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TreeViewerControl.this.model.closeWindow();
            }
        });
        JMenu menu = TreeViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    TreeViewerControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
    }

    TreeViewerControl(TreeViewer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, TreeViewerAction>();
    }

    void initialize(TreeViewerWin view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.model.addChangeListener(this);
        this.attachListeners();
        TreeViewerFactory.attachWindowMenuToTaskBar();
        this.loadingWindow = new LoadingWindow(view);
        this.loadingWindow.setAlwaysOnTop(false);
        this.loadingWindow.setStatus("Saving changes");
    }

    ChangeListener getTabbedListener() {
        if (this.tabsListener == null) {
            this.tabsListener = new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JTabbedPane pane = (JTabbedPane)ce.getSource();
                    TreeViewerControl.this.model.clearFoundResults();
                    Component c = pane.getSelectedComponent();
                    if (c == null) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                        return;
                    }
                    Map browsers = TreeViewerControl.this.model.getBrowsers();
                    Iterator i = browsers.values().iterator();
                    boolean selected = false;
                    while (i.hasNext()) {
                        Browser browser = (Browser)i.next();
                        if (!c.equals(browser.getUI())) continue;
                        TreeViewerControl.this.model.setSelectedBrowser(browser);
                        selected = true;
                        break;
                    }
                    if (!selected) {
                        TreeViewerControl.this.model.setSelectedBrowser(null);
                    }
                }
            };
        }
        return this.tabsListener;
    }

    void attachUIListeners(JTabbedPane tabs) {
        tabs.addChangeListener(this.getTabbedListener());
    }

    TreeViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void cancel() {
        this.model.cancel();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if (name == null) {
            return;
        }
        if (name.equals("cancelLoading")) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.cancel();
            }
        } else if (name.equals("popupMenu")) {
            Integer c = (Integer)pce.getNewValue();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                this.view.showPopup(c, browser.getClickComponent(), browser.getClickPoint());
            }
        } else if (name.equals("close")) {
            Browser browser = (Browser)pce.getNewValue();
            if (browser != null) {
                this.view.removeBrowser(browser);
            }
        } else if (name.equals("finderVisible")) {
            Boolean b = (Boolean)pce.getNewValue();
            if (!b.booleanValue()) {
                this.model.clearFoundResults();
                this.model.onComponentStateChange(true);
            }
        } else if (name.equals("selectedBrowser")) {
            Browser b = this.model.getSelectedBrowser();
            for (Browser browser : this.model.getBrowsers().values()) {
                browser.setSelected(browser.equals(b));
            }
        } else if (name.equals("selectedTreeNodeDisplay")) {
            this.model.onSelectedDisplay();
            this.view.updateMenuItems();
        } else if (!name.equals("hierarchyRoot")) {
            if (name.equals("existingAdd")) {
                this.model.addExistingObjects((Set)pce.getNewValue());
            } else if ("userSwitch".equals(name)) {
                Map m = (Map)pce.getNewValue();
                Iterator i = m.entrySet().iterator();
                if (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Long groupID = (Long)entry.getKey();
                    ExperimenterData d = (ExperimenterData)entry.getValue();
                    this.model.setHierarchyRoot(groupID, d);
                }
            } else if ("noUserSwitch".equals(name)) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("User Selection", "Please select a user first.");
            } else if ("create".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, true);
            } else if ("createNoParent".equals(name)) {
                DataObject data = (DataObject)pce.getNewValue();
                this.model.createObject(data, false);
            } else if ("onDataSave".equals(name)) {
                Object object = pce.getNewValue();
                if (object != null) {
                    if (object instanceof DataObject) {
                        this.model.onDataObjectSave((DataObject)object, 301);
                    } else {
                        this.model.onDataObjectSave((List)object, 301);
                    }
                }
            } else if ("selectedNodeDisplay".equals(name)) {
                this.model.setSelectedNode(pce.getNewValue());
            } else if ("unselectedNodeDisplay".equals(name)) {
                this.model.setUnselectedNode(pce.getNewValue());
            } else if ("dataObjectCreated".equals(name)) {
                Map map = (Map)pce.getNewValue();
                if (map != null && map.size() == 1) {
                    DataObject data = null;
                    Set set = map.entrySet();
                    Iterator i = set.iterator();
                    DataObject parent = null;
                    if (i.hasNext()) {
                        Map.Entry entry = i.next();
                        data = (DataObject)entry.getKey();
                        Object o = entry.getValue();
                        if (o != null) {
                            parent = (DataObject)o;
                        }
                    }
                    if (parent == null) {
                        this.model.onOrphanDataObjectCreated(data);
                    } else {
                        this.model.onDataObjectSave(data, parent, 300);
                    }
                }
            } else if ("copyRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                if (data != null) {
                    this.model.copyRndSettings((ImageData)data);
                } else {
                    this.model.copyRndSettings(null);
                }
            } else if ("pasteRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 0, (Collection)data) : new PasteRndSettingsCmd(this.model, 0);
                cmd.execute();
            } else if ("resetRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 1, (Collection)data) : new PasteRndSettingsCmd(this.model, 1);
                cmd.execute();
            } else if ("setOriginalRndSettings".equals(name)) {
                Object data = pce.getNewValue();
                PasteRndSettingsCmd cmd = data instanceof Collection ? new PasteRndSettingsCmd(this.model, 2, (Collection)data) : new PasteRndSettingsCmd(this.model, 2);
                cmd.execute();
            } else if ("cutItems".equals(name)) {
                CutCmd cmd = new CutCmd(this.model);
                cmd.execute();
            } else if ("copyItems".equals(name)) {
                CopyCmd cmd = new CopyCmd(this.model);
                cmd.execute();
            } else if ("pasteItems".equals(name)) {
                PasteCmd cmd = new PasteCmd(this.model);
                cmd.execute();
            } else if ("removeItems".equals(name)) {
                DeleteCmd cmd = new DeleteCmd(this.model);
                cmd.execute();
            } else if ("resultsFound".equals(name)) {
                this.model.setSearchResult(pce.getNewValue());
            } else if ("saveGeneric".equals(name)) {
                Object parent = pce.getNewValue();
                if (parent instanceof MetadataViewer) {
                    MetadataViewer mv = (MetadataViewer)parent;
                    mv.saveData();
                }
            } else if ("dataRefreshed".equals(name)) {
                this.model.onSelectedDisplay();
            } else if ("experimenterUpdated".equals(name)) {
                Map browsers = this.model.getBrowsers();
                Set set = browsers.entrySet();
                for (Map.Entry entry : set) {
                    Browser browser = (Browser)entry.getValue();
                    browser.refreshExperimenter();
                }
            } else if ("tagWizard".equals(name)) {
                this.model.showTagWizard();
            } else if ("createNewExperiment".equals(name)) {
                this.model.openEditorFile(2);
            }
        }
    }

    public void stateChanged(ChangeEvent ce) {
        switch (this.model.getSelectedBrowser().getState()) {
            case 14: {
                this.loadingWindow.setStatus("Loading Data...");
                UIUtilities.centerAndShow(this.loadingWindow);
                return;
            }
            case 15: {
                this.loadingWindow.setVisible(false);
            }
        }
        switch (this.model.getState()) {
            case 2: {
                this.view.closeViewer();
                break;
            }
            case 5: {
                this.view.setStatus("Loading Data...", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 3: {
                this.view.setStatus("Saving Data", false);
                this.view.setStatusIcon(true);
                this.view.onStateChanged(false);
                break;
            }
            case 6: 
            case 7: {
                this.loadingWindow.setVisible(false);
                this.view.setStatus(null, true);
                this.view.setStatusIcon(false);
                this.view.onStateChanged(true);
                this.view.requestFocus();
                break;
            }
            case 8: {
                UIUtilities.centerAndShow(this.loadingWindow);
            }
        }
    }
}

