/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.treeviewer.CopyItems;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.finder.ClearVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.util.AddExistingObjectsDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.GenericDialog;
import org.openmicroscopy.shoola.agents.treeviewer.util.NotDeletedObjectDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.DeleteBox;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.UserManagerDialog;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeViewerComponent
extends AbstractComponent
implements TreeViewer {
    private TreeViewerModel model;
    private TreeViewerControl controller;
    private TreeViewerWin view;
    private UserManagerDialog switchUserDialog;

    private void displayUserGroups(Map map) {
        if (this.switchUserDialog == null) {
            JFrame f = (JFrame)((Object)TreeViewerAgent.getRegistry().getTaskBar());
            IconManager icons = IconManager.getInstance();
            this.switchUserDialog = new UserManagerDialog(f, this.model.getUserDetails(), map, icons.getIcon(23), icons.getIcon(56));
            this.switchUserDialog.addPropertyChangeListener(this.controller);
            this.switchUserDialog.setDefaultSize();
        }
        UIUtilities.centerAndShow(this.switchUserDialog);
    }

    private void showDataBrowser(Object object, TreeImageDisplay display) {
        DataBrowser db = null;
        TreeImageDisplay parent = null;
        Browser browser = this.model.getSelectedBrowser();
        if (display != null) {
            parent = display.getParentDisplay();
        }
        if (object instanceof ImageData) {
            if (parent != null) {
                Object ho = parent.getUserObject();
                db = DataBrowserFactory.getDataBrowser(ho);
                if (db != null) {
                    db.setComponentTitle("");
                    this.view.removeAllFromWorkingPane();
                    this.view.addComponent(db.getUI());
                    db.setSelectedNodes(browser.getSelectedDataObjects());
                } else if (DataBrowserFactory.hasBeenDiscarded(ho)) {
                    List l;
                    if (parent.isChildrenLoaded() && (l = parent.getChildrenDisplay()) != null) {
                        TagAnnotationData tag;
                        HashSet<Object> s = new HashSet<Object>();
                        Iterator i = l.iterator();
                        if (ho instanceof DatasetData) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            db.setSelectedNodes(browser.getSelectedDataObjects());
                        } else if (ho instanceof TagAnnotationData && (tag = (TagAnnotationData)ho).getTags() == null) {
                            while (i.hasNext()) {
                                TreeImageDisplay child = (TreeImageDisplay)i.next();
                                s.add(child.getUserObject());
                            }
                            this.setLeaves((TreeImageSet)parent, s);
                            db = DataBrowserFactory.getDataBrowser(ho);
                            db.setSelectedNodes(browser.getSelectedDataObjects());
                        }
                    }
                } else {
                    this.showDataBrowser(object, parent.getParentDisplay());
                }
            } else {
                this.view.removeAllFromWorkingPane();
            }
        } else {
            db = DataBrowserFactory.getDataBrowser(object);
            if (db != null) {
                db.setComponentTitle("");
                this.view.removeAllFromWorkingPane();
                this.view.addComponent(db.getUI());
                if (object instanceof DataObject) {
                    ArrayList<DataObject> nodes = new ArrayList<DataObject>();
                    nodes.add((DataObject)object);
                    db.setSelectedNodes(nodes);
                }
            } else {
                List l;
                this.view.removeAllFromWorkingPane();
                if (display != null && display.isChildrenLoaded() && (l = display.getChildrenDisplay()) != null) {
                    TagAnnotationData tag;
                    HashSet<Object> s = new HashSet<Object>();
                    Iterator i = l.iterator();
                    if (object instanceof DatasetData) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        db.setSelectedNodes(browser.getSelectedDataObjects());
                    } else if (object instanceof TagAnnotationData && (tag = (TagAnnotationData)object).getTags() == null) {
                        while (i.hasNext()) {
                            TreeImageDisplay child = (TreeImageDisplay)i.next();
                            s.add(child.getUserObject());
                        }
                        this.setLeaves((TreeImageSet)display, s);
                        db = DataBrowserFactory.getDataBrowser(display.getUserObject());
                        db.setSelectedNodes(browser.getSelectedDataObjects());
                    }
                }
            }
        }
        this.model.setDataViewer(db);
    }

    TreeViewerComponent(TreeViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new TreeViewerControl(this);
        this.view = new TreeViewerWin();
        Finder f = new Finder(this);
        model.setFinder(f);
        f.addPropertyChangeListener(this.controller);
    }

    void initialize(Rectangle bounds) {
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, bounds);
        this.model.getMetadataViewer().addPropertyChangeListener(this.controller);
    }

    void setRndSettings(ImageData image) {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.setRndSettings(image);
    }

    TreeViewerModel getModel() {
        return this.model;
    }

    void setRecycled(boolean b) {
        this.model.setRecycled(b);
    }

    void saveOnClose(SaveData evt) {
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.model.getSelectedBrowser().activate();
                this.view.setOnScreen();
                this.model.setState(7);
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public Map getBrowsers() {
        return this.model.getBrowsers();
    }

    @Override
    public void discard() {
        Map browsers = this.getBrowsers();
        Iterator i = browsers.values().iterator();
        while (i.hasNext()) {
            ((Browser)i.next()).discard();
        }
        this.model.discard();
        this.fireStateChange();
    }

    @Override
    public Browser getSelectedBrowser() {
        return this.model.getSelectedBrowser();
    }

    @Override
    public void setSelectedBrowser(Browser browser) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Browser oldBrowser = this.model.getSelectedBrowser();
        if (oldBrowser == null || !oldBrowser.equals(browser)) {
            this.model.setSelectedBrowser(browser);
            if (browser != null) {
                browser.activate();
            }
            this.removeEditor();
            this.model.getMetadataViewer().setSelectionMode(false);
            this.firePropertyChange("selectedBrowser", oldBrowser, browser);
        }
        this.view.updateMenuItems();
    }

    @Override
    public void displayBrowser(int browserType) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(browserType);
        if (browser.isDisplayed()) {
            this.view.removeBrowser(browser);
        } else {
            this.model.setSelectedBrowser(browser);
            this.view.addBrowser(browser);
        }
        browser.setDisplayed(!browser.isDisplayed());
        this.removeEditor();
    }

    @Override
    public void createDataObject(DataObject object, boolean withParent) {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or SAVE state.");
            }
        }
        if (object == null) {
            return;
        }
        EditorDialog d = null;
        if (object instanceof ProjectData || object instanceof DatasetData || object instanceof ScreenData || object instanceof TagAnnotationData) {
            d = new EditorDialog(this.view, object, withParent);
        }
        if (d != null) {
            d.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(d);
        }
    }

    @Override
    public void cancel() {
        if (this.model.getState() != 2) {
            this.model.cancel();
            this.fireStateChange();
        }
    }

    @Override
    public void removeEditor() {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        this.view.removeAllFromWorkingPane();
        this.model.getMetadataViewer().setRootObject(null);
        this.firePropertyChange("removeEditor", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public ExperimenterData getUserDetails() {
        return this.model.getUserDetails();
    }

    @Override
    public void showFinder(boolean b) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method should cannot be invoked in the DISCARDED state.");
            }
        }
        if (this.model.getSelectedBrowser() == null) {
            return;
        }
        Finder finder = this.model.getFinder();
        if (b == finder.isDisplay()) {
            return;
        }
        Boolean oldValue = finder.isDisplay() ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = b ? Boolean.TRUE : Boolean.FALSE;
        this.view.showFinder(b);
        this.firePropertyChange("finderVisible", oldValue, newValue);
    }

    @Override
    public void closeWindow() {
        this.cancel();
        if (TreeViewerFactory.isLastViewer()) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            bus.post(new ExitApplication());
        } else {
            this.discard();
        }
    }

    @Override
    public void onSelectedDisplay() {
        boolean single;
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE state.");
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay display = browser.getLastSelectedDisplay();
        MetadataViewer metadata = this.model.getMetadataViewer();
        TreeImageDisplay[] selection = browser.getSelectedDisplays();
        boolean bl = single = selection.length == 1;
        if (display instanceof TreeImageTimeSet) {
            single = false;
            TreeImageTimeSet time = (TreeImageTimeSet)display;
            if (!time.containsImages()) {
                metadata.setRootObject(null);
                return;
            }
        }
        metadata.setSelectionMode(single);
        if (display != null) {
            Object object = display.getUserObject();
            metadata.setRootObject(object);
            if (!single) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 0; i < selection.length; ++i) {
                    Object child = selection[i].getUserObject();
                    if (child.equals(object)) continue;
                    l.add(child);
                }
                if (l.size() > 0) {
                    metadata.setRelatedNodes(l);
                }
            }
            this.showDataBrowser(object, display);
        } else {
            metadata.setRootObject(null);
        }
    }

    @Override
    public void setSelectedNode(Object object) {
        WellSampleData ws;
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not valid", "The selected image is not valid.");
                return;
            }
        } else if (selected instanceof WellSampleData && (ws = (WellSampleData)selected).getId() < 0L) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Well Not valid", "The selected well is not valid.");
            return;
        }
        MetadataViewer mv = this.model.getMetadataViewer();
        if (this.hasDataToSave()) {
            MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified \ndata before selecting a new item?");
            if (dialog.centerMsgBox() == 1) {
                mv.saveData();
            } else {
                mv.clearDataToSave();
            }
        }
        Collection siblings = (Collection)l.get(0);
        int size = siblings.size();
        if (this.view.getDisplayMode() != 101) {
            Browser browser = this.model.getSelectedBrowser();
            browser.onSelectedNode(parent, selected, size > 0);
        }
        mv.setSelectionMode(size == 0);
        mv.setRootObject(selected);
        if (size > 0) {
            mv.setRelatedNodes(siblings);
        }
    }

    @Override
    public void onDataObjectSave(DataObject data, int operation) {
        this.onDataObjectSave(data, null, operation);
    }

    @Override
    public void onDataObjectSave(DataObject data, DataObject parent, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = null;
        if (operation == 300) {
            if (parent == null) {
                if (data instanceof ProjectData || data instanceof DatasetData) {
                    browser = this.model.getBrowser(100);
                } else if (data instanceof ScreenData) {
                    browser = this.model.getBrowser(103);
                } else if (data instanceof TagAnnotationData) {
                    browser = this.model.getBrowser(102);
                }
            }
            if (browser != null) {
                this.model.setSelectedBrowser(browser);
                this.view.addBrowser(browser);
                this.removeEditor();
            }
        }
        browser = this.model.getSelectedBrowser();
        browser.refreshEdition(data, parent, operation);
        if (operation == 302 || operation == 300) {
            DataBrowserFactory.discardAll();
            this.view.removeAllFromWorkingPane();
        }
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onOrphanDataObjectCreated(DataObject data) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        Browser browser = this.model.getSelectedBrowser();
        browser.onOrphanDataObjectCreated(data);
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onDataObjectSave(List data, int operation) {
        int state = this.model.getState();
        if (operation == 302 && state != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        switch (state) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
            }
        }
        if (data == null) {
            throw new IllegalArgumentException("No data object. ");
        }
        switch (operation) {
            case 300: 
            case 301: 
            case 302: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Save operation not supported.");
            }
        }
        if (operation == 302) {
            this.model.setState(7);
            this.fireStateChange();
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void clearFoundResults() {
        switch (this.model.getState()) {
            case 2: 
            case 3: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE or LOADING_THUMBNAIL state");
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (browser != null) {
            browser.accept(new ClearVisitor());
            browser.setFoundInBrowser(null);
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onImageClassified(ImageData[] images, Set categories, int mode) {
        switch (this.model.getState()) {
            case 2: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, SAVE or LOADING_THUMBNAIL state");
            }
        }
        if (categories == null) {
            throw new IllegalArgumentException("Categories shouln't be null.");
        }
        if (images == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (images.length == 0) {
            throw new IllegalArgumentException("No image.");
        }
        TreeImageDisplay d = this.getSelectedBrowser().getLastSelectedDisplay();
        Map browsers = this.model.getBrowsers();
        Iterator b = browsers.keySet().iterator();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        while (b.hasNext()) {
            Browser browser = (Browser)browsers.get(b.next());
            browser.refreshTree();
        }
        this.getSelectedBrowser().setSelectedDisplay(d);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void moveToBack() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toBack();
    }

    @Override
    public void moveToFront() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.view.toFront();
    }

    @Override
    public void setHierarchyRoot(long userGroupID, ExperimenterData experimenter) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (experimenter == null) {
            return;
        }
        Map browsers = this.model.getBrowsers();
        Iterator i = browsers.keySet().iterator();
        Browser selected = this.model.getSelectedBrowser();
        while (i.hasNext()) {
            Browser browser;
            browser.addExperimenter(experimenter, (browser = (Browser)browsers.get(i.next())) == selected);
        }
    }

    @Override
    public boolean isObjectWritable(Object ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        long groupId = this.model.getUserGroupID();
        return EditorUtil.isWritable(ho, id, groupId);
    }

    @Override
    public void addExistingObjects(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (ho == null) {
            throw new IllegalArgumentException("No object.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.model.fireDataExistingObjectsLoader(ho);
        this.fireStateChange();
    }

    @Override
    public void setExistingObjects(Set nodes) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new IllegalArgumentException("Nodes cannot be null.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        Set n = TreeViewerTranslator.transformIntoCheckNodes(nodes, this.getUserDetails().getId(), this.model.getUserGroupID());
        this.model.setState(6);
        AddExistingObjectsDialog dialog = new AddExistingObjectsDialog(this.view, n);
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    @Override
    public void addExistingObjects(Set set) {
        if (this.model.getState() != 6) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        if (set == null || set.size() == 0) {
            this.model.setState(7);
        } else {
            this.model.fireAddExistingObjects(set);
        }
        this.fireStateChange();
    }

    @Override
    public void showMenu(int menuID, Component c, Point p) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        switch (menuID) {
            case 0: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
        this.view.showMenu(menuID, c, p);
    }

    @Override
    public void setStatus(boolean enable, String text, boolean hide) {
        this.view.setStatus(text, hide);
        this.view.setStatusIcon(enable);
    }

    @Override
    public void onComponentStateChange(boolean b) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null) {
            browser.onComponentStateChange(b);
        }
        this.view.onStateChanged(b);
        this.firePropertyChange("onComponentStateChanged", !b, b);
    }

    @Override
    public void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (nodes == null || nodes.length == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Copy action", "You first need to select the nodes to copy.");
            return;
        }
        switch (index) {
            case 400: 
            case 401: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        this.model.setNodesToCopy(nodes, index);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyItems(this.model.getDataToCopyType()));
        if (index == 401 && this.model.cut()) {
            this.fireStateChange();
        }
    }

    @Override
    public void paste(TreeImageDisplay[] parents) {
        TreeImageDisplay[] nodes;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        if (parents == null || parents.length == 0) {
            un.notifyInfo("Paste action", "You first need to select the nodes to copy into");
        }
        if ((nodes = this.model.getNodesToCopy()) == null || nodes.length == 0) {
            return;
        }
        boolean b = this.model.paste(parents);
        if (!b) {
            un.notifyInfo("Paste action", "The nodes to copy cannot be added to the selected nodes.");
        } else {
            this.fireStateChange();
        }
    }

    @Override
    public JFrame getUI() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    @Override
    public boolean hasDataToSave() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return false;
        }
        return metadata.hasDataToSave();
    }

    @Override
    public void showPreSavingDialog() {
        MetadataViewer metadata = this.model.getMetadataViewer();
        if (metadata == null) {
            return;
        }
        if (!metadata.hasDataToSave()) {
            return;
        }
        MessageBox dialog = new MessageBox(this.view, "Save data", "Do you want to save the modified \ndata before selecting a new item?");
        if (dialog.centerMsgBox() == 1) {
            this.model.getMetadataViewer().saveData();
        } else {
            this.model.getMetadataViewer().clearDataToSave();
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                browser.setSelectedNode();
            }
        }
    }

    @Override
    public long getUserGroupID() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getUserGroupID();
    }

    @Override
    public void retrieveUserGroups() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.displayUserGroups(this.model.getAvailableUserGroups());
    }

    @Override
    public String getExperimenterNames() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getExperimenterNames();
    }

    @Override
    public ExperimenterData getSelectedExperimenter() {
        TreeImageDisplay node;
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        Browser b = this.model.getSelectedBrowser();
        ExperimenterData exp = this.model.getExperimenter();
        if (b != null && (node = b.getLastSelectedDisplay()) != null) {
            exp = b.getNodeOwner(node);
        }
        return exp;
    }

    @Override
    public boolean isRecycled() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRecycled();
    }

    @Override
    public boolean isRollOver() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.isRollOver();
    }

    @Override
    public void setRollOver(boolean rollOver) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setRollOver(rollOver);
    }

    @Override
    public boolean isReadable(DataObject ho) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = this.model.getUserDetails().getId();
        long groupId = this.model.getUserGroupID();
        return EditorUtil.isReadable(ho, id, groupId);
    }

    @Override
    public void removeExperimenterData() {
        Browser browser = this.model.getSelectedBrowser();
        TreeImageDisplay expNode = browser.getLastSelectedDisplay();
        Object uo = expNode.getUserObject();
        if (uo == null || !(uo instanceof ExperimenterData)) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)uo;
        Map browsers = this.model.getBrowsers();
        Iterator i = browsers.keySet().iterator();
        while (i.hasNext()) {
            browser = (Browser)browsers.get(i.next());
            browser.removeExperimenter(exp);
        }
    }

    @Override
    public boolean hasRndSettings() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.hasRndSettingsToPaste();
    }

    @Override
    public void pasteRndSettings(List<Long> ids, Class klass) {
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. \n Please first copy settings.");
            return;
        }
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodes \nyou wish to apply the settings to.");
            return;
        }
        this.model.firePasteRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void pasteRndSettings(TimeRefObject ref) {
        if (!this.hasRndSettings()) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "No rendering settings topaste. Please first copy settings.");
            return;
        }
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste settings", "Please select the nodesyou wish to apply the settings to.");
            return;
        }
        this.model.firePasteRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void rndSettingsPasted(Map map) {
        if (map == null || map.size() != 2) {
            return;
        }
        Collection failure = (Collection)map.get(Boolean.FALSE);
        Collection success = (Collection)map.get(Boolean.TRUE);
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new RndSettingsCopied(success, -1L));
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        this.model.setState(7);
        this.fireStateChange();
        String name = this.model.getRefImageName();
        int n = success.size();
        String text = "The rendering settings ";
        if (name != null && name.length() > 0) {
            text = text + "of " + name;
        }
        if (failure.size() == 0) {
            text = text + "\nhave been applied to the selected image";
            text = n > 1 ? text + "s." : text + ".";
            un.notifyInfo("Rendering Settings Applied", text);
        } else {
            String s = "";
            Iterator i = failure.iterator();
            int index = 1;
            int size = failure.size();
            while (i.hasNext()) {
                s = s + (Long)i.next();
                if (index != size) {
                    s = index % 10 == 0 ? s + "\n" : s + ", ";
                }
                ++index;
            }
            s = s.trim();
            un.notifyInfo("Rendering Settings Applied", text + "\ncould not be applied to the following images with ID:" + "\n" + s);
            DataBrowser db = this.model.getDataViewer();
            if (db != null) {
                db.markUnmodifiedNodes(ImageData.class, failure);
            }
        }
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        this.model.fireResetRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void resetRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Reset settings", "Please select at one element.");
            return;
        }
        this.model.fireResetRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void createObject(DataObject object, boolean withParent) {
        if (this.model.getState() == 2) {
            return;
        }
        if (object == null) {
            return;
        }
        this.model.fireDataObjectCreation(object, withParent);
        this.fireStateChange();
    }

    @Override
    public void setLeaves(TreeImageSet parent, Set leaves) {
        if (parent instanceof TreeFileSet) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = null;
        db = parentObject instanceof TagAnnotationData ? DataBrowserFactory.getTagsBrowser((TagAnnotationData)parentObject, leaves, false) : DataBrowserFactory.getDataBrowser(grandParentObject, parentObject, leaves);
        db.addPropertyChangeListener(this.controller);
        db.activate();
        this.view.addComponent(db.getUI());
        this.model.setDataViewer(db);
    }

    @Override
    public void browseHierarchyRoots(Object parent, Collection roots) {
        TreeImageDisplay display;
        List l;
        if (roots == null) {
            return;
        }
        Iterator i = roots.iterator();
        ObservableComponent db = null;
        if (roots.size() != 1) {
            return;
        }
        long userID = this.model.getExperimenter().getId();
        long groupID = this.model.getUserGroupID();
        HashMap<Long, TreeImageDisplay> m = new HashMap<Long, TreeImageDisplay>();
        if (parent instanceof TreeImageDisplay && (l = (display = (TreeImageDisplay)parent).getChildrenDisplay()) != null) {
            for (TreeImageDisplay child : l) {
                long id = child.getUserObjectId();
                if (id < 0L) continue;
                m.put(id, child);
            }
        }
        while (i.hasNext()) {
            Iterator k;
            Set dataObjects;
            TreeImageDisplay value;
            Set set;
            DataObject node = (DataObject)i.next();
            if (node instanceof ProjectData) {
                ProjectData project = (ProjectData)node;
                set = project.getDatasets();
                for (DatasetData d : set) {
                    value = (TreeImageDisplay)m.get(d.getId());
                    if (value == null) continue;
                    dataObjects = d.getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
                this.model.setState(7);
                this.fireStateChange();
                db = DataBrowserFactory.getDataBrowser(project, set);
                continue;
            }
            if (!(node instanceof TagAnnotationData)) continue;
            TagAnnotationData tag = (TagAnnotationData)node;
            set = tag.getDataObjects();
            Iterator j = set.iterator();
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                value = (TreeImageDisplay)m.get(object.getId());
                if (value == null) continue;
                if (object instanceof DatasetData) {
                    dataObjects = ((DatasetData)object).getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                    continue;
                }
                if (!(object instanceof ProjectData)) continue;
                Set datasets = ((ProjectData)object).getDatasets();
                Iterator l2 = datasets.iterator();
                while (l2.hasNext()) {
                    DatasetData d;
                    d = (DatasetData)j.next();
                    dataObjects = d.getImages();
                    if (dataObjects != null) {
                        value.removeAllChildrenDisplay();
                        k = dataObjects.iterator();
                        while (k.hasNext()) {
                            value.addChildDisplay(TreeViewerTranslator.transformDataObject((DataObject)((ImageData)k.next()), userID, groupID));
                        }
                    }
                    value.setChildrenLoaded(true);
                }
            }
            this.model.setState(7);
            this.fireStateChange();
            db = DataBrowserFactory.getTagsBrowser(tag, set, true);
        }
        if (db != null) {
            db.addPropertyChangeListener(this.controller);
            db.activate();
            this.view.removeAllFromWorkingPane();
            this.view.addComponent(db.getUI());
        }
        this.model.setDataViewer((DataBrowser)db);
    }

    @Override
    public void setUnselectedNode(Object object) {
        if (object == null) {
            return;
        }
        if (!(object instanceof List)) {
            return;
        }
        List l = (List)object;
        int n = l.size();
        if (n > 3) {
            return;
        }
        Object multiSelection = l.get(0);
        Object selected = l.get(1);
        Object parent = null;
        if (n == 3) {
            parent = l.get(2);
        }
        if (selected instanceof ImageData) {
            ImageData img = (ImageData)selected;
            try {
                img.getDefaultPixels();
            }
            catch (Exception e) {
                UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Image Not valid", "The selected image is not valid");
                return;
            }
        }
        Browser browser = this.model.getSelectedBrowser();
        MetadataViewer mv = this.model.getMetadataViewer();
        boolean multi = (Boolean)multiSelection;
        browser.onDeselectedNode(parent, selected, (Boolean)multiSelection);
        if (!multi) {
            mv.setRootObject(selected);
            mv.setSelectionMode(true);
        } else {
            TreeImageDisplay[] nodes = browser.getSelectedDisplays();
            if (nodes != null && nodes.length == 1) {
                mv.setRootObject(nodes[0].getUserObject());
                mv.setSelectionMode(true);
            } else {
                mv.setRootObject(null);
            }
        }
    }

    @Override
    public void copyRndSettings(ImageData image) {
        if (image == null) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null) {
                return;
            }
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            Object o = node.getUserObject();
            if (!(o instanceof ImageData)) {
                return;
            }
            image = (ImageData)o;
        }
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        bus.post(new CopyRndSettings(image));
    }

    @Override
    public void setOriginalRndSettings(List<Long> ids, Class klass) {
        if (ids == null || ids.size() == 0) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOriginalRenderingSettings(ids, klass);
        this.fireStateChange();
    }

    @Override
    public void setOriginalRndSettings(TimeRefObject ref) {
        if (ref == null) {
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set settings", "Please select at least one element.");
            return;
        }
        this.model.fireSetOriginalRenderingSettings(ref);
        this.fireStateChange();
    }

    @Override
    public void showSearch() {
        int oldMode = this.view.getDisplayMode();
        this.view.showAdvancedFinder();
        DataBrowser db = DataBrowserFactory.getSearchBrowser();
        int newMode = this.view.getDisplayMode();
        this.view.removeAllFromWorkingPane();
        switch (newMode) {
            case 100: {
                this.onSelectedDisplay();
                break;
            }
            case 101: {
                this.model.getMetadataViewer().setRootObject(null);
                if (db == null) break;
                this.view.addComponent(db.getUI());
                this.model.setDataViewer(db);
            }
        }
        this.firePropertyChange("searchMode", oldMode, newMode);
    }

    @Override
    public void setSearchResult(Object result) {
        Collection results = (Collection)result;
        if (results == null || results.size() == 0) {
            this.view.removeAllFromWorkingPane();
            return;
        }
        DataBrowser db = DataBrowserFactory.getSearchBrowser(results);
        if (db != null && this.view.getDisplayMode() == 101) {
            db.addPropertyChangeListener(this.controller);
            db.activate();
            this.view.removeAllFromWorkingPane();
            this.view.addComponent(db.getUI());
            this.model.setDataViewer(db);
        }
    }

    @Override
    public void addMetadata() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        ArrayList<Object> data = new ArrayList<Object>();
        Class type = null;
        String text = "Add metadata to ";
        if (nodes.length == 1) {
            TreeImageDisplay n = nodes[0];
            Object uo = n.getUserObject();
            if (uo instanceof TagAnnotationData) {
                data.add(uo);
                type = TagAnnotationData.class;
                text = text + "images linked to the selected tag.";
            } else if (uo instanceof DatasetData) {
                data.add(uo);
                type = DatasetData.class;
                text = text + "images linked to the selected dataset.";
            } else if (n instanceof TreeImageTimeSet) {
                TreeImageTimeSet time = (TreeImageTimeSet)n;
                ExperimenterData exp = this.model.getUserDetails();
                TimeRefObject ref = new TimeRefObject(exp.getId(), 0);
                ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                data.add(ref);
                type = TimeRefObject.class;
                text = text + "images imported during the selected period.";
            }
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                TreeImageDisplay n = nodes[i];
                Object uo = n.getUserObject();
                if (!(uo instanceof ImageData)) continue;
                data.add(uo);
            }
            text = text + "the selected images.";
        }
        if (data.size() > 0) {
            IconManager icons = IconManager.getInstance();
            MetadataViewer viewer = MetadataViewerFactory.getViewer(data, type);
            GenericDialog dialog = new GenericDialog(this.view, "Add Metadata...");
            dialog.initialize("Add Metadata...", text, icons.getIcon(73), viewer.getEditorUI());
            dialog.setParent(viewer);
            viewer.setSelectionMode(true);
            dialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(dialog);
        }
    }

    @Override
    public void refreshTree() {
        int state = this.model.getState();
        if (state == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state");
        }
        Browser b = this.model.getSelectedBrowser();
        DataBrowserFactory.discardAll();
        this.view.removeAllFromWorkingPane();
        if (b != null) {
            b.refreshTree();
        }
        this.model.getMetadataViewer().setRootObject(null);
    }

    @Override
    public void browseTimeInterval(TreeImageTimeSet parent, Set leaves) {
        if (leaves == null) {
            return;
        }
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = DataBrowserFactory.getDataBrowser(grandParentObject, parentObject, leaves);
        db.addPropertyChangeListener(this.controller);
        db.activate();
        this.view.removeAllFromWorkingPane();
        this.view.addComponent(db.getUI());
        this.model.setDataViewer(db);
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void setWells(TreeImageSet parent, Set wells) {
        Object parentObject = parent.getUserObject();
        TreeImageDisplay display = parent.getParentDisplay();
        Object grandParentObject = null;
        if (display != null) {
            grandParentObject = display.getUserObject();
        }
        DataBrowser db = DataBrowserFactory.getWellsDataBrowser(grandParentObject, parentObject, wells);
        db.addPropertyChangeListener(this.controller);
        db.activate();
        this.view.removeAllFromWorkingPane();
        this.view.addComponent(db.getUI());
        this.model.setDataViewer(db);
        this.model.setState(7);
        this.fireStateChange();
    }

    @Override
    public void browse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        Object uo = node.getUserObject();
        if (uo instanceof ProjectData) {
            this.model.browseProject(node);
        } else if (uo instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)uo;
            if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                this.model.browseTag(node);
            }
        } else if (uo instanceof ImageData) {
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            ViewImage evt = new ViewImage((ImageData)uo, this.view.getBounds());
            TreeImageDisplay p = node.getParentDisplay();
            TreeImageDisplay gp = null;
            DataObject po = null;
            DataObject gpo = null;
            if (p != null) {
                uo = p.getUserObject();
                gp = p.getParentDisplay();
                if (uo instanceof DataObject) {
                    po = (DataObject)uo;
                }
                if (gp != null && (uo = gp.getParentDisplay()) instanceof DataObject) {
                    gpo = (DataObject)uo;
                }
            }
            evt.setContext(po, gpo);
            bus.post(evt);
        } else if (node instanceof TreeImageTimeSet) {
            this.model.browseTimeInterval((TreeImageTimeSet)node);
        } else if (uo instanceof PlateData) {
            this.model.browsePlate(node);
        }
        this.fireStateChange();
    }

    @Override
    public void deleteObjects(List nodes) {
        DeleteBox dialog;
        TreeImageDisplay node;
        if (nodes == null) {
            return;
        }
        Iterator i = nodes.iterator();
        Class<?> type = null;
        boolean ann = false;
        boolean content = false;
        String ns = null;
        if (i.hasNext()) {
            node = (TreeImageDisplay)i.next();
            if (node.isAnnotated()) {
                ann = true;
            }
            if (node.hasChildren()) {
                content = true;
            }
            Object uo = node.getUserObject();
            type = uo.getClass();
            if (uo instanceof TagAnnotationData) {
                ns = ((TagAnnotationData)uo).getNameSpace();
            }
        }
        if ((dialog = new DeleteBox(type, ann, content, nodes.size(), ns, this.view)).centerMsgBox() == 1) {
            ann = dialog.deleteAnnotations();
            content = dialog.deleteContents();
            List<Class> types = dialog.getAnnotationTypes();
            i = nodes.iterator();
            ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
            while (i.hasNext()) {
                node = (TreeImageDisplay)i.next();
                Object obj = node.getUserObject();
                if (!(obj instanceof DataObject)) continue;
                DeletableObject d = new DeletableObject((DataObject)obj, content, ann);
                d.setAttachmentTypes(types);
                l.add(d);
            }
            if (l.size() > 0) {
                this.model.fireObjectsDeletion(l);
                this.fireStateChange();
            }
        }
    }

    @Override
    public Class hasDataToCopy() {
        if (this.model.getState() == 2) {
            return null;
        }
        return this.model.getDataToCopyType();
    }

    @Override
    public void onNodesMoved() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the SAVE state");
        }
        this.model.setState(7);
        this.fireStateChange();
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.removeAllFromWorkingPane();
        DataBrowserFactory.discardAll();
        Browser browser = this.model.getSelectedBrowser();
        browser.refreshTree();
        this.model.getMetadataViewer().setRootObject(null);
        this.setStatus(false, "", true);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void onNodesDeleted(Collection<DeletableObject> notDeleted) {
        if (this.model.getState() == 2) {
            return;
        }
        if (notDeleted == null || notDeleted.size() == 0) {
            this.onNodesMoved();
            return;
        }
        NotDeletedObjectDialog nd = new NotDeletedObjectDialog(this.view, notDeleted);
        if (nd.centerAndShow() == 0) {
            this.onNodesMoved();
        }
    }

    @Override
    public void openEditorFile(int index) {
        EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
        Browser browser = this.model.getSelectedBrowser();
        switch (index) {
            case 1: {
                if (browser == null) {
                    return;
                }
                TreeImageDisplay d = browser.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object object = d.getUserObject();
                if (object == null) {
                    return;
                }
                if (!(object instanceof FileAnnotationData)) break;
                FileAnnotationData fa = (FileAnnotationData)d.getUserObject();
                EditFileEvent evt = new EditFileEvent(fa);
                bus.post(evt);
                break;
            }
            case 0: {
                bus.post(new ShowEditorEvent());
                break;
            }
            case 2: {
                if (browser == null) {
                    return;
                }
                TreeImageDisplay d = browser.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object object = d.getUserObject();
                TreeImageDisplay parent = d.getParentDisplay();
                Object po = null;
                if (parent != null) {
                    po = parent.getUserObject();
                }
                if (object == null) {
                    return;
                }
                String name = null;
                if (object instanceof ProjectData) {
                    name = ((ProjectData)object).getName();
                } else if (object instanceof DatasetData) {
                    if (po != null && po instanceof ProjectData) {
                        name = ((ProjectData)po).getName();
                        name = name + "_";
                        name = name + ((DatasetData)object).getName();
                    } else {
                        name = ((DatasetData)object).getName();
                    }
                } else if (object instanceof ImageData) {
                    name = ((ImageData)object).getName();
                } else if (object instanceof ScreenData) {
                    name = ((ScreenData)object).getName();
                } else if (object instanceof PlateData) {
                    if (po != null && po instanceof ScreenData) {
                        name = ((ScreenData)po).getName();
                        name = name + "_";
                        name = name + ((PlateData)object).getName();
                    } else {
                        name = ((PlateData)object).getName();
                    }
                }
                if (name == null) break;
                name = name + "_exp";
                ShowEditorEvent event = new ShowEditorEvent((DataObject)object, name, 0);
                bus.post(event);
            }
        }
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 2) {
            return;
        }
        this.model.getMetadataViewer().showTagWizard();
    }
}

