/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ManagerAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.NewObjectAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.ManagePopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    private static final Dimension HBOX = new Dimension(100, 16);
    private TreeViewerControl controller;

    private JComponent createManagementBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.BROWSE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.VIEW));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.REFRESH_TREE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        bar.add(new JSeparator(1));
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.MANAGER);
        b = new JButton(a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addMouseListener((ManagerAction)a);
        bar.add(b);
        a = this.controller.getAction(TreeViewerControl.NEW_OBJECT);
        b = new JButton(a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addMouseListener((NewObjectAction)a);
        bar.add(b);
        a = this.controller.getAction(TreeViewerControl.NEW_TAG_OBJECT);
        b = new JButton(a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        b.addMouseListener((NewObjectAction)a);
        bar.add(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.SWITCH_USER));
        UIUtilities.unifiedButtonLookAndFeel(b);
        b = new JButton(this.controller.getAction(TreeViewerControl.EDITOR_NO_SELECTION));
        UIUtilities.unifiedButtonLookAndFeel(b);
        bar.add(b);
        bar.add(new JSeparator(1));
        return bar;
    }

    private JToolBar createSearchBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        JToggleButton b = new JToggleButton(this.controller.getAction(TreeViewerControl.SEARCH));
        bar.add(b);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.createManagementBar());
        bars.add(this.createSearchBar());
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 0));
        this.add(UIUtilities.buildComponentPanel(outerPanel));
    }

    ToolBar(TreeViewerControl controller) {
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.controller = controller;
        this.buildGUI();
    }

    void showManagementMenu(Component c, Point p) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        ManagePopupMenu managePopupMenu = new ManagePopupMenu(this.controller);
        managePopupMenu.show(c, p.x, p.y);
    }

    void showCreateMenu(Component c, Point p, int index) {
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (p == null) {
            throw new IllegalArgumentException("No point.");
        }
        PopupMenu menu = new PopupMenu(this.controller, index);
        menu.show(c, p.x, p.y);
    }
}

