/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;

public class LoadingWindow
extends JDialog {
    private static final String SAVING_MSG = "Saving the data and Updating the display.";
    private static final String LOADING_MSG = "Loading Data and Building the display.";
    private static final String LOADING_TITLE = "Loading Data";
    private static final Dimension MSG_AREA_SIZE = new Dimension(300, 50);
    private static final Dimension H_SPACER_SIZE = new Dimension(20, 1);
    private static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    private JPanel messagePanel;
    private MultilineLabel messageLabel;
    private JButton cancelButton;
    private JProgressBar progressBar;

    private void createComponents() {
        this.cancelButton = new JButton("Cancel");
        this.progressBar = new JProgressBar();
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.messageLabel = new MultilineLabel(LOADING_MSG);
        this.messageLabel.setPreferredSize(MSG_AREA_SIZE);
        this.messageLabel.setAlignmentY(0.0f);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                LoadingWindow.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoadingWindow.this.close();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.firePropertyChange("cancelLoading", Boolean.FALSE, Boolean.TRUE);
    }

    private JPanel buildButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.cancelButton);
        buttonsPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        return buttonsPanel;
    }

    private JPanel buildMessagePanel() {
        this.messagePanel = new JPanel();
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 0));
        Icon icon = null;
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setAlignmentY(0.0f);
        this.messagePanel.add(iconLabel);
        this.messagePanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.messagePanel.add(this.messageLabel);
        this.messagePanel.setOpaque(true);
        return this.messagePanel;
    }

    private void buildGUI() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 15, 10)));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.add(this.buildMessagePanel());
        contentPanel.add(Box.createRigidArea(V_SPACER_SIZE));
        contentPanel.add(this.progressBar);
        contentPanel.add(Box.createRigidArea(V_SPACER_SIZE));
        contentPanel.add(this.buildButtonsPanel());
        contentPanel.setOpaque(true);
        this.getContentPane().add(contentPanel);
    }

    public LoadingWindow(JFrame owner) {
        super(owner, LOADING_TITLE, true);
        this.setResizable(false);
        this.createComponents();
        this.attachListeners();
        this.buildGUI();
        this.pack();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (title.equals("Saving Data")) {
            this.messageLabel.setText(SAVING_MSG);
        } else if (title.equals(LOADING_TITLE)) {
            this.messageLabel.setText(LOADING_MSG);
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.setTitle(LOADING_TITLE);
        }
    }
}

