/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBox
extends MessageBox {
    private static final String TITLE = "Confirm delete";
    private static final String DEFAULT_TEXT = "Are you sure you want to delete the selected ";
    private JRadioButton withContent;
    private JRadioButton withoutContent;
    private JCheckBox withAnnotation;
    private Class type;
    private String nameSpace;
    private boolean annotation;
    private boolean children;
    private Map<JCheckBox, Class> annotationTypes;
    private JPanel typesPane;

    private JCheckBox createBox(String name) {
        JCheckBox box = new JCheckBox(name);
        Font f = box.getFont();
        int size = f.getSize() - 2;
        Font newFont = f.deriveFont(2, size);
        box.setSelected(true);
        box.setFont(newFont);
        box.setEnabled(false);
        return box;
    }

    private void initComponents(String annotationText) {
        this.withAnnotation = new JCheckBox("Also delete the annotations only linked to the " + annotationText + ".");
        this.withContent = new JRadioButton("Also delete contents.");
        this.withoutContent = new JRadioButton("Do not delete contents.");
        ButtonGroup group = new ButtonGroup();
        group.add(this.withContent);
        group.add(this.withoutContent);
        this.withoutContent.setSelected(true);
        this.annotationTypes = new LinkedHashMap<JCheckBox, Class>();
        this.annotationTypes.put(this.createBox("Tag"), TagAnnotationData.class);
        this.annotationTypes.put(this.createBox("Attachment"), FileAnnotationData.class);
        this.withAnnotation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DeleteBox.this.layoutAnnotationTypes();
            }
        });
        this.typesPane = new JPanel();
        this.typesPane.setLayout(new GridBagLayout());
    }

    private void layoutAnnotationTypes() {
        boolean b = this.withAnnotation.isSelected();
        this.typesPane.setEnabled(b);
        Iterator<JCheckBox> i = this.annotationTypes.keySet().iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
    }

    private void layoutComponents() {
        Iterator<JCheckBox> i = this.annotationTypes.keySet().iterator();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        while (i.hasNext()) {
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 1.0;
            this.typesPane.add(Box.createHorizontalStrut(30), c);
            ++c.gridx;
            c.gridwidth = 0;
            this.typesPane.add((Component)i.next(), c);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        boolean add = false;
        if (ImageData.class.equals((Object)this.type)) {
            add = true;
            if (this.annotation) {
                p.add(this.withAnnotation);
                p.add(this.typesPane);
            }
        } else if (DatasetData.class.equals((Object)this.type) || ProjectData.class.equals((Object)this.type)) {
            add = true;
            if (this.children) {
                p.add(this.withContent);
                p.add(this.withoutContent);
            }
            if (this.annotation) {
                p.add(this.withAnnotation);
                p.add(this.typesPane);
            }
        } else if (TagAnnotationData.class.equals((Object)this.type) && "openmicroscopy.org/omero/insight/tagset".equals(this.nameSpace)) {
            add = true;
            if (this.children) {
                p.add(this.withContent);
                p.add(this.withoutContent);
            }
        }
        if (add) {
            this.addBodyComponent(p);
        }
    }

    private static String getTypeAsString(Class type, int number, String ns) {
        String end = "";
        if (number > 1) {
            end = "s";
        }
        if (ImageData.class.equals((Object)type)) {
            return "Image" + end;
        }
        if (DatasetData.class.equals((Object)type)) {
            return "Dataset" + end;
        }
        if (ProjectData.class.equals((Object)type)) {
            return "Project" + end;
        }
        if (FileAnnotationData.class.equals((Object)type)) {
            return "File" + end;
        }
        if (TagAnnotationData.class.equals((Object)type)) {
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                return "Tag Set" + end;
            }
            return "Tag" + end;
        }
        return "";
    }

    private static String getMessage(Class type, int number, String nameSpace, boolean annotation, boolean children) {
        StringBuffer buffer = new StringBuffer();
        String value = DeleteBox.getTypeAsString(type, number, nameSpace);
        String text = null;
        if (value != null && value.length() > 0) {
            text = DEFAULT_TEXT + value + "?";
        }
        if (text != null) {
            buffer.append(text);
            buffer.append("\n");
            if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || ProjectData.class.equals((Object)type)) {
                if (annotation || children) {
                    buffer.append("If yes, ");
                }
            } else if (TagAnnotationData.class.equals((Object)type) && "openmicroscopy.org/omero/insight/tagset".equals(nameSpace) && children) {
                buffer.append("If yes, ");
            }
        }
        return buffer.toString();
    }

    public DeleteBox(Class type, boolean annotation, boolean children, int number, String nameSpace, JFrame parent) {
        super(parent, TITLE, DeleteBox.getMessage(type, number, nameSpace, annotation, children));
        this.nameSpace = nameSpace;
        this.type = type;
        this.annotation = annotation;
        this.children = children;
        this.initComponents(DeleteBox.getTypeAsString(type, number, nameSpace));
        this.layoutComponents();
        this.pack();
    }

    public boolean deleteContents() {
        if (ImageData.class.equals((Object)this.type)) {
            return false;
        }
        return this.withContent.isSelected();
    }

    public boolean deleteAnnotations() {
        return this.withAnnotation.isSelected();
    }

    public List<Class> getAnnotationTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (JCheckBox box : this.annotationTypes.keySet()) {
            if (!box.isSelected()) continue;
            types.add(this.annotationTypes.get(box));
        }
        return types;
    }
}

