/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private IconManager icons;
    private boolean numberChildrenVisible;
    private long userID;
    private EditorFileFilter filter;

    private void setIcon(TreeImageDisplay node) {
        Object usrObject = node.getUserObject();
        Icon icon = this.icons.getIcon(23);
        if (usrObject instanceof ProjectData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(67) : this.icons.getIcon(4);
        } else if (usrObject instanceof DatasetData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(18) : this.icons.getIcon(5);
        } else if (usrObject instanceof ImageData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(19) : this.icons.getIcon(6);
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            String ns = tag.getNameSpace();
            icon = "openmicroscopy.org/omero/insight/tagset".equals(ns) ? this.icons.getIcon(71) : this.icons.getIcon(69);
        } else if (usrObject instanceof ScreenData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(76) : this.icons.getIcon(75);
        } else if (usrObject instanceof PlateData) {
            icon = EditorUtil.isAnnotated(usrObject) ? this.icons.getIcon(78) : this.icons.getIcon(77);
        } else if (usrObject instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)usrObject;
            String format = data.getFileFormat();
            icon = "pdf".equals(format) ? this.icons.getIcon(82) : ("txt".equals(format) || "csv".equals(format) ? this.icons.getIcon(83) : ("html".equals(format) || "htm".equals(format) ? this.icons.getIcon(89) : ("ppt".equals(format) || "pps".equals(format) ? this.icons.getIcon(87) : ("doc".equals(format) ? this.icons.getIcon(85) : ("xls".equals(format) ? this.icons.getIcon(86) : ("xml".equals(format) || "rtf".equals(format) ? (this.filter.accept(data.getFileName()) ? ("openmicroscopy.org/omero/editor/experiment".equals(data.getNameSpace()) ? this.icons.getIcon(99) : this.icons.getIcon(84)) : this.icons.getIcon(88)) : this.icons.getIcon(81)))))));
        } else if (node instanceof TreeImageTimeSet) {
            icon = this.icons.getIcon(62);
        } else if (node instanceof TreeFileSet) {
            TreeFileSet n = (TreeFileSet)node;
            switch (n.getType()) {
                case 1: {
                    icon = this.icons.getIcon(98);
                    break;
                }
                case 0: {
                    icon = this.icons.getIcon(97);
                    break;
                }
                default: {
                    icon = this.icons.getIcon(7);
                    break;
                }
            }
        } else if (usrObject instanceof String) {
            icon = this.icons.getIcon(7);
        }
        this.setIcon(icon);
    }

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    public TreeCellRenderer(boolean b) {
        this.numberChildrenVisible = b;
        this.icons = IconManager.getInstance();
        ExperimenterData exp = (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
        this.userID = exp.getId();
        this.filter = new EditorFileFilter();
    }

    public TreeCellRenderer() {
        this(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!(value instanceof TreeImageDisplay)) {
            return this;
        }
        TreeImageDisplay node = (TreeImageDisplay)value;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (node.getLevel() == 0) {
            if (node.getUserObject() instanceof ExperimenterData) {
                this.setIcon(this.icons.getIcon(23));
            } else {
                this.setIcon(this.icons.getIcon(7));
            }
            if (this.getIcon() != null) {
                w += this.getIcon().getIconWidth();
            }
            w += this.getIconTextGap();
            this.setPreferredSize(new Dimension(w += fm.stringWidth(this.getText()), fm.getHeight()));
            if (sel) {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        if (this.numberChildrenVisible) {
            this.setText(node.getNodeText());
        } else {
            this.setText(node.getNodeName());
        }
        this.setToolTipText(node.getToolTip());
        this.setIcon(node);
        Color c = node.getHighLight();
        if (c == null) {
            c = tree.getForeground();
        }
        this.setForeground(c);
        if (!sel) {
            this.setBorderSelectionColor(this.getBackground());
        } else {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        if (this.getIcon() != null) {
            w += this.getIcon().getIconWidth();
        }
        w += this.getIconTextGap();
        w = node.getUserObject() instanceof ImageData ? (w += fm.stringWidth(node.getNodeName())) : (node instanceof TreeFileSet ? (w += fm.stringWidth(this.getText()) + 40) : (w += fm.stringWidth(this.getText())));
        this.setPreferredSize(new Dimension(w, fm.getHeight() + 4));
        return this;
    }
}

