/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

class DeletableTableNode
extends OMETreeNode {
    static final String IMAGE_TYPE = "Image";
    static final String DATASET_TYPE = "Dataset";
    static final String PROJECT_TYPE = "Project";
    static final String SCREEN_TYPE = "Screen";
    static final String PLATE_TYPE = "Plate";
    static final String FILE_TYPE = "File";

    DeletableTableNode(Object refNode) {
        super(refNode);
        if (refNode == null) {
            throw new IllegalArgumentException("No node specified.");
        }
    }

    String getType() {
        Object node = this.getUserObject();
        if (!(node instanceof DeletableObject)) {
            return "";
        }
        DataObject object = ((DeletableObject)node).getObjectToDelete();
        if (object instanceof ImageData) {
            return IMAGE_TYPE;
        }
        if (object instanceof DatasetData) {
            return DATASET_TYPE;
        }
        if (object instanceof ProjectData) {
            return PROJECT_TYPE;
        }
        if (object instanceof ScreenData) {
            return SCREEN_TYPE;
        }
        if (object instanceof PlateData) {
            return PLATE_TYPE;
        }
        if (object instanceof FileAnnotationData) {
            return FILE_TYPE;
        }
        return "";
    }

    public Object getValueAt(int column) {
        Object node = this.getUserObject();
        if (!(node instanceof DeletableObject)) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return -1;
                }
                case 2: {
                    return "";
                }
            }
        }
        DataObject object = ((DeletableObject)node).getObjectToDelete();
        switch (column) {
            case 0: {
                return this.getType();
            }
            case 1: {
                return object.getId();
            }
            case 2: {
                if (object instanceof DatasetData) {
                    return ((DatasetData)object).getName();
                }
                if (object instanceof ProjectData) {
                    return ((ProjectData)object).getName();
                }
                if (object instanceof ScreenData) {
                    return ((ScreenData)object).getName();
                }
                if (object instanceof PlateData) {
                    return ((PlateData)object).getName();
                }
                if (object instanceof FileAnnotationData) {
                    return ((FileAnnotationData)object).getFileName();
                }
                if (object instanceof ImageData) {
                    return EditorUtil.getPartialName(((ImageData)object).getName());
                }
                return "";
            }
        }
        return null;
    }
}

