/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public abstract class TreeImageDisplay
extends DefaultMutableTreeNode {
    public static final int FONT_PLAIN = 0;
    public static final int FONT_BOLD = 1;
    private static final String SPACE = " ";
    private TreeImageDisplay parentDisplay;
    protected List<TreeImageDisplay> childrenDisplay;
    private String tooltip;
    private Color highlight;
    private int fontStyle;
    private boolean expanded;
    private boolean partialName;
    protected long numberItems;

    private boolean checkAlgoType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected TreeImageDisplay(Object hierarchyObject) {
        if (hierarchyObject == null) {
            throw new NullPointerException("No hierarchy object.");
        }
        this.setUserObject(hierarchyObject);
        this.childrenDisplay = new ArrayList<TreeImageDisplay>();
        this.numberItems = -1L;
        this.partialName = true;
        this.fontStyle = 0;
    }

    void setPartialName(boolean b) {
        this.partialName = b;
    }

    boolean isPartialName() {
        return this.partialName;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public TreeImageDisplay getParentDisplay() {
        return this.parentDisplay;
    }

    public List getChildrenDisplay() {
        return Collections.unmodifiableList(this.childrenDisplay);
    }

    public boolean hasChildrenDisplay() {
        return this.childrenDisplay.size() != 0;
    }

    public void addChildDisplay(TreeImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            return;
        }
        if (child.parentDisplay != null) {
            child.parentDisplay.removeChildDisplay(child);
        }
        child.parentDisplay = this;
        this.childrenDisplay.add(child);
        this.numberItems = this.childrenDisplay.size();
    }

    public void removeChildDisplay(TreeImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        if (this.childrenDisplay.contains(child)) {
            child.parentDisplay.childrenDisplay.remove(child);
            child.parentDisplay = null;
            this.numberItems = this.childrenDisplay.size();
        }
    }

    public void removeAllChildrenDisplay() {
        Iterator<TreeImageDisplay> i = this.childrenDisplay.iterator();
        HashSet<TreeImageDisplay> toRemove = new HashSet<TreeImageDisplay>(this.childrenDisplay.size());
        while (i.hasNext()) {
            toRemove.add(i.next());
        }
        i = toRemove.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay(i.next());
        }
    }

    public void removeChildrenDisplay(List children) {
        if (children == null) {
            return;
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            this.removeChildDisplay((TreeImageDisplay)i.next());
        }
    }

    public void accept(TreeImageDisplayVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        this.accept(visitor, 2);
    }

    public void accept(TreeImageDisplayVisitor visitor, int algoType) {
        if (visitor == null) {
            throw new NullPointerException("No visitor.");
        }
        if (!this.checkAlgoType(algoType)) {
            throw new IllegalArgumentException("Algorithm not supported.");
        }
        Iterator<TreeImageDisplay> i = this.childrenDisplay.iterator();
        switch (algoType) {
            case 0: {
                while (i.hasNext()) {
                    TreeImageDisplay child = i.next();
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof TreeImageNode)) break;
                this.doAccept(visitor);
                break;
            }
            case 1: {
                while (i.hasNext()) {
                    TreeImageDisplay child = i.next();
                    if (!(child instanceof TreeImageSet)) continue;
                    child.accept(visitor, algoType);
                }
                if (!(this instanceof TreeImageSet)) break;
                this.doAccept(visitor);
                break;
            }
            case 2: {
                while (i.hasNext()) {
                    TreeImageDisplay child = i.next();
                    child.accept(visitor, algoType);
                }
                this.doAccept(visitor);
            }
        }
    }

    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public String getNodeName() {
        Object obj = this.getUserObject();
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            return ((ImageData)obj).getName();
        }
        if (obj instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)obj;
            return exp.getFirstName() + SPACE + exp.getLastName();
        }
        if (obj instanceof TagAnnotationData) {
            return ((TagAnnotationData)obj).getTagValue();
        }
        if (obj instanceof ScreenData) {
            return ((ScreenData)obj).getName();
        }
        if (obj instanceof PlateData) {
            return ((PlateData)obj).getName();
        }
        if (obj instanceof FileAnnotationData) {
            return ((FileAnnotationData)obj).getFileName();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public String getNodeText() {
        String name = this.getNodeName();
        Object uo = this.getUserObject();
        if (uo instanceof ImageData) {
            if (this.partialName) {
                return EditorUtil.getPartialName(name);
            }
            return name;
        }
        if (uo instanceof ExperimenterData) {
            return this.getNodeName();
        }
        if (uo instanceof PlateData) {
            return this.getNodeName();
        }
        if (uo instanceof FileAnnotationData) {
            return this.getNodeName();
        }
        if (uo instanceof String && this.numberItems < 0L) {
            return name;
        }
        if (this.numberItems < 0L) {
            return name + SPACE + "[...]";
        }
        return name + SPACE + "[" + this.numberItems + "]";
    }

    public boolean isAnnotated() {
        ScreenData data;
        Map counts;
        Object uo = this.getUserObject();
        if (uo instanceof ProjectData) {
            ProjectData data2 = (ProjectData)uo;
            Map counts2 = data2.getAnnotationsCounts();
            if (counts2 != null) {
                return counts2.size() > 0;
            }
        } else if (uo instanceof DatasetData) {
            DatasetData data3 = (DatasetData)uo;
            Map counts3 = data3.getAnnotationsCounts();
            if (counts3 != null) {
                return counts3.size() > 0;
            }
        } else if (uo instanceof ImageData) {
            ImageData data4 = (ImageData)uo;
            Map counts4 = data4.getAnnotationsCounts();
            if (counts4 != null) {
                return counts4.size() > 0;
            }
        } else if (uo instanceof PlateData) {
            PlateData data5 = (PlateData)uo;
            Map counts5 = data5.getAnnotationsCounts();
            if (counts5 != null) {
                return counts5.size() > 0;
            }
        } else if (uo instanceof ScreenData && (counts = (data = (ScreenData)uo).getAnnotationsCounts()) != null) {
            return counts.size() > 0;
        }
        return false;
    }

    public boolean hasChildren() {
        Object uo = this.getUserObject();
        if (uo instanceof ProjectData || uo instanceof ScreenData || uo instanceof PlateData || uo instanceof DatasetData || uo instanceof TagAnnotationData) {
            if (this.numberItems > 0L) {
                return true;
            }
            return this.hasChildrenDisplay();
        }
        return false;
    }

    public void setFontStyle(int style) {
        switch (style) {
            case 0: 
            case 1: {
                this.fontStyle = style;
                break;
            }
            default: {
                this.fontStyle = 0;
            }
        }
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setHighLight(Color highlight) {
        this.highlight = highlight;
    }

    public Color getHighLight() {
        return this.highlight;
    }

    public long getUserObjectId() {
        Object uo = this.getUserObject();
        if (uo instanceof DataObject) {
            return ((DataObject)uo).getId();
        }
        return -1L;
    }

    public long getNumberOfItems() {
        return this.numberItems;
    }

    public String toString() {
        return this.getNodeName();
    }

    public void setUserObject(Object userObject) {
        if (userObject == null) {
            throw new NullPointerException("No userObject.");
        }
        super.setUserObject(userObject);
    }

    public final boolean equals(Object x) {
        return this == x;
    }

    protected abstract void doAccept(TreeImageDisplayVisitor var1);

    public abstract boolean containsImages();

    public abstract boolean isChildrenLoaded();

    public abstract void setChildrenLoaded(Boolean var1);

    public abstract TreeImageDisplay copy();
}

