/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.treeviewer.ContainerCounterLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImageLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExperimenterImagesCounter;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDataLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.ScreenPlateLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainersManager;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserModel {
    private int browserType;
    private Set selectedNodes;
    private int state = 10;
    private Point clickPoint;
    private DataBrowserLoader currentLoader;
    private DataBrowserLoader numberLoader;
    private List foundNodes;
    private int foundNodeIndex;
    private ContainersManager containersManager;
    private boolean selected;
    private boolean displayed;
    private TreeViewer parent;
    protected Browser component;

    private void checkBrowserType(int type) {
        switch (type) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Browser type not valid.");
            }
        }
    }

    protected BrowserModel(int browserType, TreeViewer parent) {
        this.parent = parent;
        this.checkBrowserType(browserType);
        this.browserType = browserType;
        this.clickPoint = null;
        this.foundNodeIndex = -1;
        this.selectedNodes = new HashSet();
        this.displayed = true;
    }

    void initialize(Browser component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    long getRootID() {
        return this.parent.getUserDetails().getId();
    }

    TreeImageDisplay getLastSelectedDisplay() {
        int n = this.selectedNodes.size();
        if (n == 0) {
            return null;
        }
        Iterator i = this.selectedNodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index == n - 1) {
                return (TreeImageDisplay)i.next();
            }
            ++index;
        }
        return null;
    }

    TreeImageDisplay[] getSelectedDisplays() {
        if (this.selectedNodes.size() == 0) {
            return new TreeImageDisplay[0];
        }
        return this.selectedNodes.toArray(new TreeImageDisplay[this.selectedNodes.size()]);
    }

    void setSelectedDisplay(TreeImageDisplay display, boolean single) {
        if (single) {
            this.selectedNodes.clear();
            if (display != null) {
                this.selectedNodes.add(display);
            }
        } else if (!this.selectedNodes.contains(display) && display != null) {
            this.selectedNodes.add(display);
        }
    }

    void addFoundNode(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            return;
        }
        TreeImageDisplay display = this.getLastSelectedDisplay();
        if (display != null && !display.getUserObject().getClass().equals(selectedDisplay.getUserObject().getClass())) {
            this.selectedNodes.clear();
        }
        this.selectedNodes.add(selectedDisplay);
    }

    Point getClickPoint() {
        return this.clickPoint;
    }

    void setClickPoint(Point p) {
        this.clickPoint = p;
    }

    int getBrowserType() {
        return this.browserType;
    }

    void fireLeavesLoading(TreeImageDisplay expNode, TreeImageDisplay node) {
        this.state = 12;
        if (node instanceof TreeImageTimeSet || node instanceof TreeFileSet) {
            this.currentLoader = new ExperimenterImageLoader(this.component, (TreeImageSet)expNode, (TreeImageSet)node);
            this.currentLoader.load();
        } else {
            Object ho = node.getUserObject();
            if (!(ho instanceof PlateData)) {
                if (ho instanceof DatasetData) {
                    this.currentLoader = new ExperimenterDataLoader(this.component, 1, (TreeImageSet)expNode, (TreeImageSet)node);
                    this.currentLoader.load();
                } else if (ho instanceof TagAnnotationData) {
                    this.currentLoader = new ExperimenterDataLoader(this.component, 3, (TreeImageSet)expNode, (TreeImageSet)node);
                    this.currentLoader.load();
                }
            }
        }
    }

    void fireContainerCountLoading(Set containers, Set<TreeImageSet> nodes) {
        if (containers == null || containers.size() == 0) {
            this.state = 15;
            return;
        }
        this.numberLoader = new ContainerCounterLoader(this.component, containers, nodes);
        this.numberLoader.load();
    }

    void discard() {
        this.cancel();
        if (this.numberLoader != null) {
            this.numberLoader.cancel();
            this.numberLoader = null;
        }
        this.state = 16;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 15;
    }

    boolean setContainerCountValue(JTree tree, long containerID, long value, Set<TreeImageSet> nodes) {
        if (this.containersManager == null) {
            this.containersManager = new ContainersManager(tree, nodes);
        }
        this.containersManager.setNumberItems(containerID, value);
        if (this.containersManager.isDone()) {
            this.containersManager = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void setSelected(boolean selected) {
        this.selected = selected;
    }

    boolean isSelected() {
        return this.selected;
    }

    void setFoundNodes(List nodes) {
        this.foundNodes = nodes;
    }

    void setFoundNodeIndex(int i) {
        this.foundNodeIndex = i;
    }

    int getFoundNodeIndex() {
        return this.foundNodeIndex;
    }

    List getFoundNodes() {
        return this.foundNodes;
    }

    long getUserID() {
        return this.parent.getUserDetails().getId();
    }

    long getUserGroupID() {
        return this.parent.getUserGroupID();
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    TreeViewer getParentModel() {
        return this.parent;
    }

    boolean isDisplayed() {
        return this.displayed;
    }

    void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    String getExperimenterNames() {
        return this.parent.getExperimenterNames();
    }

    void fireExperimenterDataLoading(TreeImageSet expNode) {
        int index = -1;
        if (this.browserType == 103) {
            this.currentLoader = new ScreenPlateLoader(this.component, expNode, 0);
            this.currentLoader.load();
            this.state = 11;
            return;
        }
        switch (this.browserType) {
            case 100: {
                index = 0;
                break;
            }
            case 101: {
                index = 2;
                break;
            }
            case 102: {
                index = 4;
                break;
            }
        }
        if (index == -1) {
            return;
        }
        this.currentLoader = new ExperimenterDataLoader(this.component, index, expNode);
        this.currentLoader.load();
        this.state = 11;
    }

    void loadRefreshExperimenterData(Map<Long, RefreshExperimenterDef> nodes) {
        Class<ProjectData> klass = null;
        switch (this.browserType) {
            case 100: {
                klass = ProjectData.class;
                break;
            }
            case 101: {
                klass = ImageData.class;
                break;
            }
            case 102: {
                klass = TagAnnotationData.class;
                break;
            }
            case 103: {
                klass = ScreenData.class;
                break;
            }
            case 104: {
                klass = FileAnnotationData.class;
            }
        }
        this.state = 11;
        if (klass == null) {
            return;
        }
        this.currentLoader = new RefreshExperimenterDataLoader(this.component, klass, nodes);
        this.currentLoader.load();
    }

    void fireCountExperimenterImages(TreeImageSet expNode) {
        List n = expNode.getChildrenDisplay();
        Iterator i = n.iterator();
        HashSet<Integer> indexes = new HashSet<Integer>();
        switch (this.getBrowserType()) {
            case 101: {
                while (i.hasNext()) {
                    TreeImageTimeSet node = (TreeImageTimeSet)i.next();
                    indexes.add(node.getType());
                }
                break;
            }
            case 104: {
                while (i.hasNext()) {
                    TreeFileSet file = (TreeFileSet)i.next();
                    indexes.add(file.getType());
                }
                break;
            }
        }
        if (indexes.size() == 0) {
            return;
        }
        if (this.containersManager == null) {
            this.containersManager = new ContainersManager(indexes);
        }
        this.state = 13;
        this.numberLoader = new ExperimenterImagesCounter(this.component, expNode, n);
        this.numberLoader.load();
    }

    boolean setExperimenterCount(TreeImageSet expNode, int index) {
        if (this.containersManager == null) {
            return true;
        }
        this.containersManager.setItem(index);
        if (this.containersManager.isDone()) {
            if (this.state == 13) {
                this.state = 15;
            }
            this.containersManager = null;
            this.numberLoader = null;
            return true;
        }
        return false;
    }

    void removeDisplay(TreeImageDisplay foundNode) {
        if (foundNode != null) {
            this.selectedNodes.remove(foundNode);
        }
    }

    void viewImage(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        ImageData image = (ImageData)node.getUserObject();
        TreeImageDisplay pNode = node.getParentDisplay();
        DataObject pObject = null;
        DataObject gpObject = null;
        if (pNode != null) {
            TreeImageDisplay gpNode;
            Object p = pNode.getUserObject();
            if (p instanceof DataObject) {
                pObject = (DataObject)p;
            }
            if ((gpNode = pNode.getParentDisplay()) != null && (p = gpNode.getUserObject()) instanceof DataObject && !(p instanceof ExperimenterData) && !(p instanceof GroupData)) {
                gpObject = (DataObject)p;
            }
        }
        Rectangle r = this.parent.getUI().getBounds();
        ViewImage evt = new ViewImage(image, r);
        evt.setContext(pObject, gpObject);
        TreeViewerAgent.getRegistry().getEventBus().post(evt);
    }

    void openFile(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        FileAnnotationData data = (FileAnnotationData)node.getUserObject();
        EditFileEvent evt = new EditFileEvent(data);
        TreeViewerAgent.getRegistry().getEventBus().post(evt);
    }
}

