/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CloseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.CollapseAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.ShowNameAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.SortByDateAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserControl
implements ChangeListener {
    static final Integer COLLAPSE = 0;
    static final Integer CLOSE = 1;
    static final Integer SORT = 2;
    static final Integer SORT_DATE = 3;
    static final Integer PARTIAL_NAME = 4;
    private Browser model;
    private BrowserUI view;
    private Map<Integer, Action> actionsMap;

    private void createActions() {
        this.actionsMap.put(COLLAPSE, new CollapseAction(this.model));
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(SORT, new SortAction(this.model));
        this.actionsMap.put(SORT_DATE, new SortByDateAction(this.model));
        this.actionsMap.put(PARTIAL_NAME, new ShowNameAction(this.model));
    }

    BrowserControl(Browser model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, Action>();
        this.createActions();
    }

    void initialize(BrowserUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.model.addChangeListener(this);
    }

    TreeImageDisplay getDataOwner(TreeImageDisplay node) {
        if (node == null) {
            return null;
        }
        TreeImageDisplay parent = node.getParentDisplay();
        if (parent == null) {
            Object ho = node.getUserObject();
            if (ho instanceof ExperimenterData) {
                return node;
            }
            return null;
        }
        Object ho = parent.getUserObject();
        if (ho instanceof ExperimenterData) {
            return parent;
        }
        return this.getDataOwner(parent);
    }

    void onNodeNavigation(TreeImageDisplay display, boolean expanded) {
        if (!expanded) {
            this.model.cancel();
            return;
        }
        int state = this.model.getState();
        if (state == 11 || state == 12) {
            return;
        }
        Object ho = display.getUserObject();
        this.model.setSelectedDisplay(display);
        int browserType = this.model.getBrowserType();
        if ((browserType == 101 || browserType == 104) && !display.isChildrenLoaded() && ho instanceof ExperimenterData) {
            this.model.countExperimenterImages(display);
            return;
        }
        if (display.isChildrenLoaded()) {
            List l = display.getChildrenDisplay();
            if (this.view.isFirstChildMessage(display)) {
                this.view.setLeavesViews(l, (TreeImageSet)display);
            }
            return;
        }
        if (ho instanceof ProjectData && display.numberItems == 0L) {
            return;
        }
        this.view.loadAction(display);
        if (display instanceof TreeImageTimeSet || display instanceof TreeFileSet) {
            this.model.loadExperimenterData(this.getDataOwner(display), display);
            return;
        }
        if (ho instanceof DatasetData || ho instanceof TagAnnotationData || ho instanceof PlateData) {
            this.model.loadExperimenterData(this.getDataOwner(display), display);
        } else if (ho instanceof ExperimenterData) {
            this.model.loadExperimenterData(display, null);
        }
    }

    void showPopupMenu(int index) {
        this.model.showPopupMenu(index);
    }

    void onClick(List<TreePath> added) {
        JTree tree = this.view.getTreeDisplay();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        if (paths.length == 1) {
            Object p = paths[0].getLastPathComponent();
            if (!(p instanceof TreeImageDisplay)) {
                return;
            }
            TreeImageDisplay node = (TreeImageDisplay)p;
            this.model.setSelectedDisplay(node);
            return;
        }
        TreeImageDisplay previous = this.model.getLastSelectedDisplay();
        Object ho = previous.getUserObject();
        Class<?> ref = ho.getClass();
        ArrayList<TreeImageDisplay> l = new ArrayList<TreeImageDisplay>();
        ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
        String ns = null;
        if (TagAnnotationData.class.equals(ref)) {
            ns = ((TagAnnotationData)ho).getNameSpace();
        }
        if (added != null) {
            for (TreePath path : added) {
                TreeImageDisplay node = (TreeImageDisplay)path.getLastPathComponent();
                Object nho = node.getUserObject();
                if (nho.getClass().equals(ref)) {
                    if (nho.getClass().equals(TagAnnotationData.class)) {
                        String nsNode = ((TagAnnotationData)nho).getNameSpace();
                        if (ns == null && nsNode == null) {
                            l.add(node);
                            continue;
                        }
                        if (ns == null && nsNode != null) {
                            toRemove.add(path);
                            continue;
                        }
                        if (ns != null && nsNode == null) {
                            toRemove.add(path);
                            continue;
                        }
                        if (ns == null || nsNode == null || !ns.equals(nsNode)) continue;
                        l.add(node);
                        continue;
                    }
                    l.add(node);
                    continue;
                }
                toRemove.add(path);
            }
        }
        if (toRemove.size() > 0) {
            String text = "";
            if (ImageData.class.equals(ref)) {
                text = "Images.";
            } else if (ProjectData.class.equals(ref)) {
                text = "Projects.";
            } else if (DatasetData.class.equals(ref)) {
                text = "Datasets.";
            } else if (TagAnnotationData.class.equals(ref)) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                text = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? "Tag Sets." : "Tags.";
            } else if (FileAnnotationData.class.equals(ref)) {
                text = "Files.";
            }
            UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Tree selection", "You can only select " + text);
            this.view.removeTreePaths(toRemove);
        }
        paths = tree.getSelectionPaths();
        TreeImageDisplay[] nodes = new TreeImageDisplay[paths.length];
        for (int j = 0; j < paths.length; ++j) {
            nodes[j] = (TreeImageDisplay)paths[j].getLastPathComponent();
        }
        this.model.setSelectedDisplays(nodes);
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 14: {
                break;
            }
        }
        this.view.onStateChanged(state == 15);
    }
}

