/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.treeviewer.browser.ContainerFinder;
import org.openmicroscopy.shoola.agents.treeviewer.browser.NodeSelectionVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.EditVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.RefreshVisitor;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserUI view;
    private BrowserControl controller;
    private TreeImageDisplay toSelectAfterSave;

    private void removeNodes(List nodes) {
        TreeImageDisplay parentDisplay = this.getLastSelectedDisplay() == null ? this.view.getTreeRoot() : this.getLastSelectedDisplay().getParentDisplay();
        if (parentDisplay == null) {
            parentDisplay = this.view.getTreeRoot();
        }
        this.setSelectedDisplay(parentDisplay);
        this.view.removeNodes(nodes, parentDisplay);
    }

    private void createNodes(List nodes, TreeImageDisplay display, TreeImageDisplay parentDisplay) {
        this.setSelectedDisplay(display);
        Object ho = display.getUserObject();
        if (ho instanceof ProjectData || ho instanceof ScreenData) {
            display.setChildrenLoaded(Boolean.TRUE);
        } else if (ho instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)ho;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                display.setChildrenLoaded(Boolean.TRUE);
            } else {
                display.setChildrenLoaded(Boolean.FALSE);
            }
        } else {
            display.setChildrenLoaded(Boolean.FALSE);
        }
        this.view.createNodes(nodes, display, parentDisplay);
        this.countItems(null);
    }

    private void handleNodeDisplay(TreeImageDisplay node) {
        this.view.selectFoundNode(node);
    }

    private boolean hasDataToSave(TreeImageDisplay node) {
        if (this.model.getParentModel().hasDataToSave()) {
            this.model.getParentModel().showPreSavingDialog();
            return false;
        }
        return false;
    }

    private void countItems(Class rootType) {
        if (rootType == null) {
            int type = this.model.getBrowserType();
            if (type == 100) {
                rootType = DatasetData.class;
            } else if (type == 102) {
                rootType = TagAnnotationData.class;
            }
        }
        ContainerFinder finder = new ContainerFinder(rootType);
        this.accept(finder, 1);
        Set<DataObject> items = finder.getContainers();
        Set<TreeImageSet> nodes = finder.getContainerNodes();
        this.model.fireContainerCountLoading(items, nodes);
    }

    private void setSelectedDisplay(TreeImageDisplay display, boolean single) {
        Object ho;
        switch (this.model.getState()) {
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        this.hasDataToSave(display);
        TreeImageDisplay oldDisplay = this.model.getLastSelectedDisplay();
        TreeImageDisplay exp = null;
        if (display != null && (ho = display.getUserObject()) instanceof ExperimenterData) {
            exp = display;
            display = null;
        }
        if (exp != null) {
            this.model.setSelectedDisplay(exp, single);
        } else {
            this.model.setSelectedDisplay(display, single);
        }
        if (display == null) {
            this.view.setNullSelectedNode();
        }
        this.firePropertyChange("selectedTreeNodeDisplay", oldDisplay, display);
    }

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl(this);
        this.view = new BrowserUI();
    }

    void initialize(ExperimenterData exp) {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, exp);
    }

    BrowserModel getModel() {
        return this.model;
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 10: {
                this.view.loadExperimenterData();
                break;
            }
            case 16: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public void discard() {
        if (this.model.getState() != 16) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public JComponent getUI() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    @Override
    public int getBrowserType() {
        return this.model.getBrowserType();
    }

    @Override
    public void cancel() {
        int state = this.model.getState();
        if (state == 11 || state == 12) {
            this.model.cancel();
            this.view.cancel(this.model.getLastSelectedDisplay());
            this.fireStateChange();
        }
    }

    public void loadFilteredImagesForHierarchy() {
        int state = this.model.getState();
        if (state == 16 || state == 12) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
        }
        if (this.model.getBrowserType() != 101) {
            throw new IllegalArgumentException("Method should only be invoked by the Images Explorer.");
        }
        this.view.loadAction(this.view.getTreeRoot());
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setLeaves(Set leaves, TreeImageSet parent, TreeImageSet expNode) {
        if (this.model.getState() != 12) {
            return;
        }
        if (leaves == null) {
            throw new NullPointerException("No leaves.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter not valid");
        }
        ExperimenterData exp = (ExperimenterData)ho;
        long userID = exp.getId();
        long groupID = -1L;
        Set visLeaves = TreeViewerTranslator.transformHierarchy(leaves, userID, groupID);
        this.view.setLeavesViews(visLeaves, parent);
        this.model.setState(15);
        if (parent != null && parent.getUserObject() instanceof TagAnnotationData) {
            this.countItems(DatasetData.class);
        }
        this.model.getParentModel().setLeaves(parent, leaves);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public void setWells(Set wells, TreeImageSet parent) {
        if (this.model.getState() != 14) {
            return;
        }
        this.model.setState(15);
        this.model.getParentModel().setWells(parent, wells);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public void setSelectedDisplay(TreeImageDisplay display) {
        this.setSelectedDisplay(display, true);
    }

    @Override
    public void showPopupMenu(int index) {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                return;
            }
        }
        switch (index) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported: " + index);
            }
        }
        this.firePropertyChange("popupMenu", -1, index);
    }

    @Override
    public Point getClickPoint() {
        return this.model.getClickPoint();
    }

    @Override
    public TreeImageDisplay getLastSelectedDisplay() {
        return this.model.getLastSelectedDisplay();
    }

    @Override
    public void close() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                throw new IllegalStateException("This method can only be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        this.firePropertyChange("close", null, this);
    }

    @Override
    public void collapse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        this.view.collapsePath(node);
    }

    @Override
    public void accept(TreeImageDisplayVisitor visitor) {
        this.accept(visitor, 2);
    }

    @Override
    public void accept(TreeImageDisplayVisitor visitor, int algoType) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.getTreeRoot().accept(visitor, algoType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public String getTitle() {
        return this.view.getBrowserTitle();
    }

    @Override
    public Icon getIcon() {
        IconManager im = IconManager.getInstance();
        switch (this.model.getBrowserType()) {
            case 100: {
                return im.getIcon(0);
            }
            case 102: {
                return im.getIcon(68);
            }
            case 101: {
                return im.getIcon(2);
            }
            case 103: {
                return im.getIcon(74);
            }
            case 104: {
                return im.getIcon(80);
            }
        }
        return null;
    }

    @Override
    public void sortTreeNodes(int sortType) {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        switch (sortType) {
            case 300: 
            case 301: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SortType not supported.");
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.sortNodes(sortType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public long getRootID() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method can't only be invoked in the DISCARDED state.");
        }
        return this.model.getRootID();
    }

    @Override
    public void setContainerCountValue(long containerID, long value, Set<TreeImageSet> nodes) {
        boolean b = this.model.setContainerCountValue(this.view.getTreeDisplay(), containerID, value, nodes);
        if (b) {
            this.view.getTreeDisplay().repaint();
        }
        this.model.getParentModel().setStatus(false, "", true);
    }

    @Override
    public void setFoundInBrowser(Set nodes) {
        if (nodes == null || nodes.size() == 0) {
            this.model.setFoundNodes(null);
            this.model.setFoundNodeIndex(-1);
            this.view.getTreeDisplay().repaint();
            return;
        }
        ArrayList list = new ArrayList(nodes.size());
        Iterator i = nodes.iterator();
        final JTree tree = this.view.getTreeDisplay();
        while (i.hasNext()) {
            list.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                TreeImageDisplay node1 = (TreeImageDisplay)o1;
                TreeImageDisplay node2 = (TreeImageDisplay)o2;
                int i1 = tree.getRowForPath(new TreePath(node1.getPath()));
                int i2 = tree.getRowForPath(new TreePath(node2.getPath()));
                return i1 - i2;
            }
        };
        Collections.sort(list, c);
        this.model.setFoundNodes(list);
        this.model.setFoundNodeIndex(0);
        this.handleNodeDisplay((TreeImageDisplay)list.get(0));
        tree.repaint();
    }

    @Override
    public void findNext() {
        int n;
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index < (n = l.size() - 1)) {
            ++index;
        } else if (index == n) {
            index = 0;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    @Override
    public void findPrevious() {
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index > 0) {
            --index;
        } else if (index == 0) {
            index = l.size() - 1;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    @Override
    public void setSelected(boolean b) {
        switch (this.model.getState()) {
            case 16: {
                throw new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        boolean old = this.model.isSelected();
        if (old == b) {
            return;
        }
        TreeImageDisplay[] nodes = this.model.getSelectedDisplays();
        this.setSelectedDisplays(nodes);
        this.model.setSelected(b);
    }

    @Override
    public void refreshEdition(DataObject object, DataObject parent, int op) {
        EditVisitor visitor;
        switch (this.model.getState()) {
            case 10: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        Object o = object;
        List<TreeImageDisplay> nodes = null;
        TreeImageDisplay parentDisplay = null;
        TreeImageDisplay loggedUser = this.view.getLoggedExperimenterNode();
        if (op == 300) {
            TreeImageDisplay node = this.getLastSelectedDisplay();
            if (object instanceof ProjectData || object instanceof ScreenData || object instanceof DatasetData && parent == null || object instanceof TagAnnotationData && parent == null) {
                nodes = new ArrayList<TreeImageDisplay>(1);
                nodes.add(loggedUser);
                parentDisplay = loggedUser;
            } else if (parent != null) {
                o = node.getUserObject();
            }
        }
        if (nodes == null && parent == null) {
            visitor = new EditVisitor(this, o, null);
            loggedUser.accept(visitor, 2);
            nodes = visitor.getFoundNodes();
        }
        if (parent != null) {
            visitor = new EditVisitor(this, null, parent);
            loggedUser.accept(visitor, 2);
            nodes = visitor.getParentNodes();
        }
        if (op == 301) {
            this.view.updateNodes(nodes, object);
        } else if (op == 302) {
            this.removeNodes(nodes);
        } else if (op == 300) {
            long userID = this.model.getUserID();
            long groupID = this.model.getUserGroupID();
            if (parentDisplay == null) {
                parentDisplay = this.getLastSelectedDisplay();
            }
            TreeImageDisplay newNode = TreeViewerTranslator.transformDataObject(object, userID, groupID);
            this.createNodes(nodes, newNode, parentDisplay);
        }
        this.setSelectedNode();
    }

    @Override
    public void onOrphanDataObjectCreated(DataObject data) {
        int type = this.model.getBrowserType();
        if (data instanceof DatasetData || data instanceof DatasetData ? type != 100 : data instanceof TagAnnotationData && type != 102) {
            return;
        }
        TreeImageDisplay loggedUser = this.view.getLoggedExperimenterNode();
        ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>(1);
        nodes.add(loggedUser);
        long userID = this.model.getUserID();
        long groupID = this.model.getUserGroupID();
        this.createNodes(nodes, TreeViewerTranslator.transformDataObject(data, userID, groupID), loggedUser);
        this.setSelectedNode();
    }

    @Override
    public TreeImageDisplay[] getSelectedDisplays() {
        return this.model.getSelectedDisplays();
    }

    @Override
    public List getSelectedDataObjects() {
        TreeImageDisplay[] nodes = this.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        for (int i = 0; i < nodes.length; ++i) {
            Object uo = nodes[i].getUserObject();
            if (!(uo instanceof DataObject)) continue;
            objects.add((DataObject)uo);
        }
        return objects;
    }

    @Override
    public void setSelectedDisplays(TreeImageDisplay[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        if (nodes.length == 1) {
            this.setSelectedDisplay(nodes[0], true);
        }
        TreeImageDisplay[] oldNodes = this.model.getSelectedDisplays();
        boolean flush = false;
        if (oldNodes.length >= nodes.length) {
            flush = true;
        }
        int n = nodes.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                this.model.setSelectedDisplay(nodes[i], flush);
                continue;
            }
            this.model.setSelectedDisplay(nodes[i], false);
        }
        this.firePropertyChange("selectedTreeNodeDisplay", null, nodes[n - 1]);
    }

    @Override
    public void onComponentStateChange(boolean b) {
        this.view.onComponentStateChange(b);
    }

    @Override
    public boolean isDisplayed() {
        return this.model.isDisplayed();
    }

    @Override
    public void setDisplayed(boolean displayed) {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setDisplayed(displayed);
    }

    @Override
    public void setRefreshedHierarchy(Map nodes, Map expandedTopNodes) {
        if (this.model.getState() != 11) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.countItems(null);
        this.model.getParentModel().setStatus(false, "", true);
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.fireStateChange();
    }

    @Override
    public void displaysImagesName() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.view.repaint();
    }

    @Override
    public void loadExperimenterData(TreeImageDisplay exp, TreeImageDisplay n) {
        if (exp == null || !(exp.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        switch (this.model.getState()) {
            case 12: 
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED or LOADING_LEAVES state.");
            }
        }
        if (n == null) {
            this.model.fireExperimenterDataLoading((TreeImageSet)exp);
        } else {
            this.model.fireLeavesLoading(exp, n);
        }
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setExperimenterData(TreeImageDisplay expNode, Collection nodes) {
        int state = this.model.getState();
        if (state != 11) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_DATA state.");
        }
        if (nodes == null) {
            throw new NullPointerException("No nodes.");
        }
        if (expNode == null) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        Object uo = expNode.getUserObject();
        if (!(uo instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        ExperimenterData exp = (ExperimenterData)uo;
        Set convertedNodes = TreeViewerTranslator.transformHierarchy(nodes, exp.getId(), -1L);
        this.view.setExperimenterData(convertedNodes, expNode);
        this.model.setState(15);
        this.countItems(null);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public void addExperimenter(ExperimenterData experimenter, boolean load) {
        if (experimenter == null) {
            throw new IllegalArgumentException("Experimenter cannot be null.");
        }
        this.setSelectedDisplay(null);
        this.view.addExperimenter(experimenter, load);
    }

    @Override
    public void removeExperimenter(ExperimenterData exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter cannot be null.");
        }
        this.view.removeExperimenter(exp);
    }

    @Override
    public void refreshExperimenterData() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        TreeImageDisplay display = this.model.getLastSelectedDisplay();
        if (display == null) {
            return;
        }
        Object ho = display.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            return;
        }
        RefreshVisitor v = new RefreshVisitor(this);
        display.accept(v, 1);
        RefreshExperimenterDef def = new RefreshExperimenterDef((TreeImageSet)display, v.getFoundNodes(), v.getExpandedTopNodes());
        HashMap<Long, RefreshExperimenterDef> m = new HashMap<Long, RefreshExperimenterDef>(1);
        m.put(display.getUserObjectId(), def);
        this.model.loadRefreshExperimenterData(m);
        this.fireStateChange();
    }

    @Override
    public void refreshLoggedExperimenterData() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        TreeImageDisplay node = this.view.getLoggedExperimenterNode();
        if (node == null) {
            return;
        }
        Object ho = node.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            return;
        }
        RefreshVisitor v = new RefreshVisitor(this);
        node.accept(v, 1);
        RefreshExperimenterDef def = new RefreshExperimenterDef((TreeImageSet)node, v.getFoundNodes(), v.getExpandedTopNodes());
        HashMap<Long, RefreshExperimenterDef> m = new HashMap<Long, RefreshExperimenterDef>(1);
        m.put(node.getUserObjectId(), def);
        this.model.loadRefreshExperimenterData(m);
        this.fireStateChange();
    }

    @Override
    public void refreshTree() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        TreeImageDisplay root = this.view.getTreeRoot();
        RefreshVisitor v = new RefreshVisitor(this);
        int n = root.getChildCount();
        HashMap<Long, RefreshExperimenterDef> m = new HashMap<Long, RefreshExperimenterDef>(n);
        for (int i = 0; i < n; ++i) {
            TreeImageSet expNode = (TreeImageSet)root.getChildAt(i);
            expNode.accept(v, 1);
            RefreshExperimenterDef def = new RefreshExperimenterDef(expNode, v.getFoundNodes(), v.getExpandedTopNodes());
            m.put(expNode.getUserObjectId(), def);
        }
        this.model.loadRefreshExperimenterData(m);
        this.fireStateChange();
    }

    @Override
    public void setRefreshExperimenterData(Map<Long, RefreshExperimenterDef> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Iterator<Long> i = nodes.keySet().iterator();
        int browserType = this.model.getBrowserType();
        while (i.hasNext()) {
            long userId = i.next();
            RefreshExperimenterDef node = nodes.get(userId);
            TreeImageSet expNode = node.getExperimenterNode();
            ExperimenterData exp = (ExperimenterData)expNode.getUserObject();
            if (browserType == 101 || browserType == 104) {
                Map<Integer, Set> results = TreeViewerTranslator.refreshFolderHierarchy((Map)node.getResults(), exp.getId(), -1L);
                this.view.refreshFolder(expNode, results);
                continue;
            }
            Set convertedNodes = TreeViewerTranslator.refreshHierarchy((Map)node.getResults(), node.getExpandedTopNodes(), exp.getId(), -1L);
            this.view.setExperimenterData(convertedNodes, expNode);
        }
        this.model.setSelectedDisplay(null, true);
        this.model.setState(15);
        this.countItems(null);
        this.model.getParentModel().setStatus(false, "", true);
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.fireStateChange();
    }

    @Override
    public void countExperimenterImages(TreeImageDisplay expNode) {
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        switch (this.model.getState()) {
            case 12: 
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
            }
        }
        int browserType = this.model.getBrowserType();
        if (browserType != 101 && browserType != 104) {
            return;
        }
        this.model.fireCountExperimenterImages((TreeImageSet)expNode);
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setExperimenterCount(TreeImageSet expNode, int index, Object v) {
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        int browserType = this.model.getBrowserType();
        if (browserType != 101 && browserType != 104) {
            return;
        }
        boolean b = this.model.setExperimenterCount(expNode, index);
        if (index != -1 && v != null) {
            this.view.setCountValues(expNode, index, v);
        }
        if (b) {
            this.view.getTreeDisplay().repaint();
        }
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public ExperimenterData getNodeOwner(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        TreeImageDisplay n = this.controller.getDataOwner(node);
        if (n == null) {
            return this.model.getUserDetails();
        }
        return (ExperimenterData)n.getUserObject();
    }

    @Override
    public JComponent getClickComponent() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getTreeDisplay();
    }

    @Override
    public void setSelectedNode() {
        if (this.toSelectAfterSave == null) {
            return;
        }
        this.setSelectedDisplay(this.toSelectAfterSave);
        this.toSelectAfterSave = null;
    }

    @Override
    public void refreshExperimenter() {
        if (this.model.getState() == 16) {
            return;
        }
        this.view.refreshExperimenter();
    }

    @Override
    public void browse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        this.model.getParentModel().browse(node);
    }

    @Override
    public void onSelectedNode(Object parent, Object selected, Boolean multiSelection) {
        if (selected instanceof DataObject) {
            NodeSelectionVisitor visitor = new NodeSelectionVisitor(parent, (DataObject)selected);
            this.accept(visitor);
            TreeImageDisplay foundNode = visitor.getSelectedNode();
            if (foundNode != null) {
                if (multiSelection.booleanValue()) {
                    this.model.addFoundNode(foundNode);
                } else {
                    this.model.setSelectedDisplay(foundNode, true);
                }
                this.view.setFoundNode(this.model.getSelectedDisplays());
            } else {
                this.view.setFoundNode(null);
            }
        }
    }

    @Override
    public void onDeselectedNode(Object parent, Object selected, Boolean multiSelection) {
        if (selected instanceof DataObject) {
            NodeSelectionVisitor visitor = new NodeSelectionVisitor(parent, (DataObject)selected);
            this.accept(visitor);
            TreeImageDisplay foundNode = visitor.getSelectedNode();
            if (foundNode != null) {
                this.model.removeDisplay(foundNode);
                this.view.setFoundNode(this.model.getSelectedDisplays());
            } else {
                this.view.setFoundNode(null);
            }
        }
    }

    @Override
    public void setTimeIntervalImages(Set set, TreeImageTimeSet node) {
        this.model.getParentModel().browseTimeInterval(node, set);
    }
}

