/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class ViewImageAction
extends TreeViewerAction {
    private static final String NAME = "View...";
    private static final String DESCRIPTION = "View the selected image.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || selectedDisplay.getParentDisplay() == null || selectedDisplay instanceof TreeImageTimeSet) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        this.setEnabled(ho instanceof ImageData);
    }

    public ViewImageAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        IconManager icons = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", icons.getIcon(9));
    }

    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model);
        cmd.execute();
    }
}

