/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;

public class RemoveExperimenterNode
extends TreeViewerAction {
    private static final String NAME = "Remove User";
    private static final String DESCRIPTION = "Remove the data of theselected user from the display.";

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || selectedDisplay.getParentDisplay() == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho == null || !(ho instanceof ExperimenterData)) {
            this.setEnabled(false);
        } else {
            Browser browser = this.model.getSelectedBrowser();
            if (browser != null) {
                if (browser.getSelectedDisplays().length > 1) {
                    this.setEnabled(false);
                } else {
                    ExperimenterData exp = (ExperimenterData)ho;
                    this.setEnabled(exp.getId() != browser.getRootID());
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    public RemoveExperimenterNode(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(26));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.removeExperimenterData();
    }
}

