/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteRndSettingsCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;

public class PasteRndSettingsAction
extends TreeViewerAction {
    private static final String NAME = "Paste Settings";
    private static final String DESCRIPTION = "Paste the rendering settings.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!this.model.hasRndSettings()) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (ho == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        int n = browser.getSelectedDisplays().length;
        if (selectedDisplay instanceof TreeImageTimeSet) {
            if (n > 1) {
                this.setEnabled(false);
            } else {
                TreeImageTimeSet timeNode = (TreeImageTimeSet)selectedDisplay;
                this.setEnabled(timeNode.getNumberItems() > 0L);
            }
            return;
        }
        if (!(ho instanceof ImageData) && !(ho instanceof DatasetData)) {
            this.setEnabled(false);
        } else if (n > 1) {
            this.setEnabled(ho instanceof ImageData);
        } else {
            this.setEnabled(true);
        }
    }

    public PasteRndSettingsAction(TreeViewer model) {
        super(model);
        this.setEnabled(false);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(25));
    }

    public void actionPerformed(ActionEvent e) {
        PasteRndSettingsCmd cmd = new PasteRndSettingsCmd(this.model, 0);
        cmd.execute();
    }
}

