/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.PasteCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class PasteAction
extends TreeViewerAction {
    private static final String NAME = "Paste";
    private static final String DESCRIPTION = "Paste the selected elements.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Class klass = this.model.hasDataToCopy();
        if (klass == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ProjectData) {
            if (DatasetData.class.equals((Object)klass)) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof ScreenData) {
            if (PlateData.class.equals((Object)klass)) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof DatasetData) {
            if (ImageData.class.equals((Object)klass)) {
                this.setEnabled(this.model.isObjectWritable(ho));
            } else {
                this.setEnabled(false);
            }
        } else if (ho instanceof TagAnnotationData) {
            if (TagAnnotationData.class.equals((Object)klass)) {
                TagAnnotationData tag = (TagAnnotationData)ho;
                if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                    this.setEnabled(this.model.isObjectWritable(ho));
                }
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public PasteAction(TreeViewer model) {
        super(model);
        this.setEnabled(false);
        this.name = NAME;
        this.putValue("Name", NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(25));
    }

    public void actionPerformed(ActionEvent e) {
        PasteCmd cmd = new PasteCmd(this.model);
        cmd.execute();
    }
}

