/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

public class EditorAction
extends TreeViewerAction {
    public static final int NO_SELECTION = 0;
    public static final int WITH_SELECTION = 1;
    public static final int NEW_WITH_SELECTION = 2;
    private static final String NAME = "Launch Editor...";
    private static final String NAME_EXPERIMENT = "New Experiment...";
    private static final String DESCRIPTION = "Launch the Editor.";
    private int index;

    private void checkValue(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                this.index = index;
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        this.onBrowserStateChange(this.model.getSelectedBrowser());
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        int state = browser.getState();
        switch (this.index) {
            case 1: {
                if (state == 15) {
                    List l = browser.getSelectedDataObjects();
                    if (l == null || l.size() != 1) {
                        this.setEnabled(false);
                        break;
                    }
                    Object object = l.get(0);
                    this.setEnabled(object instanceof FileAnnotationData);
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 0: {
                this.setEnabled(state == 15);
                break;
            }
            case 2: {
                if (state == 15) {
                    List l = browser.getSelectedDataObjects();
                    if (l == null || l.size() != 1) {
                        this.setEnabled(false);
                        break;
                    }
                    Object object = l.get(0);
                    if (object instanceof ProjectData || object instanceof DatasetData || object instanceof ImageData || object instanceof ScreenData || object instanceof PlateData) {
                        this.setEnabled(true);
                        break;
                    }
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(false);
            }
        }
    }

    public EditorAction(TreeViewer model, int index) {
        super(model);
        this.name = NAME;
        this.checkValue(index);
        if (index == 2) {
            this.name = NAME_EXPERIMENT;
        }
        IconManager icons = IconManager.getInstance();
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", icons.getIcon(79));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.openEditorFile(this.index);
    }
}

