/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ProjectData;
import pojos.TagAnnotationData;

public class CreateTopContainerAction
extends TreeViewerAction {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int TAG = 2;
    public static final int SCREEN = 3;
    public static final int TAG_SET = 6;
    private static final String NAME = "New...";
    private static final String NAME_PROJECT = "New Project...";
    private static final String NAME_DATASET = "New Dataset...";
    private static final String NAME_TAG = "New Tag...";
    private static final String NAME_TAG_SET = "New Tag Set...";
    private static final String NAME_SCREEN = "New Screen...";
    private static final String DESCRIPTION_TAG_SET = "Create a new Tag Set.";
    private static final String DESCRIPTION_TAG = "Create a new Tag.";
    private static final String DESCRIPTION_DATASET = "Create a new Dataset.";
    private static final String DESCRIPTION_PROJECT = "Create a new Project.";
    private static final String DESCRIPTION_SCREEN = "Create a new Screen.";
    private int nodeType;

    private void checkType(int value) {
        IconManager icons = IconManager.getInstance();
        switch (value) {
            case 0: {
                this.name = NAME_PROJECT;
                this.putValue("SmallIcon", icons.getIcon(4));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PROJECT));
                break;
            }
            case 1: {
                this.name = NAME_DATASET;
                this.putValue("SmallIcon", icons.getIcon(5));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
                break;
            }
            case 2: {
                this.name = NAME_TAG;
                this.putValue("SmallIcon", icons.getIcon(69));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG));
                break;
            }
            case 6: {
                this.name = NAME_TAG_SET;
                this.putValue("SmallIcon", icons.getIcon(71));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG_SET));
                break;
            }
            case 3: {
                this.name = NAME_SCREEN;
                this.putValue("SmallIcon", icons.getIcon(75));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SCREEN));
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported.");
            }
        }
    }

    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.setEnabled(true);
            }
        }
    }

    protected void onBrowserSelection(Browser browser) {
        if (browser == null) {
            this.setEnabled(false);
            this.name = NAME;
        }
        this.description = (String)this.getValue("ShortDescription");
    }

    public CreateTopContainerAction(TreeViewer model, int nodeType) {
        super(model);
        this.checkType(nodeType);
        this.nodeType = nodeType;
        this.onBrowserSelection(model.getSelectedBrowser());
    }

    public void actionPerformed(ActionEvent e) {
        int n;
        if (this.nodeType == -1) {
            return;
        }
        boolean withParent = false;
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null && (n = browser.getSelectedDisplays().length) == 1) {
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            Object uo = node.getUserObject();
            switch (this.nodeType) {
                case 1: {
                    if (!(uo instanceof ProjectData)) break;
                    withParent = true;
                    break;
                }
                case 2: {
                    if (!(uo instanceof TagAnnotationData)) break;
                    TagAnnotationData tag = (TagAnnotationData)uo;
                    String ns = tag.getNameSpace();
                    if (ns == null || "openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                        // empty if block
                    }
                    withParent = true;
                }
            }
        }
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType);
        cmd.setWithParent(withParent);
        cmd.execute();
    }
}

