/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

public class CopyRndSettingsAction
extends TreeViewerAction {
    private static final String NAME = "Copy Settings";
    private static final String DESCRIPTION = "Copy the image's rendering settings.";

    protected void onBrowserStateChange(Browser browser) {
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (ho == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        int n = browser.getSelectedDisplays().length;
        if (n > 1) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(ho instanceof ImageData);
    }

    public CopyRndSettingsAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(24));
    }

    public void actionPerformed(ActionEvent e) {
        this.model.copyRndSettings(null);
    }
}

