/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

public class BrowseContainerAction
extends TreeViewerAction {
    private static final String NAME = "Browse";
    private static final String DESCRIPTION_DEFAULT = "Browse.";
    private static final String DESCRIPTION_PROJECT = "Browse the selected Project.";
    private static final String DESCRIPTION_TAG = "Browse the selected Tag.";
    private static final String DESCRIPTION_TIME = "Browse the selected period.";
    private static final String DESCRIPTION_PLATE = "Browse the selected Plate.";
    private static IconManager icons = IconManager.getInstance();

    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        if (selectedDisplay.getParentDisplay() == null) {
            this.name = NAME;
            this.setEnabled(false);
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        Browser browser = this.model.getSelectedBrowser();
        if (selectedDisplay instanceof TreeImageTimeSet) {
            this.name = NAME;
            this.putValue("SmallIcon", icons.getIcon(60));
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TIME));
            if (browser.getSelectedDisplays().length > 1) {
                this.setEnabled(false);
            } else {
                TreeImageTimeSet timeNode = (TreeImageTimeSet)selectedDisplay;
                long number = timeNode.getNumberItems();
                this.setEnabled(number > 0L);
            }
            return;
        }
        if (ho == null || !(ho instanceof DataObject) || ho instanceof ExperimenterData || ho instanceof ImageData || ho instanceof FileAnnotationData || ho instanceof DatasetData) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
            this.setEnabled(false);
        } else {
            if (browser != null && browser.getSelectedDisplays().length > 1) {
                this.setEnabled(true);
                this.setEnabled(false);
                this.name = NAME;
                this.putValue("SmallIcon", icons.getIcon(60));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
                return;
            }
            this.name = NAME;
            this.putValue("SmallIcon", icons.getIcon(60));
            String description = DESCRIPTION_DEFAULT;
            if (selectedDisplay instanceof TreeImageSet) {
                long n = ((TreeImageSet)selectedDisplay).getNumberItems();
                if (ho instanceof ScreenData) {
                    this.setEnabled(false);
                } else if (ho instanceof PlateData) {
                    this.setEnabled(true);
                    description = DESCRIPTION_PLATE;
                } else if (ho instanceof ProjectData) {
                    description = DESCRIPTION_PROJECT;
                    this.setEnabled(n > 0L);
                } else if (ho instanceof TagAnnotationData) {
                    String ns = ((TagAnnotationData)ho).getNameSpace();
                    if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                        this.setEnabled(false);
                    } else {
                        description = DESCRIPTION_TAG;
                        this.setEnabled(n > 0L);
                    }
                }
            }
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(description));
        }
    }

    public BrowseContainerAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DEFAULT));
        this.putValue("SmallIcon", icons.getIcon(60));
    }

    public void actionPerformed(ActionEvent e) {
        ViewCmd cmd = new ViewCmd(this.model);
        cmd.execute();
    }
}

