/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.SaveEventRequest;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeViewerAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    private void handleCopyRndSettings(CopyRndSettings evt) {
        TreeViewerFactory.copyRndSettings(evt.getImage());
    }

    private void handleSaveEventRequest(SaveEventRequest evt) {
        Object origin = evt.getOrigin();
        if (!(origin instanceof TreeViewer)) {
            return;
        }
        TreeViewerFactory.saveOnClose(evt, this);
    }

    @Override
    public void activate() {
        long id;
        Environment env = (Environment)registry.lookup("/env");
        if (!env.isServerAvailable()) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)registry.lookup("/current_user/details");
        TreeViewer viewer = TreeViewerFactory.getTreeViewer(exp, id = exp.getDefaultGroup().getId());
        if (viewer != null) {
            viewer.activate();
        }
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveEventRequest.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public Map<String, Set> hasDataToSave() {
        return TreeViewerFactory.hasDataToSave();
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof SaveEventRequest) {
            this.handleSaveEventRequest((SaveEventRequest)e);
        }
    }
}

