/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DatasetData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RndSettingsSaver
extends DataTreeViewerLoader {
    public static final int PASTE = 0;
    public static final int RESET = 1;
    public static final int SET = 2;
    private long pixelsID;
    private Class rootType;
    private List<Long> ids;
    private TimeRefObject ref;
    private CallHandle handle;
    private int index;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    private void checkRootType(Class type) {
        if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type)) {
            return;
        }
        throw new IllegalArgumentException("Type not supported.");
    }

    public RndSettingsSaver(TreeViewer viewer, Class rootType, List<Long> ids, int index) {
        super(viewer);
        this.checkRootType(rootType);
        this.checkIndex(index);
        this.index = index;
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.rootType = rootType;
        this.ids = ids;
        this.ref = null;
    }

    public RndSettingsSaver(TreeViewer viewer, TimeRefObject ref, int index) {
        super(viewer);
        this.checkIndex(index);
        this.index = index;
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.ref = ref;
    }

    public RndSettingsSaver(TreeViewer viewer, Class rootType, List<Long> ids, long pixelsID) {
        super(viewer);
        this.checkRootType(rootType);
        this.index = 0;
        if (ids == null || ids.size() == 0) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.rootType = rootType;
        this.pixelsID = pixelsID;
        this.ids = ids;
        this.ref = null;
    }

    public RndSettingsSaver(TreeViewer viewer, TimeRefObject ref, long pixelsID) {
        super(viewer);
        this.index = 0;
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.pixelsID = pixelsID;
        this.ref = ref;
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        switch (this.index) {
            case 0: {
                if (this.ref == null) {
                    this.handle = this.dhView.pasteRndSettings(this.pixelsID, this.rootType, this.ids, this);
                    break;
                }
                this.handle = this.dhView.pasteRndSettings(this.pixelsID, this.ref, this);
                break;
            }
            case 1: {
                if (this.ref == null) {
                    this.handle = this.dhView.resetRndSettings(this.rootType, this.ids, this);
                    break;
                }
                this.handle = this.dhView.resetRndSettings(this.ref, this);
                break;
            }
            case 2: {
                this.handle = this.ref == null ? this.dhView.setRndSettings(this.rootType, this.ids, this) : this.dhView.setRndSettings(this.ref, this);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.rndSettingsPasted((Map)result);
    }
}

