/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshExperimenterDataLoader
extends DataBrowserLoader {
    private Class rootNodeType;
    private Map<Long, RefreshExperimenterDef> expNodes;
    private CallHandle handle;

    private void checkClass(Class klass) {
        if (ProjectData.class.equals((Object)klass) || ImageData.class.equals((Object)klass) || TagAnnotationData.class.equals((Object)klass) || DatasetData.class.equals((Object)klass) || FileAnnotationData.class.equals((Object)klass) || ScreenData.class.equals((Object)klass)) {
            return;
        }
        throw new IllegalArgumentException("Root node not supported.");
    }

    private void setExperimenterResult(long expId, Object result) {
        HashMap map;
        RefreshExperimenterDef node = this.expNodes.get(expId);
        Map expandedNodes = node.getExpandedTopNodes();
        if (expandedNodes == null || expandedNodes.size() == 0 || result instanceof Collection) {
            Collection set = (Collection)result;
            Iterator j = set.iterator();
            map = new HashMap();
            Set<Object> children = null;
            while (j.hasNext()) {
                DataObject parent = (DataObject)j.next();
                if (parent instanceof ProjectData) {
                    children = ((ProjectData)parent).getDatasets();
                } else if (parent instanceof DatasetData) {
                    children = new HashSet<DataObject>(1);
                    children.add(parent);
                } else if (parent instanceof TagAnnotationData) {
                    children = new HashSet(1);
                    children.add(parent);
                } else if (parent instanceof ScreenData) {
                    children = ((ScreenData)parent).getPlates();
                }
                map.put(parent, children);
            }
        } else {
            map = (HashMap)result;
        }
        node.setResults(map);
    }

    private void formatSmartFolderResult(long expId, List result) {
        RefreshExperimenterDef node = this.expNodes.get(expId);
        List nodes = node.getExpandedNodes();
        int n = nodes.size();
        HashMap<TreeImageSet, Collection> m = new HashMap<TreeImageSet, Collection>();
        for (int i = 0; i < n; ++i) {
            TreeImageSet display = (TreeImageSet)nodes.get(i);
            TimeRefObject ref = (TimeRefObject)result.get(i);
            m.put(display, ref.getResults());
        }
        node.setResults(m);
    }

    public RefreshExperimenterDataLoader(Browser viewer, Class rootNodeType, Map<Long, RefreshExperimenterDef> expNodes) {
        super(viewer);
        if (expNodes == null || expNodes.size() == 0) {
            throw new IllegalArgumentException("Experimenter nodes not valid.");
        }
        this.checkClass(rootNodeType);
        this.rootNodeType = rootNodeType;
        this.expNodes = expNodes;
    }

    @Override
    public void load() {
        Iterator<Map.Entry<Long, RefreshExperimenterDef>> i = this.expNodes.entrySet().iterator();
        TimeRefObject ref = null;
        HashMap<Long, List> m = new HashMap<Long, List>(this.expNodes.size());
        if (ImageData.class.equals((Object)this.rootNodeType) || FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            while (i.hasNext()) {
                Map.Entry<Long, RefreshExperimenterDef> entry = i.next();
                long userID = entry.getKey();
                RefreshExperimenterDef def = entry.getValue();
                List nodes = def.getExpandedNodes();
                Iterator j = nodes.iterator();
                ArrayList<TimeRefObject> times = new ArrayList<TimeRefObject>(nodes.size());
                while (j.hasNext()) {
                    TreeImageSet node = (TreeImageSet)j.next();
                    if (node instanceof TreeImageTimeSet) {
                        TreeImageTimeSet time = (TreeImageTimeSet)node;
                        ref = new TimeRefObject(userID, 0);
                        ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                    } else if (node instanceof TreeFileSet) {
                        TreeFileSet file = (TreeFileSet)node;
                        ref = new TimeRefObject(userID, 1);
                        ref.setFileType(file.getType());
                    }
                    if (ref == null) continue;
                    times.add(ref);
                }
                m.put(userID, times);
            }
        } else {
            while (i.hasNext()) {
                Map.Entry<Long, RefreshExperimenterDef> entry = i.next();
                long userID = entry.getKey();
                RefreshExperimenterDef def = entry.getValue();
                m.put(userID, def.getExpandedNodes());
            }
        }
        this.handle = this.dmView.refreshHierarchy(this.rootNodeType, m, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        Map m = (Map)result;
        Iterator i = m.keySet().iterator();
        if (ImageData.class.equals((Object)this.rootNodeType) || FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            while (i.hasNext()) {
                long expId = (Long)i.next();
                this.formatSmartFolderResult(expId, (List)m.get(expId));
            }
        } else {
            while (i.hasNext()) {
                long expId = (Long)i.next();
                this.setExperimenterResult(expId, m.get(expId));
            }
        }
        this.viewer.setRefreshExperimenterData(this.expNodes);
    }
}

