/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimenterImagesCounter
extends DataBrowserLoader {
    private TreeImageSet expNode;
    private List<TreeImageSet> nodes;
    private CallHandle handle;

    public ExperimenterImagesCounter(Browser viewer, TreeImageSet expNode, List<TreeImageSet> nodes) {
        super(viewer);
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No time node specified node.");
        }
        this.expNode = expNode;
        this.nodes = nodes;
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        Iterator<TreeImageSet> i = this.nodes.iterator();
        long userID = this.expNode.getUserObjectId();
        LinkedHashMap<Integer, TimeRefObject> m = new LinkedHashMap<Integer, TimeRefObject>(this.nodes.size());
        while (i.hasNext()) {
            TimeRefObject ref;
            TreeImageSet node = i.next();
            if (node instanceof TreeImageTimeSet) {
                TreeImageTimeSet time = (TreeImageTimeSet)node;
                ref = new TimeRefObject(userID, 0);
                ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                m.put(time.getType(), ref);
                continue;
            }
            if (!(node instanceof TreeFileSet)) continue;
            TreeFileSet file = (TreeFileSet)node;
            ref = new TimeRefObject(userID, 1);
            switch (file.getType()) {
                case 0: {
                    ref.setFileType(0);
                    break;
                }
                case 1: {
                    ref.setFileType(1);
                    break;
                }
                default: {
                    ref.setFileType(2);
                }
            }
            m.put(file.getType(), ref);
        }
        this.handle = this.dmView.countExperimenterImages(userID, m, this);
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 16) {
            return;
        }
        Map map = (Map)fe.getPartialResult();
        if (map == null || map.size() != 1) {
            return;
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.viewer.setExperimenterCount(this.expNode, (Integer)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Counting Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }
}

