/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ExperimenterData;

public class ExperimenterImageLoader
extends DataBrowserLoader {
    private TreeImageSet expNode;
    private TreeImageSet smartFolderNode;
    private CallHandle handle;

    public ExperimenterImageLoader(Browser viewer, TreeImageSet expNode, TreeImageSet smartFolderNode) {
        super(viewer);
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        if (smartFolderNode == null) {
            throw new IllegalArgumentException("No smart folder specified.");
        }
        this.expNode = expNode;
        this.smartFolderNode = smartFolderNode;
    }

    public void load() {
        ExperimenterData exp = (ExperimenterData)this.expNode.getUserObject();
        if (this.smartFolderNode instanceof TreeImageTimeSet) {
            TreeImageTimeSet time = (TreeImageTimeSet)this.smartFolderNode;
            this.handle = this.dhView.loadImages(time.getStartTime(), time.getEndTime(), exp.getId(), this);
        } else if (this.smartFolderNode instanceof TreeFileSet) {
            this.handle = this.dhView.loadFiles(((TreeFileSet)this.smartFolderNode).getType(), exp.getId(), this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        this.viewer.setLeaves((Set)result, this.smartFolderNode, this.expNode);
    }
}

