/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

public class ExperimenterDataLoader
extends DataBrowserLoader {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int IMAGE = 2;
    public static final int TAG = 3;
    public static final int TAG_SET = 4;
    public static final int FILE = 5;
    private boolean withImages;
    private Class rootNodeType;
    private TreeImageSet parent;
    private TreeImageSet expNode;
    private CallHandle handle;
    private int type;

    private Class getClassType(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                return ProjectData.class;
            }
            case 1: {
                return DatasetData.class;
            }
            case 3: {
                return TagAnnotationData.class;
            }
            case 4: {
                return TagAnnotationData.class;
            }
            case 5: {
                return FileAnnotationData.class;
            }
        }
        return null;
    }

    public ExperimenterDataLoader(Browser viewer, int containerType, TreeImageSet expNode) {
        this(viewer, containerType, expNode, null);
    }

    public ExperimenterDataLoader(Browser viewer, int containerType, TreeImageSet expNode, TreeImageSet parent) {
        super(viewer);
        if (expNode == null || !(expNode.getUserObject() instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        this.parent = parent;
        this.expNode = expNode;
        this.rootNodeType = this.getClassType(containerType);
        if (this.rootNodeType == null) {
            throw new IllegalArgumentException("Type not supported");
        }
        if (parent != null) {
            this.withImages = true;
        }
        if (this.type == 4) {
            this.withImages = false;
        }
    }

    public void load() {
        ExperimenterData exp = (ExperimenterData)this.expNode.getUserObject();
        if (TagAnnotationData.class.equals((Object)this.rootNodeType)) {
            long id = -1L;
            if (this.parent != null) {
                id = this.parent.getUserObjectId();
            }
            boolean top = this.type == 4;
            this.handle = this.dmView.loadTags(id, this.withImages, top, exp.getId(), this);
        } else if (FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            this.handle = this.mhView.loadExistingAnnotations(this.rootNodeType, exp.getId(), this);
        } else if (this.parent == null) {
            this.handle = this.dmView.loadContainerHierarchy(this.rootNodeType, null, this.withImages, exp.getId(), this);
        } else {
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(this.parent.getUserObjectId());
            this.handle = this.dmView.loadContainerHierarchy(this.rootNodeType, ids, this.withImages, exp.getId(), this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
            return;
        }
        if (this.parent == null) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
        } else {
            Collection nodes = (Collection)result;
            Iterator i = nodes.iterator();
            Class<?> klass = this.parent.getUserObject().getClass();
            long id = this.parent.getUserObjectId();
            if (TagAnnotationData.class.equals(klass)) {
                this.viewer.setLeaves((Set)result, this.parent, this.expNode);
            } else {
                while (i.hasNext()) {
                    DataObject object = (DataObject)i.next();
                    if (!object.getClass().equals(klass) || object.getId() != id || !(object instanceof DatasetData)) continue;
                    this.viewer.setLeaves(((DatasetData)object).getImages(), this.parent, this.expNode);
                }
            }
        }
    }
}

