/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Map;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class DataObjectUpdater
extends DataTreeViewerLoader {
    public static final int COPY_AND_PASTE = 0;
    public static final int CUT_AND_PASTE = 1;
    public static final int CUT = 2;
    private int index;
    private Map objectsToUpdate;
    private Map objectsToRemove;
    private CallHandle handle;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Action not supported.");
    }

    public DataObjectUpdater(TreeViewer viewer, Map objects, int index) {
        super(viewer);
        if (objects == null) {
            throw new IllegalArgumentException("No DataObject");
        }
        this.checkIndex(index);
        this.objectsToUpdate = objects;
        this.index = index;
    }

    public DataObjectUpdater(TreeViewer viewer, Map objects, Map toRemove, int index) {
        super(viewer);
        if (objects == null) {
            throw new IllegalArgumentException("No DataObject");
        }
        this.checkIndex(index);
        this.objectsToUpdate = objects;
        this.objectsToRemove = toRemove;
        this.index = index;
    }

    public void load() {
        if (this.index == 0) {
            this.handle = this.dmView.addExistingObjects(this.objectsToUpdate, this);
        } else if (this.index == 1 || this.index == 2) {
            this.handle = this.dmView.cutAndPaste(this.objectsToUpdate, this.objectsToRemove, this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.onNodesMoved();
    }
}

