/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.border.FrameBorder;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

class MetadataViewerUI
extends TopWindow {
    private static final String PROJECT_MSG = "Project";
    private static final String DATASET_MSG = "Dataset";
    private static final String IMAGE_MSG = "Image";
    private static final String TITLE = "Add metadata";
    private static final String DESCRIPTION = "Add comments, tags, etc., to the selected items.";
    private MetadataViewerControl controller;
    private MetadataViewerModel model;
    private JPanel uiDelegate;
    private TitlePanel titlePanel;

    private String getMessage() {
        Class<?> nodeType = this.model.getRefObject().getClass();
        if (nodeType.equals(ProjectData.class)) {
            return PROJECT_MSG;
        }
        if (nodeType.equals(DatasetData.class)) {
            return DATASET_MSG;
        }
        if (nodeType.equals(ImageData.class)) {
            return IMAGE_MSG;
        }
        return "";
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        this.titlePanel = new TitlePanel(TITLE, DESCRIPTION, icons.getIcon(43));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        JSplitPane pane = new JSplitPane();
        pane.setResizeWeight(1.0);
        pane.setOrientation(1);
        pane.setOneTouchExpandable(true);
        pane.setContinuousLayout(true);
        pane.setLeftComponent(this.model.getEditor().getUI());
        this.uiDelegate = new JPanel();
        this.uiDelegate.setLayout(new BorderLayout(0, 0));
        this.uiDelegate.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.uiDelegate.add((Component)this.model.getEditor().getUI(), "Center");
        c.add((Component)((Object)this.titlePanel), "North");
        c.add((Component)this.uiDelegate, "Center");
    }

    MetadataViewerUI() {
        super("");
    }

    void initialize(MetadataViewerControl controller, MetadataViewerModel model) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.buildGUI();
    }

    void setRootObject() {
        String message = this.getMessage();
        this.titlePanel.setTitle(message);
        this.titlePanel.setSubtitle("Edit the " + message.toLowerCase() + ": " + this.model.getRefObjectName());
        this.uiDelegate.revalidate();
        this.uiDelegate.repaint();
    }

    void setThumbnail(BufferedImage thumbnail) {
        JLabel label = new JLabel(new ImageIcon(thumbnail));
        label.setBorder(new FrameBorder(Color.BLACK));
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.uiDelegate.revalidate();
        this.uiDelegate.repaint();
    }

    JComponent getUI() {
        return this.uiDelegate;
    }

    public void setOnScreen() {
    }
}

