/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.metadata.ContainersLoader;
import org.openmicroscopy.shoola.agents.metadata.DataBatchSaver;
import org.openmicroscopy.shoola.agents.metadata.DataSaver;
import org.openmicroscopy.shoola.agents.metadata.ExperimenterEditor;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.StructuredDataLoader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorFactory;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataViewerModel {
    private int state = 1;
    private MetadataViewer component;
    private Object refObject;
    private StructuredDataResults data;
    private Browser browser;
    private Editor editor;
    private Map<TreeBrowserDisplay, MetadataLoader> loaders;
    private Class dataType;
    private boolean singleMode;
    private Collection relatedNodes;

    MetadataViewerModel(Object refObject) {
        this.refObject = refObject;
        this.loaders = new HashMap<TreeBrowserDisplay, MetadataLoader>();
        this.data = null;
        this.dataType = null;
        this.singleMode = true;
    }

    void initialize(MetadataViewer component, boolean thumbnailRequired) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, this.refObject);
        this.editor = EditorFactory.createEditor(component, this.refObject, thumbnailRequired, this.browser);
    }

    void setDataType(Class dataType) {
        this.dataType = dataType;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.state = 4;
        Iterator<TreeBrowserDisplay> i = this.loaders.keySet().iterator();
        while (i.hasNext()) {
            MetadataLoader loader = this.loaders.get(i.next());
            if (loader == null) continue;
            loader.cancel();
        }
        this.loaders.clear();
    }

    void setRootObject(Object refObject) {
        this.refObject = refObject;
        this.browser.setRootObject(refObject);
        this.editor.setRootObject(refObject);
        this.data = null;
    }

    Object getRefObject() {
        return this.refObject;
    }

    Browser getBrowser() {
        return this.browser;
    }

    Editor getEditor() {
        return this.editor;
    }

    void cancel(TreeBrowserDisplay refNode) {
        MetadataLoader loader = this.loaders.get(refNode);
        if (loader != null) {
            loader.cancel();
            this.loaders.remove(refNode);
        }
    }

    void notifyLoadingEnd(TreeBrowserDisplay refNode) {
        MetadataLoader loader = this.loaders.get(refNode);
        if (loader != null) {
            this.loaders.remove(refNode);
        }
    }

    void fireParentLoading(TreeBrowserSet refNode) {
        this.cancel(refNode);
        Object ho = refNode.getUserObject();
        if (ho instanceof DataObject) {
            ContainersLoader loader = new ContainersLoader(this.component, refNode, ho.getClass(), ((DataObject)ho).getId());
            this.loaders.put(refNode, loader);
            loader.load();
        }
    }

    void fireStructuredDataLoading(TreeBrowserDisplay refNode) {
        Object uo = refNode.getUserObject();
        if (!(uo instanceof DataObject)) {
            return;
        }
        if (uo instanceof ExperimenterData) {
            return;
        }
        this.cancel(refNode);
        StructuredDataLoader loader = new StructuredDataLoader(this.component, refNode, (DataObject)uo);
        this.loaders.put(refNode, loader);
        loader.load();
        this.state = 2;
    }

    boolean isSameObject(DataObject uo) {
        if (uo == null || !(this.refObject instanceof DataObject)) {
            return false;
        }
        if (!uo.getClass().equals(this.refObject.getClass())) {
            return false;
        }
        DataObject object = (DataObject)this.refObject;
        if (uo.getId() != object.getId()) {
            return false;
        }
        if (this.data == null) {
            return false;
        }
        Object o = this.data.getRelatedObject();
        if (!(o instanceof DataObject)) {
            return false;
        }
        object = (DataObject)o;
        if (!uo.getClass().equals(object.getClass())) {
            return false;
        }
        return uo.getId() == object.getId();
    }

    String getRefObjectPath() {
        return this.getRefObjectName();
    }

    String getRefObjectName() {
        if (this.refObject instanceof ImageData) {
            return ((ImageData)this.refObject).getName();
        }
        if (this.refObject instanceof DatasetData) {
            return ((DatasetData)this.refObject).getName();
        }
        if (this.refObject instanceof ProjectData) {
            return ((ProjectData)this.refObject).getName();
        }
        if (this.refObject instanceof PlateData) {
            return ((PlateData)this.refObject).getName();
        }
        if (this.refObject instanceof ScreenData) {
            return ((ScreenData)this.refObject).getName();
        }
        return "";
    }

    void fireSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata, Collection<DataObject> data) {
        DataSaver loader = new DataSaver(this.component, data, toAdd, toRemove, metadata);
        loader.load();
        this.state = 6;
    }

    void fireExperimenterSaving(ExperimenterData data) {
        ExperimenterEditor loader = new ExperimenterEditor(this.component, data);
        loader.load();
        this.state = 6;
    }

    void setStructuredDataResults(StructuredDataResults data) {
        this.data = data;
        this.state = 3;
    }

    StructuredDataResults getStructuredData() {
        return this.data;
    }

    boolean isArchived() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.isArchived();
    }

    void fireBatchSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, Collection<DataObject> toSave) {
        DataBatchSaver loader = new DataBatchSaver(this.component, toSave, toAdd, toRemove);
        loader.load();
        this.state = 5;
    }

    void setSelectionMode(boolean singleMode) {
        this.singleMode = singleMode;
    }

    boolean isSingleMode() {
        return this.singleMode;
    }

    void setRelatedNodes(Collection relateNodes) {
        this.relatedNodes = relateNodes;
    }

    Collection getRelatedNodes() {
        return this.relatedNodes;
    }

    void setState(int state) {
        this.state = state;
    }

    void loadParents(Class type, long id) {
        ContainersLoader loader = new ContainersLoader(this.component, type, id);
        loader.load();
    }
}

