/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerUI;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataViewerComponent
extends AbstractComponent
implements MetadataViewer {
    private MetadataViewerModel model;
    private MetadataViewerControl controller;
    private MetadataViewerUI view;

    private MessageBox initMessageDialog() {
        MessageBox dialog = new MessageBox(this.view, "Save Annotations", "Do you want to attach the annotations to: ");
        dialog.setNoText("Cancel");
        dialog.setYesText("OK");
        return dialog;
    }

    MetadataViewerComponent(MetadataViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MetadataViewerControl();
        this.view = new MetadataViewerUI();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        if (!(this.model.getRefObject() instanceof String)) {
            this.setSelectionMode(true);
        }
    }

    @Override
    public void activate(List channelData) {
        switch (this.model.getState()) {
            case 1: {
                this.model.getEditor().setChannelsData(channelData, false);
                this.setRootObject(this.model.getRefObject());
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public void discard() {
        this.model.discard();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void cancel(TreeBrowserDisplay refNode) {
        this.model.cancel(refNode);
    }

    @Override
    public void loadMetadata(TreeBrowserDisplay node) {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof DataObject && this.model.isSingleMode()) {
            this.model.fireStructuredDataLoading(node);
            this.fireStateChange();
        }
    }

    @Override
    public void setMetadata(TreeBrowserDisplay node, Object result) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        Object userObject = node.getUserObject();
        Object refObject = this.model.getRefObject();
        if (refObject == userObject) {
            Browser browser = this.model.getBrowser();
            if (result instanceof StructuredDataResults) {
                this.model.setStructuredDataResults((StructuredDataResults)result);
                browser.setParents(node, this.model.getStructuredData().getParents());
                this.model.getEditor().setStructuredDataResults();
                this.view.setOnScreen();
                this.fireStateChange();
                return;
            }
            if (!(userObject instanceof String)) {
                return;
            }
            String name = (String)userObject;
            if (browser == null) {
                return;
            }
            if ("Datasets".equals(name) || "Projects".equals(name)) {
                browser.setParents((TreeBrowserSet)node, (Collection)result);
            }
            this.model.notifyLoadingEnd(node);
        }
    }

    @Override
    public JComponent getSelectionUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUI();
    }

    @Override
    public JComponent getEditorUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getEditor().getUI();
    }

    @Override
    public JComponent getUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getUI();
    }

    @Override
    public void setRootObject(Object root) {
        WellSampleData ws;
        if (root == null) {
            root = "";
        }
        if (root instanceof WellSampleData && (ws = (WellSampleData)root).getId() < 0L) {
            root = null;
        }
        this.model.setRootObject(root);
        this.view.setRootObject();
    }

    @Override
    public void loadContainers(TreeBrowserDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        this.model.fireParentLoading((TreeBrowserSet)node);
    }

    @Override
    public void setContainers(TreeBrowserDisplay node, Object result) {
        Browser browser = this.model.getBrowser();
        if (node == null) {
            StructuredDataResults data = this.model.getStructuredData();
            if (data != null) {
                data.setParents((Collection)result);
                browser.setParents(null, (Collection)result);
            }
        } else {
            browser.setParents((TreeBrowserSet)node, (Collection)result);
        }
        this.model.getEditor().setStatus(false);
    }

    @Override
    public void saveData(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata, DataObject data) {
        if (data == null) {
            return;
        }
        Object refObject = this.model.getRefObject();
        ArrayList<DataObject> toSave = new ArrayList<DataObject>();
        if (refObject instanceof ExperimenterData) {
            this.model.fireExperimenterSaving((ExperimenterData)data);
            return;
        }
        Collection nodes = this.model.getRelatedNodes();
        toSave.add(data);
        if (!this.model.isSingleMode() && nodes != null) {
            Iterator n = nodes.iterator();
            while (n.hasNext()) {
                toSave.add((DataObject)n.next());
            }
        }
        if (refObject instanceof ProjectData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
        } else if (refObject instanceof ScreenData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
        } else if (refObject instanceof PlateData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
        } else if (refObject instanceof DatasetData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
        } else if (refObject instanceof ImageData) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
        } else if (refObject instanceof TagAnnotationData && toAdd.size() == 0 && toRemove.size() == 0) {
            this.model.fireSaving(toAdd, toRemove, metadata, toSave);
            return;
        }
        this.fireStateChange();
    }

    @Override
    public boolean hasDataToSave() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return false;
        }
        return editor.hasDataToSave();
    }

    @Override
    public void saveData() {
        this.firePropertyChange("saveData", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void clearDataToSave() {
        this.firePropertyChange("clearSaveData", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void onDataSave(List<DataObject> data) {
        if (data == null) {
            return;
        }
        if (this.model.getState() == 4) {
            return;
        }
        DataObject dataObject = null;
        if (data.size() == 1) {
            dataObject = data.get(0);
        }
        if (dataObject != null && this.model.isSameObject(dataObject)) {
            this.setRootObject(this.model.getRefObject());
            this.firePropertyChange("onDataSave", null, dataObject);
        } else {
            this.firePropertyChange("onDataSave", null, data);
        }
        this.model.setState(3);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.fireStateChange();
    }

    @Override
    public void setSelectionMode(boolean single) {
        this.model.setSelectionMode(single);
        this.model.getEditor().setSelectionMode(single);
    }

    @Override
    public boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    @Override
    public void setRelatedNodes(Collection nodes) {
        this.model.setRelatedNodes(nodes);
    }

    @Override
    public void onExperimenterUpdated(ExperimenterData data) {
        this.firePropertyChange("experimenterUpdated", null, data);
        this.setRootObject(data);
    }

    @Override
    public void loadParents() {
        StructuredDataResults data = this.model.getStructuredData();
        if (data == null) {
            return;
        }
        if (data.getParents() != null) {
            return;
        }
        Object ho = data.getRelatedObject();
        if (ho != null && ho instanceof DataObject) {
            this.model.loadParents(ho.getClass(), ((DataObject)ho).getId());
            this.setStatus(true);
            this.firePropertyChange("loadingParents", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public StructuredDataResults getStructuredData() {
        return this.model.getStructuredData();
    }

    @Override
    public void setStatus(boolean busy) {
        this.model.getEditor().setStatus(busy);
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.getEditor().loadExistingTags();
    }

    @Override
    public String getObjectPath() {
        return this.model.getRefObjectPath();
    }
}

