/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.ThumbnailCanvas;
import org.openmicroscopy.shoola.env.data.util.ViewedByDef;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ImageData;
import pojos.RatingAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewedByUI
extends AnnotationUI
implements ActionListener {
    private static final String TITLE = "Viewed by ";
    private static final Dimension SCROLL_SIZE = new Dimension(100, 150);
    private static final int LIST_VIEW = 0;
    private static final int GRID_VIEW = 1;
    private JToolBar displayBar;
    private JToggleButton listView;
    private JToggleButton gridView;
    private int layoutIndex;
    private JPanel gridPane;
    private JPanel listPane;
    private boolean expanded;

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.layoutIndex = 0;
        IconManager icons = IconManager.getInstance();
        this.listView = new JToggleButton(icons.getIcon(16));
        this.listView.setToolTipText("View as List.");
        this.listView.setActionCommand("0");
        this.listView.addActionListener(this);
        this.gridView = new JToggleButton(icons.getIcon(17));
        this.gridView.setToolTipText("View as Gid");
        this.gridView.setActionCommand("1");
        this.gridView.addActionListener(this);
        this.listView.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.listView);
        group.add(this.gridView);
        this.displayBar = new JToolBar();
        this.displayBar.setBorder(null);
        this.displayBar.setFloatable(false);
        this.displayBar.add(UIUtilities.setTextFont("Display: "));
        this.displayBar.add(Box.createHorizontalStrut(5));
        this.displayBar.add(this.listView);
        this.displayBar.add(this.gridView);
        this.expanded = false;
    }

    private JPanel buildListItem(BufferedImage img, long id) {
        JPanel p = new JPanel();
        ViewedByDef def = this.model.getViewedDef(id);
        p.add(new ThumbnailCanvas(this.model, img, def));
        String name = this.model.formatOwner((DataObject)def.getExperimenter());
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.add(new JLabel(name));
        p.add(content);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildGridItem(BufferedImage img, long id) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        ViewedByDef def = this.model.getViewedDef(id);
        p.add((Component)new ThumbnailCanvas(this.model, img, def), c);
        ++c.gridy;
        String name = this.model.formatOwner((DataObject)def.getExperimenter());
        Collection ratings = def.getRatings();
        int value = 0;
        if (ratings != null && ratings.size() != 0) {
            Iterator i = ratings.iterator();
            while (i.hasNext()) {
                value = ((RatingAnnotationData)i.next()).getRating();
            }
        }
        RatingComponent rate = new RatingComponent(value, 1, false);
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints cg = new GridBagConstraints();
        cg.gridx = 0;
        cg.gridy = 0;
        int width = img.getWidth();
        int w = content.getFontMetrics(content.getFont()).charWidth('m');
        if (name.length() * w > width) {
            String[] values = name.split(" ");
            for (int i = 0; i < values.length; ++i) {
                ++cg.gridy;
                content.add((Component)new JLabel(values[i]), cg);
            }
        } else {
            content.add((Component)new JLabel(name), cg);
        }
        ++cg.gridy;
        content.add((Component)rate, cg);
        p.add((Component)content, c);
        return UIUtilities.buildComponentPanel(p);
    }

    private JPanel layoutList() {
        this.listPane = new JPanel();
        this.listPane.setLayout(new BoxLayout(this.listPane, 1));
        Map<Long, BufferedImage> thumbnails = this.model.getThumbnails();
        Set<Map.Entry<Long, BufferedImage>> set = thumbnails.entrySet();
        for (Map.Entry<Long, BufferedImage> entry : set) {
            this.listPane.add(this.buildListItem(entry.getValue(), entry.getKey()));
        }
        return UIUtilities.buildComponentPanel(this.listPane);
    }

    private JPanel layoutGrid() {
        this.gridPane = new JPanel();
        this.gridPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Map<Long, BufferedImage> thumbnails = this.model.getThumbnails();
        ArrayList<JPanel> thumbs = new ArrayList<JPanel>(thumbnails.size());
        Set<Map.Entry<Long, BufferedImage>> set = thumbnails.entrySet();
        for (Map.Entry<Long, BufferedImage> entry : set) {
            thumbs.add(this.buildGridItem(entry.getValue(), entry.getKey()));
        }
        int n = thumbs.size() / 3 + 1;
        Iterator<Map.Entry<Long, BufferedImage>> it = thumbs.iterator();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.fill = 2;
        for (int i = 0; i < 3; ++i) {
            c.gridx = 0;
            for (int j = 0; j < n && it.hasNext(); ++j) {
                JPanel comp = (JPanel)((Object)it.next());
                c.gridx += j;
                c.gridy += i;
                this.gridPane.add((Component)comp, c);
            }
        }
        return UIUtilities.buildComponentPanel(this.gridPane);
    }

    private JPanel buildLoadingPane() {
        JPanel p = new JPanel();
        JXBusyLabel label = new JXBusyLabel();
        label.setEnabled(true);
        label.setBusy(true);
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Loading..."));
        p.add(UIUtilities.buildComponentPanelRight((JComponent)label));
        return p;
    }

    private JPanel buildEmptyPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("No views available."));
        return p;
    }

    ViewedByUI(EditorModel model) {
        super(model);
        this.title = TITLE;
        this.initComponents();
    }

    void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    @Override
    protected void buildUI() {
        this.title = "Viewed by [" + this.model.getViewedByCount() + "]";
        this.removeAll();
        if (this.model.getRefObject() instanceof ImageData) {
            if (this.model.isThumbnailsLoaded()) {
                if (this.model.getThumbnails().size() == 0) {
                    this.add((Component)this.buildEmptyPane(), Float.valueOf(0.5f));
                } else {
                    switch (this.layoutIndex) {
                        case 0: {
                            JScrollPane pane = new JScrollPane(this.layoutList());
                            pane.setPreferredSize(SCROLL_SIZE);
                            this.add((Component)pane, Float.valueOf(0.5f));
                            break;
                        }
                        case 1: {
                            JScrollPane pane = new JScrollPane(this.layoutGrid());
                            pane.setPreferredSize(SCROLL_SIZE);
                            this.add((Component)pane, Float.valueOf(0.5f));
                        }
                    }
                }
            } else if (this.expanded) {
                this.add((Component)this.buildLoadingPane(), Float.valueOf(0.5f));
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected String getComponentTitle() {
        return this.title;
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return null;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return null;
    }

    @Override
    protected boolean hasDataToSave() {
        return false;
    }

    @Override
    protected void clearDisplay() {
        this.removeAll();
        this.revalidate();
    }

    @Override
    protected void clearData() {
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            default: {
                this.layoutIndex = 0;
                break;
            }
            case 1: {
                this.layoutIndex = 1;
            }
        }
        this.buildUI();
    }
}

