/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.ui.RollOverThumbnailManager;
import org.openmicroscopy.shoola.env.data.util.ViewedByDef;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ViewedByComponent
extends JPanel {
    private ViewedByDef def;
    private BufferedImage thumbnail;
    private EditorModel model;
    private JLabel nameLabel;

    private void rollOver() {
        if (this.thumbnail == null) {
            return;
        }
        RollOverThumbnailManager.rollOverDisplay(this.thumbnail, this.nameLabel.getBounds(), this.nameLabel.getLocationOnScreen(), "");
    }

    private void initialise() {
        this.setBorder(null);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.nameLabel = new JLabel();
        this.nameLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.nameLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.nameLabel.setToolTipText("Click on name to launch a Viewer.");
        this.nameLabel.setText(this.def.toString());
        this.nameLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ViewedByComponent.this.model.viewImage(ViewedByComponent.this.def);
            }

            public void mouseExited(MouseEvent e) {
                RollOverThumbnailManager.stopOverDisplay();
            }

            public void mouseEntered(MouseEvent e) {
                ViewedByComponent.this.rollOver();
            }
        });
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.nameLabel);
    }

    ViewedByComponent(ViewedByDef def, EditorModel model) {
        if (def == null) {
            throw new IllegalArgumentException("No definition object.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        this.model = model;
        this.def = def;
        this.initialise();
    }

    void setThumbnail(BufferedImage thumbnail) {
        this.thumbnail = thumbnail;
    }
}

