/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import layout.TableLayout;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.UserDiskSpace;
import org.openmicroscopy.shoola.agents.metadata.editor.UserProfile;
import pojos.AnnotationData;
import pojos.ExperimenterData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserUI
extends AnnotationUI
implements PropertyChangeListener {
    static final String TITLE = "Disk Space";
    private UserProfile profile;
    private UserDiskSpace diskSpace;
    private JXTaskPane diskTask;
    private List space;

    private void initComponents(EditorControl control) {
        this.profile = new UserProfile(this.model);
        this.profile.addPropertyChangeListener(control);
        this.diskSpace = new UserDiskSpace(this);
        this.diskTask = new JXTaskPane();
        this.diskTask.add((Component)this.diskSpace, null, 0);
        this.diskTask.setTitle(TITLE);
        this.diskTask.setCollapsed(true);
        this.diskTask.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
        double[][] size = new double[][]{{-1.0}, {-2.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.profile, "0, 0");
        this.add((Component)this.diskTask, "0, 1");
    }

    UserUI(EditorModel model, EditorControl control) {
        super(model);
        if (control == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.initComponents(control);
    }

    void passwordChanged() {
        this.profile.passwordChanged();
    }

    ExperimenterData getExperimenterToSave() {
        return this.profile.getExperimenterToSave();
    }

    void setDiskSpace(List space) {
        this.space = space;
    }

    List isDiskSpaceLoaded() {
        return this.space;
    }

    @Override
    protected void buildUI() {
        this.profile.buildGUI();
        this.diskSpace.buildGUI();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearData() {
        this.space = null;
        this.clearDisplay();
    }

    @Override
    protected void clearDisplay() {
        this.diskSpace.removeAll();
        this.profile.removeAll();
        this.diskTask.setCollapsed(true);
        this.removeAll();
        this.diskSpace.revalidate();
        this.profile.revalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return new ArrayList<AnnotationData>();
    }

    @Override
    protected String getComponentTitle() {
        return "";
    }

    @Override
    protected boolean hasDataToSave() {
        return this.profile.hasDataToSave();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(this.model.getRefObject() instanceof ExperimenterData)) {
            return;
        }
        if (this.diskTask.isCollapsed()) {
            this.model.cancelDiskSpaceLoading();
        } else {
            this.model.loadDiskSpace();
        }
    }
}

