/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.GroupsRenderer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ExperimenterData;
import pojos.GroupData;

class UserProfile
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String PASSWORD_OLD = "Old password";
    private static final String PASSWORD_NEW = "New password";
    private static final String PASSWORD_CONFIRMATION = "Confirm password";
    private static final String PASSWORD_CHANGE_TITLE = "Change Password";
    private Map<String, JTextField> items;
    private JComboBox groups;
    private JPasswordField passwordNew;
    private JPasswordField passwordConfirm;
    private JPasswordField oldPassword;
    private JButton passwordButton;
    private EditorModel model;
    private int originalIndex;
    private int selectedIndex;
    private Map details;
    private GroupData[] groupData;

    private void changePassword() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.passwordNew.getPassword());
        String newPass = buf.toString();
        String pass = buf.toString();
        buf = new StringBuffer();
        buf.append(this.passwordConfirm.getPassword());
        String confirm = buf.toString();
        buf = new StringBuffer();
        buf.append(this.oldPassword.getPassword());
        String old = buf.toString();
        if (old == null || old.trim().length() == 0) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please specify your old password.");
            this.oldPassword.requestFocus();
            return;
        }
        if (newPass == null || newPass.length() == 0) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter your new password.");
            this.passwordNew.requestFocus();
            return;
        }
        if (pass == null || confirm == null || confirm.length() == 0 || !pass.equals(confirm)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "The passwords entered do not match. Please try again.");
            this.passwordNew.setText("");
            this.passwordConfirm.setText("");
            this.passwordNew.requestFocus();
            return;
        }
        this.model.changePassword(old, confirm);
    }

    private void initComponents() {
        GroupData g;
        boolean isOwner = this.model.isCurrentUserOwner(this.model.getRefObject());
        this.passwordButton = new JButton("Change password");
        this.passwordButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserProfile.this.changePassword();
            }
        });
        this.passwordNew = new JPasswordField();
        this.passwordNew.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordConfirm = new JPasswordField();
        this.passwordConfirm.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.oldPassword = new JPasswordField();
        this.oldPassword.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.items = new HashMap<String, JTextField>();
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        List userGroups = user.getGroups();
        GroupData defaultGroup = user.getDefaultGroup();
        long groupID = defaultGroup.getId();
        Iterator i = userGroups.iterator();
        ArrayList<GroupData> validGroups = new ArrayList<GroupData>();
        while (i.hasNext()) {
            g = (GroupData)i.next();
            if (!this.model.isValidGroup(g)) continue;
            validGroups.add(g);
        }
        this.groupData = new GroupData[validGroups.size()];
        int selectedIndex = 0;
        int index = 0;
        i = validGroups.iterator();
        while (i.hasNext()) {
            this.groupData[index] = g = (GroupData)i.next();
            if (g.getId() == groupID) {
                this.originalIndex = index;
            }
            ++index;
        }
        selectedIndex = this.originalIndex;
        this.groups = EditorUtil.createComboBox(this.groupData, 0);
        this.groups.setRenderer(new GroupsRenderer());
        if (this.groupData.length != 0) {
            this.groups.setSelectedIndex(selectedIndex);
        }
        if (isOwner) {
            this.groups.addActionListener(this);
            this.groups.setEnabled(true);
        } else {
            this.groups.setEnabled(false);
        }
    }

    private JPanel buildContentPanel() {
        JLabel label;
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        boolean editable = this.model.isCurrentUserOwner(user);
        this.details = EditorUtil.convertExperimenter(user);
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createTitledBorder("Profile"));
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator i = this.details.entrySet().iterator();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            label = key.equals("Last Name") || key.equals("E-mail") ? UIUtilities.setTextFont(key + " *") : UIUtilities.setTextFont(key);
            JTextField area = new JTextField(value);
            area.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (editable) {
                area.setEditable(editable);
                area.getDocument().addDocumentListener(this);
            }
            this.items.put(key, area);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            label.setLabelFor(area);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        c.gridx = 0;
        ++c.gridy;
        label = UIUtilities.setTextFont("Main Group");
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.groups, c);
        c.gridx = 0;
        ++c.gridy;
        content.add(Box.createHorizontalStrut(10), c);
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private JPanel buildPasswordPanel() {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        Registry reg = MetadataViewerAgent.getRegistry();
        String ldap = (String)reg.lookup("/user/authentication");
        if (ldap != null && ldap.length() > 0) {
            content.setBorder(BorderFactory.createTitledBorder("LDAP Authentication"));
            content.setLayout(new FlowLayout(0));
            content.add(new JLabel(ldap));
            return content;
        }
        content.setBorder(BorderFactory.createTitledBorder(PASSWORD_CHANGE_TITLE));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)UIUtilities.setTextFont(PASSWORD_OLD), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.oldPassword, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)UIUtilities.setTextFont(PASSWORD_NEW), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.passwordNew, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)UIUtilities.setTextFont(PASSWORD_CONFIRMATION), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.passwordConfirm, c);
        ++c.gridy;
        c.gridx = 0;
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        p.add(content);
        JPanel buttonPanel = UIUtilities.buildComponentPanel(this.passwordButton);
        buttonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(buttonPanel);
        return p;
    }

    private void showRequiredField() {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Edit Profile", "The required fields cannot be left blank.");
    }

    UserProfile(EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    void buildGUI() {
        this.removeAll();
        this.initComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        this.add((Component)this.buildContentPanel(), c);
        if (this.model.isCurrentUserOwner(this.model.getRefObject())) {
            ++c.gridy;
            this.add(Box.createVerticalStrut(5), c);
            ++c.gridy;
            this.add((Component)this.buildPasswordPanel(), c);
        }
    }

    void passwordChanged() {
        this.oldPassword.setText("");
        this.passwordNew.setText("");
        this.passwordConfirm.setText("");
    }

    boolean hasDataToSave() {
        if (this.selectedIndex != this.originalIndex) {
            return true;
        }
        if (this.details == null) {
            return false;
        }
        for (Map.Entry entry : this.details.entrySet()) {
            String key = (String)entry.getKey();
            JTextField field = this.items.get(key);
            String v = field.getText();
            if (v == null) continue;
            v = v.trim();
            String value = (String)entry.getValue();
            if (value == null || v.equals(value)) continue;
            return true;
        }
        return false;
    }

    ExperimenterData getExperimenterToSave() {
        ExperimenterData original = (ExperimenterData)this.model.getRefObject();
        JTextField f = this.items.get("Last Name");
        String v = f.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        original.setLastName(v);
        f = this.items.get("E-mail");
        v = f.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        original.setEmail(v);
        f = this.items.get("Institution");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setInstitution(v.trim());
        f = this.items.get("First Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setFirstName(v.trim());
        if (this.selectedIndex != this.originalIndex) {
            GroupData g = this.groupData[this.selectedIndex];
            ExperimenterData user = (ExperimenterData)this.model.getRefObject();
            List userGroups = user.getGroups();
            ArrayList<GroupData> newGroups = new ArrayList<GroupData>();
            newGroups.add(g);
            for (GroupData group : userGroups) {
                if (group.getId() == g.getId()) continue;
                newGroups.add(group);
            }
            original.setGroups(newGroups);
        }
        return original;
    }

    public void actionPerformed(ActionEvent e) {
        this.selectedIndex = this.groups.getSelectedIndex();
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

