/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXBusyLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.openmicroscopy.shoola.agents.metadata.editor.UserUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserDiskSpace
extends JPanel {
    private UserUI view;

    UserDiskSpace(UserUI view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 200));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    void buildGUI() {
        this.removeAll();
        List list = this.view.isDiskSpaceLoaded();
        if (list != null) {
            DefaultPieDataset dataset = new DefaultPieDataset();
            long free = (Long)list.get(0);
            long used = (Long)list.get(1);
            dataset.setValue((Comparable)((Object)("Free " + UIUtilities.formatFileSize(free))), (double)free);
            dataset.setValue((Comparable)((Object)("Used " + UIUtilities.formatFileSize(used))), (double)used);
            JFreeChart freeChart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
            this.add((Component)new ChartPanel(freeChart), "Center");
        } else {
            JXBusyLabel busyLabel = new JXBusyLabel();
            busyLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
            busyLabel.setEnabled(true);
            busyLabel.setBusy(true);
            JPanel p = UIUtilities.buildComponentPanelCenter((JComponent)busyLabel);
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.add((Component)p, "Center");
        }
        this.revalidate();
        this.repaint();
    }
}

