/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;

class ToolBar
extends JPanel {
    private JButton saveButton;
    private JButton downloadButton;
    private JXBusyLabel busyLabel;
    private JComponent imageBar;
    private EditorControl controller;
    private EditorModel model;

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        IconManager icons = IconManager.getInstance();
        int h = 16;
        int w = 16;
        Icon icon = icons.getIcon(37);
        if (icon != null) {
            if (icon.getIconHeight() > h) {
                h = icon.getIconHeight();
            }
            if (icon.getIconWidth() > w) {
                w = icon.getIconWidth();
            }
        }
        this.saveButton = new JButton(icon);
        this.saveButton.setToolTipText("Save changes back to the server.");
        this.saveButton.addActionListener(this.controller);
        this.saveButton.setActionCommand("3");
        this.saveButton.setEnabled(false);
        icon = icons.getIcon(18);
        if (icon != null) {
            if (icon.getIconHeight() > h) {
                h = icon.getIconHeight();
            }
            if (icon.getIconWidth() > w) {
                w = icon.getIconWidth();
            }
        }
        this.downloadButton = new JButton(icon);
        this.downloadButton.setToolTipText("Download the Archived File(s).");
        this.downloadButton.addActionListener(this.controller);
        this.downloadButton.setActionCommand("4");
        this.downloadButton.setEnabled(false);
        UIUtilities.unifiedButtonLookAndFeel(this.saveButton);
        UIUtilities.unifiedButtonLookAndFeel(this.downloadButton);
        this.busyLabel = new JXBusyLabel(new Dimension(w, h));
        this.busyLabel.setEnabled(true);
        this.busyLabel.setVisible(false);
    }

    private JComponent buildImageToolBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.downloadButton);
        return bar;
    }

    private JComponent buildGeneralBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.saveButton);
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.buildGeneralBar());
        bars.add(Box.createHorizontalStrut(2));
        this.imageBar = this.buildImageToolBar();
        this.imageBar.setVisible(false);
        bars.add(this.imageBar);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.buildComponentPanel(bars));
        p.add(UIUtilities.buildComponentPanelRight((JComponent)this.busyLabel));
        this.setLayout(new BoxLayout(this, 1));
        this.add(p);
    }

    ToolBar(EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setControls() {
        this.downloadButton.setEnabled(this.model.isArchived());
    }

    void setDataToSave(boolean b) {
        this.saveButton.setEnabled(b);
    }

    void setStatus(boolean busy) {
        this.busyLabel.setBusy(busy);
        this.busyLabel.setVisible(busy);
    }

    void buildUI() {
        if (this.model.getRefObject() instanceof ImageData) {
            this.imageBar.setVisible(!this.model.isMultiSelection());
        } else {
            this.imageBar.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }
}

