/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.env.data.util.ViewedByDef;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ImageData;

class ThumbnailCanvas
extends JPanel {
    private BufferedImage image;
    private ViewedByDef def;
    private EditorModel model;

    private void viewImage() {
        ViewImage evt;
        ImageData img;
        if (this.def == null) {
            img = (ImageData)this.model.getRefObject();
            evt = new ViewImage(img, null);
        } else {
            img = (ImageData)this.model.getRefObject();
            evt = new ViewImage(img, null);
            evt.setSettings(this.def.getRndSettings(), this.def.getExperimenter().getId());
        }
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    ThumbnailCanvas(EditorModel model, BufferedImage image) {
        this(model, image, null);
    }

    ThumbnailCanvas(EditorModel model, BufferedImage image, ViewedByDef def) {
        if (model == null) {
            throw new IllegalArgumentException("No viewing details.");
        }
        if (image == null) {
            throw new IllegalArgumentException("No image. ");
        }
        this.image = image;
        this.def = def;
        this.model = model;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ThumbnailCanvas.this.viewImage();
                }
            }
        });
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        ((Graphics2D)g).drawImage(this.image, null, 0, 0);
    }
}

