/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.SeparatorOneLineBorder;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import pojos.AnnotationData;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextualAnnotationsUI
extends AnnotationUI
implements ActionListener,
DocumentListener,
FocusListener {
    private static final String DEFAULT_TEXT_COMMENT = "Comments";
    private static final String TITLE = "Comments ";
    private static final int HIDE = 2;
    private static final int MORE = 3;
    private EditorControl controller;
    private OMEWikiComponent commentArea;
    private JPanel moreComponent;
    private JPanel hideComponent;
    private String originalText;
    private JScrollPane previousComments;

    private JComponent buildPreviousCommentsPane() {
        if (this.previousComments != null) {
            return this.previousComments;
        }
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        List list = this.model.getTextualAnnotationsByDate();
        long userID = MetadataViewerAgent.getUserDetails().getId();
        if (list != null) {
            Iterator i = list.iterator();
            int index = 0;
            while (i.hasNext()) {
                TextualAnnotationData data = (TextualAnnotationData)i.next();
                if (data.getOwner().getId() == userID) continue;
                TextualAnnotationComponent comp = new TextualAnnotationComponent(this.model, data);
                if (index % 2 == 0) {
                    comp.setAreaColor(UIUtilities.BACKGROUND_COLOUR_EVEN);
                } else {
                    comp.setAreaColor(UIUtilities.BACKGROUND_COLOUR_ODD);
                }
                p.add(comp);
                ++index;
            }
        }
        this.previousComments = new JScrollPane(p);
        this.previousComments.setBorder(null);
        return this.previousComments;
    }

    private boolean hasPreviousTextualAnnotations() {
        Map<Long, List> m = this.model.getTextualAnnotationByOwner();
        long userID = MetadataViewerAgent.getUserDetails().getId();
        int n = m.size();
        if (n == 0) {
            return false;
        }
        if (n == 1 && m.containsKey(userID)) {
            return false;
        }
        return n >= 1;
    }

    private void initComponents() {
        JButton moreButton = new JButton("...more");
        moreButton.setBorder(null);
        UIUtilities.unifiedButtonLookAndFeel(moreButton);
        moreButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        moreButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        moreButton.setToolTipText("Display previous comments.");
        moreButton.addActionListener(this);
        moreButton.setActionCommand("3");
        this.moreComponent = UIUtilities.buildComponentPanel(moreButton, 0, 0);
        this.moreComponent.setBackground(UIUtilities.BACKGROUND_COLOR);
        JButton hideButton = new JButton("hide");
        UIUtilities.unifiedButtonLookAndFeel(hideButton);
        hideButton.setBorder(null);
        hideButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        hideButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        hideButton.setToolTipText("Hide previous comments.");
        hideButton.addActionListener(this);
        hideButton.setActionCommand("2");
        this.hideComponent = UIUtilities.buildComponentPanel(hideButton, 0, 0);
        this.hideComponent.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.commentArea = new OMEWikiComponent();
        this.commentArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.commentArea.addPropertyChangeListener(this.controller);
        this.originalText = DEFAULT_TEXT_COMMENT;
        this.commentArea.setDefaultText(this.originalText);
        this.commentArea.setText(this.originalText);
        this.commentArea.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.commentArea.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.commentArea.setComponentBorder(EDIT_BORDER);
    }

    private void layoutPreviousComments() {
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setRow(2, -2.0);
        layout.setRow(3, -2.0);
        this.remove(this.moreComponent);
        this.add((Component)this.hideComponent, "0, 2");
        this.add((Component)this.buildPreviousCommentsPane(), "0, 3");
        this.revalidate();
        this.repaint();
    }

    private void setAreaText(String text, boolean addDefault) {
        this.commentArea.removeDocumentListener(this);
        this.commentArea.setText(text);
        if (addDefault) {
            this.commentArea.setDefaultText(text);
        }
        this.commentArea.addDocumentListener(this);
    }

    private void buildGUI() {
        this.setBorder(new SeparatorOneLineBorder());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-1.0}, {-2.0, 150.0, 0.0, 0.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        JScrollPane pane = new JScrollPane(this.commentArea);
        pane.setBorder(null);
        JLabel l = new JLabel();
        Font f = l.getFont();
        l = UIUtilities.setTextFont("comment", 1, f.getSize() - 1);
        l.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.add((Component)l, "0, 0");
        this.add((Component)pane, "0, 1");
    }

    private void hidePreviousComments() {
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setRow(2, -2.0);
        layout.setRow(3, 0.0);
        this.remove(this.hideComponent);
        this.add((Component)this.moreComponent, "0, 2");
        this.revalidate();
        this.repaint();
    }

    TextualAnnotationsUI(EditorModel model, EditorControl controller) {
        super(model);
        this.controller = controller;
        this.title = TITLE;
        this.initComponents();
        this.buildGUI();
    }

    @Override
    protected void buildUI() {
        TextualAnnotationData data = this.model.getLastUserAnnotation();
        if (data != null) {
            boolean b = false;
            String text = data.getText();
            if (text == null || text.trim().length() == 0) {
                text = DEFAULT_TEXT_COMMENT;
                b = true;
            }
            this.originalText = text = text.trim();
            this.setAreaText(text, b);
        }
        TableLayout layout = (TableLayout)this.getLayout();
        layout.setRow(2, 0.0);
        layout.setRow(3, 0.0);
        if (this.hasPreviousTextualAnnotations()) {
            layout.setRow(2, -2.0);
            this.add((Component)this.moreComponent, "0, 2");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected String getComponentTitle() {
        return this.title;
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        TextualAnnotationData data;
        String text;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (this.originalText != null && this.originalText.length() > 0 && (text = this.commentArea.getText()) != null && (text = text.trim()).length() == 0 && (data = this.model.getLastUserAnnotation()) != null) {
            l.add((AnnotationData)data);
        }
        return l;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        String text = this.commentArea.getText();
        if (text == null) {
            return l;
        }
        if ((text = text.trim()).length() == 0) {
            return l;
        }
        if (text.equals(this.originalText) || text.equals(DEFAULT_TEXT_COMMENT)) {
            return l;
        }
        l.add((AnnotationData)new TextualAnnotationData(text));
        return l;
    }

    @Override
    protected boolean hasDataToSave() {
        String text = this.commentArea.getText();
        if (text == null) {
            return false;
        }
        if ((text = text.trim()).length() == 0 && this.originalText != null) {
            return true;
        }
        return !this.originalText.equals(text) && !text.equals(DEFAULT_TEXT_COMMENT);
    }

    @Override
    protected void clearDisplay() {
        this.originalText = DEFAULT_TEXT_COMMENT;
        this.setAreaText(DEFAULT_TEXT_COMMENT, true);
    }

    @Override
    protected void clearData() {
        this.clearDisplay();
    }

    @Override
    protected void setComponentTitle() {
        this.title = TITLE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 3: {
                this.layoutPreviousComments();
                break;
            }
            case 2: {
                this.hidePreviousComments();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.commentArea) {
            String text = this.commentArea.getText();
            boolean b = false;
            if (text == null || text.length() == 0) {
                text = DEFAULT_TEXT_COMMENT;
                b = true;
            }
            this.originalText = text = text.trim();
            this.setAreaText(DEFAULT_TEXT_COMMENT, b);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }
}

