/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import pojos.DataObject;
import pojos.TextualAnnotationData;

class TextualAnnotationComponent
extends JPanel {
    private MultilineLabel area;
    private TextualAnnotationData data;
    private EditorModel model;

    private void initialize() {
        this.area = new MultilineLabel();
        this.area.setEditable(false);
        this.area.setOpaque(true);
        this.area.setText(this.data.getText());
        String owner = this.model.formatOwner((DataObject)this.data);
        String date = this.model.formatDate((DataObject)this.data);
        TitledLineBorder border = new TitledLineBorder(owner + " " + date);
        border.setTitleFont(this.area.getFont().deriveFont(1));
        this.area.setBorder(border);
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.area);
    }

    TextualAnnotationComponent(EditorModel model, TextualAnnotationData data) {
        this.data = data;
        this.model = model;
        this.initialize();
        this.buildGUI();
    }

    void setAreaColor(Color color) {
        this.area.setOriginalBackground(color);
        this.setBackground(color);
        ((TitledLineBorder)this.area.getBorder()).setLineColor(color);
    }
}

