/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertiesUI
extends AnnotationUI
implements ActionListener,
DocumentListener,
FocusListener {
    static final String TITLE = "Properties";
    private static final String DEFAULT_DESCRIPTION_TEXT = "Description";
    private static final String ID_TEXT = "ID: ";
    private static final int EDIT_NAME = 0;
    private static final int EDIT_DESC = 1;
    private JButton editName;
    private JButton editDescription;
    private String originalName;
    private String originalDisplayedName;
    private String originalDescription;
    private JTextArea namePane;
    private JTextArea descriptionPane;
    private JPanel namePanel;
    private JPanel descriptionPanel;
    private JLabel idLabel;
    private JRadioButton publicBox;
    private JRadioButton privateBox;
    private JLabel channelsArea;
    private String modifiedName;
    private Border defaultBorder;
    private EditorControl controller;

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publicBox = new JRadioButton("public");
        this.publicBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publicBox.setToolTipText("Visible to Group members only.");
        this.publicBox.setEnabled(false);
        Font f = this.publicBox.getFont();
        this.privateBox = new JRadioButton("private");
        this.privateBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.publicBox.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        this.privateBox.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        this.privateBox.setSelected(true);
        this.privateBox.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.privateBox);
        group.add(this.publicBox);
        this.idLabel = UIUtilities.setTextFont("");
        this.namePane = this.createTextPane();
        this.namePane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PropertiesUI.this.editField(PropertiesUI.this.namePanel, PropertiesUI.this.namePane, true);
                }
            }
        });
        this.namePane.setEditable(false);
        this.namePane.addFocusListener(this);
        this.descriptionPane = this.createTextPane();
        this.descriptionPane.setLineWrap(true);
        this.descriptionPane.setColumns(20);
        this.descriptionPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PropertiesUI.this.editField(PropertiesUI.this.descriptionPanel, PropertiesUI.this.descriptionPane, true);
                }
            }
        });
        this.descriptionPane.addPropertyChangeListener(this.controller);
        this.descriptionPane.setText("None");
        this.descriptionPane.addFocusListener(this);
        this.defaultBorder = this.namePane.getBorder();
        f = this.namePane.getFont();
        this.namePane.setFont(f.deriveFont(1));
        f = this.descriptionPane.getFont();
        this.descriptionPane.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        this.descriptionPane.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.channelsArea = UIUtilities.createComponent(null);
        IconManager icons = IconManager.getInstance();
        this.editName = new JButton(icons.getIcon(54));
        this.editName.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.editName);
        this.editName.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.editName.setToolTipText("Edit the name.");
        this.editName.addActionListener(this);
        this.editName.setActionCommand("0");
        this.editDescription = new JButton(icons.getIcon(54));
        this.editDescription.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.editDescription);
        this.editDescription.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.editDescription.setToolTipText("Edit the description.");
        this.editDescription.addActionListener(this);
        this.editDescription.setActionCommand("1");
    }

    private JPanel buildContentPanel(Map details, ImageData image) {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        double[] columns = new double[]{-2.0, 2.0, -1.0};
        TableLayout layout = new TableLayout();
        content.setLayout((LayoutManager)layout);
        layout.setColumn(columns);
        int index = 0;
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        layout.insertRow(index, -2.0);
        JLabel label = UIUtilities.setTextFont("Image Date", 1, size);
        JLabel value = UIUtilities.createComponent(null);
        String v = this.model.formatDate((DataObject)image);
        value.setText(v);
        content.add((Component)label, "0, " + index);
        content.add((Component)value, "2, " + index);
        layout.insertRow(++index, -2.0);
        label = UIUtilities.setTextFont("Dimensions (XY)", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Size X");
        v = v + " x ";
        v = v + (String)details.get("Size Y");
        value.setText(v);
        content.add((Component)label, "0, " + index);
        content.add((Component)value, "2, " + index);
        layout.insertRow(++index, -2.0);
        label = UIUtilities.setTextFont("Pixels Size (XYZ) (\u00b5m)", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Pixel size X (\u00b5m)");
        v = v + " x ";
        v = v + (String)details.get("Pixel size Y (\u00b5m)");
        v = v + " x ";
        v = v + (String)details.get("Pixel size Z (\u00b5m)");
        value.setText(v);
        content.add((Component)label, "0, " + index);
        content.add((Component)value, "2, " + index);
        layout.insertRow(++index, -2.0);
        label = UIUtilities.setTextFont("z-sections/timepoints", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Number of sections");
        v = v + " x ";
        v = v + (String)details.get("Number of timepoints");
        value.setText(v);
        content.add((Component)label, "0, " + index);
        content.add((Component)value, "2, " + index);
        layout.insertRow(++index, -2.0);
        label = UIUtilities.setTextFont("Channels", 1, size);
        content.add((Component)label, "0, " + index);
        content.add((Component)this.channelsArea, "2, " + index);
        JPanel p = UIUtilities.buildComponentPanel(content);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private JPanel buildPermissions(PermissionData permissions) {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(null);
        if (permissions != null && permissions.isGroupRead()) {
            this.publicBox.setSelected(true);
        }
        content.add(this.privateBox);
        content.add(this.publicBox);
        JPanel p = UIUtilities.buildComponentPanel(content, 0, 0);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setBorder(null);
        return p;
    }

    private JTextArea createTextPane() {
        JTextArea pane = new JTextArea();
        pane.setWrapStyleWord(true);
        pane.setOpaque(false);
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        return pane;
    }

    private JPanel layoutEditablefield(Component button, JComponent c) {
        JPanel p = new JPanel();
        double[][] size = new double[][]{{-2.0, -1.0}, {-2.0, -1.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        JToolBar bar = new JToolBar();
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(button);
        p.add((Component)bar, "0, 0, l, t");
        p.add((Component)c, "1, 0, 1, 1");
        JPanel content = UIUtilities.buildComponentPanel(p, 0, 0);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        return content;
    }

    private JPanel buildProperties() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        JPanel l = UIUtilities.buildComponentPanel(this.idLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        int w = this.editName.getIcon().getIconWidth() + 4;
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        this.namePanel = this.layoutEditablefield(this.editName, this.namePane);
        p.add(this.namePanel);
        p.add(Box.createVerticalStrut(5));
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof DatasetData || refObject instanceof ProjectData || refObject instanceof TagAnnotationData || refObject instanceof WellSampleData) {
            p.add(Box.createVerticalStrut(5));
            this.descriptionPanel = this.layoutEditablefield(this.editDescription, this.descriptionPane);
            p.add(this.descriptionPanel);
        }
        p.add(Box.createVerticalStrut(5));
        p.add(this.buildPermissions(null));
        return p;
    }

    private void buildGUI() {
        String description;
        FileAnnotationData fa;
        String ns;
        this.setBackground(UIUtilities.BACKGROUND);
        this.add(this.buildProperties());
        Object refObject = this.model.getRefObject();
        PixelsData data = null;
        ImageData img = null;
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
            try {
                data = ((ImageData)refObject).getDefaultPixels();
            }
            catch (Exception e) {}
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
            if (img != null && img.getId() > 0L) {
                data = img.getDefaultPixels();
            }
        } else if (refObject instanceof FileAnnotationData && ("openmicroscopy.org/omero/editor/experiment".equals(ns = (fa = (FileAnnotationData)refObject).getNameSpace()) || "openmicroscopy.org/omero/editor/protocol".equals(ns)) && (description = fa.getDescription()) != null && description.length() > 0) {
            PreviewPanel panel = new PreviewPanel(description, fa.getId());
            panel.addPropertyChangeListener(this.controller);
            this.add(Box.createVerticalStrut(5));
            this.add(panel);
        }
        if (data == null) {
            return;
        }
        this.add(Box.createVerticalStrut(5));
        this.add(this.buildContentPanel(EditorUtil.transformPixelsData(data), img));
    }

    private void editField(JPanel panel, JTextArea field, boolean editable) {
        field.setEditable(editable);
        if (editable) {
            panel.setBorder(EDIT_BORDER);
            field.requestFocus();
        } else {
            panel.setBorder(this.defaultBorder);
        }
        if (field == this.namePane) {
            this.namePane.getDocument().removeDocumentListener(this);
            String text = this.namePane.getText();
            if (text != null) {
                text = text.trim();
            }
            if (editable) {
                this.namePane.setText(this.modifiedName);
            } else {
                this.namePane.setText(EditorUtil.getPartialName(text));
            }
            this.namePane.getDocument().addDocumentListener(this);
        }
    }

    private void handleNameChanged(Document document) {
        Document d = this.namePane.getDocument();
        if (d == document) {
            this.modifiedName = this.namePane.getText();
        }
    }

    PropertiesUI(EditorModel model, EditorControl controller) {
        super(model);
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.title = TITLE;
        this.initComponents();
        this.buildGUI();
    }

    @Override
    protected void buildUI() {
        this.removeAll();
        if (this.model.isMultiSelection()) {
            return;
        }
        this.namePane.getDocument().removeDocumentListener(this);
        this.descriptionPane.getDocument().removeDocumentListener(this);
        this.originalName = this.model.getRefObjectName();
        this.modifiedName = this.model.getRefObjectName();
        this.originalDisplayedName = EditorUtil.getPartialName(this.originalName);
        this.namePane.setText(this.originalDisplayedName);
        this.namePane.setToolTipText(this.originalName);
        Object refObject = this.model.getRefObject();
        String text = "";
        if (refObject instanceof ImageData) {
            text = "Image ";
        } else if (refObject instanceof DatasetData) {
            text = "Dataset ";
        } else if (refObject instanceof ProjectData) {
            text = "Project ";
        } else if (refObject instanceof ScreenData) {
            text = "Screen ";
        } else if (refObject instanceof PlateData) {
            text = "Plate ";
        } else if (refObject instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)refObject;
            String ns = fa.getNameSpace();
            text = "openmicroscopy.org/omero/editor/experiment".equals(ns) ? "Experiment " : ("openmicroscopy.org/omero/editor/protocol".equals(ns) ? "Protocol " : "File ");
        } else if (refObject instanceof WellSampleData) {
            text = "Field ";
        } else if (refObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)refObject;
            text = "openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace()) ? "Tag Set " : "Tag ";
        }
        text = text + ID_TEXT + this.model.getRefObjectID();
        this.idLabel.setText(text);
        this.originalDescription = this.model.getRefObjectDescription();
        if (this.originalDescription == null || this.originalDescription.length() == 0) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionPane.setText(this.originalDescription);
        boolean b = this.model.isCurrentUserOwner(this.model.getRefObject());
        this.namePane.setEnabled(b);
        this.descriptionPane.setEnabled(b);
        if (b) {
            this.namePane.getDocument().addDocumentListener(this);
            this.descriptionPane.getDocument().addDocumentListener(this);
        }
        this.buildGUI();
    }

    void setFocusOnName() {
        this.namePane.requestFocus();
    }

    void updateDataObject() {
        if (!this.hasDataToSave()) {
            return;
        }
        Object object = this.model.getRefObject();
        String name = this.namePane.getText().trim();
        String desc = this.descriptionPane.getText().trim();
        if (object instanceof ProjectData) {
            ProjectData p = (ProjectData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof DatasetData) {
            DatasetData p = (DatasetData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof ImageData) {
            ImageData p = (ImageData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof TagAnnotationData) {
            TagAnnotationData p = (TagAnnotationData)object;
            if (name.length() > 0) {
                p.setTagValue(name);
            }
            if (desc.length() > 0) {
                p.setTagDescription(desc);
            }
        } else if (object instanceof ScreenData) {
            ScreenData p = (ScreenData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof PlateData) {
            PlateData p = (PlateData)object;
            if (name.length() > 0) {
                p.setName(name);
            }
            p.setDescription(desc);
        } else if (object instanceof WellSampleData) {
            WellSampleData well = (WellSampleData)object;
            ImageData img = well.getImage();
            if (name.length() > 0) {
                img.setName(name);
            }
            img.setDescription(desc);
        }
    }

    boolean isNameValid() {
        String name = this.namePane.getText();
        if (name == null) {
            return false;
        }
        return name.trim().length() != 0;
    }

    void setChannelData(List waves) {
        if (waves == null) {
            return;
        }
        String s = "";
        Iterator k = waves.iterator();
        int j = 0;
        while (k.hasNext()) {
            s = s + ((ChannelData)k.next()).getChannelLabeling();
            if (j != waves.size() - 1) {
                s = s + ", ";
            }
            ++j;
        }
        this.channelsArea.setText(s);
        this.channelsArea.revalidate();
        this.channelsArea.repaint();
    }

    @Override
    protected String getComponentTitle() {
        return TITLE;
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        return null;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return null;
    }

    @Override
    protected boolean hasDataToSave() {
        if (this.model.isMultiSelection()) {
            return false;
        }
        String name = this.originalName;
        String value = this.namePane.getText();
        value = value.trim();
        if (name == null) {
            return false;
        }
        if (!name.equals(value) && !this.originalDisplayedName.equals(value)) {
            return true;
        }
        name = this.originalDescription;
        value = this.descriptionPane.getText();
        value = value.trim();
        if (name == null) {
            return value.length() != 0;
        }
        return !value.equals(name = name.trim());
    }

    @Override
    protected void clearData() {
        this.originalDisplayedName = this.originalName = this.model.getRefObjectName();
        this.originalDescription = this.model.getRefObjectDescription();
        this.namePane.getDocument().removeDocumentListener(this);
        this.descriptionPane.getDocument().removeDocumentListener(this);
        this.idLabel.setText("");
        this.namePane.setText(this.originalName);
        this.descriptionPane.setText(this.originalDescription);
        this.namePane.getDocument().addDocumentListener(this);
        this.descriptionPane.getDocument().addDocumentListener(this);
        this.channelsArea.setText("");
    }

    @Override
    protected void clearDisplay() {
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleNameChanged(e.getDocument());
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleNameChanged(e.getDocument());
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.editField(this.namePanel, this.namePane, true);
                break;
            }
            case 1: {
                this.editField(this.descriptionPanel, this.descriptionPane, true);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.namePane) {
            this.editField(this.namePanel, this.namePane, false);
            String text = this.namePane.getText();
            if (text == null || text.trim().length() == 0) {
                this.namePane.getDocument().removeDocumentListener(this);
                this.namePane.setText(this.modifiedName);
                this.namePane.getDocument().addDocumentListener(this);
            }
        } else if (src == this.descriptionPane) {
            this.editField(this.descriptionPanel, this.descriptionPane, false);
            String text = this.descriptionPane.getText();
            if (text == null || text.trim().length() == 0) {
                this.descriptionPane.getDocument().removeDocumentListener(this);
                this.descriptionPane.setText(DEFAULT_DESCRIPTION_TEXT);
                this.descriptionPane.getDocument().addDocumentListener(this);
            }
            this.descriptionPane.select(0, 0);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        String text;
        Object src = e.getSource();
        if (src == this.namePane) {
            this.namePane.setCaretPosition(0);
        } else if (src == this.descriptionPane && (text = this.descriptionPane.getText()) != null) {
            if (DEFAULT_DESCRIPTION_TEXT.equals(text.trim())) {
                this.descriptionPane.selectAll();
            } else {
                int n = text.length() - 1;
                if (n >= 0) {
                    this.descriptionPane.setCaretPosition(n);
                }
            }
        }
    }
}

