/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.model.Correction;
import omero.model.Immersion;
import omero.model.Medium;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageAcquisitionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageAcquisitionComponent
extends JPanel
implements PropertyChangeListener {
    private static final int OBJECTIVE = 0;
    private static final int STAGE = 1;
    private static final int ENVIRONMENT = 2;
    private EditorModel model;
    private AcquisitionDataUI parent;
    private OMEComboBox immersionBox;
    private OMEComboBox coatingBox;
    private OMEComboBox mediumBox;
    private OMEComboBox irisBox;
    private Map<String, DataComponent> fieldsObjective;
    private Map<String, DataComponent> fieldsEnv;
    private Map<String, DataComponent> fieldsStage;
    private boolean init;
    private JLabelButton unsetObjective;
    private boolean unsetObjectiveShown;
    private JPanel objectivePane;
    private JLabelButton unsetEnv;
    private boolean unsetEnvShown;
    private JPanel envPane;
    private JLabelButton unsetStage;
    private boolean unsetStageShown;
    private JPanel stagePane;

    private void displayUnsetObjectiveFields() {
        this.unsetObjectiveShown = !this.unsetObjectiveShown;
        String s = "Show unset fields";
        if (this.unsetObjectiveShown) {
            s = "Hide unset fields";
        }
        this.unsetObjective.setText(s);
        this.parent.layoutFields(this.objectivePane, this.unsetObjective, this.fieldsObjective, this.unsetObjectiveShown);
    }

    private void displayUnsetEnvFields() {
        this.unsetEnvShown = !this.unsetEnvShown;
        String s = "Show unset fields";
        if (this.unsetEnvShown) {
            s = "Hide unset fields";
        }
        this.unsetEnv.setText(s);
        this.parent.layoutFields(this.envPane, this.unsetEnv, this.fieldsEnv, this.unsetEnvShown);
    }

    private void displayUnsetStageFields() {
        this.unsetStageShown = !this.unsetStageShown;
        String s = "Show unset fields";
        if (this.unsetStageShown) {
            s = "Hide unset fields";
        }
        this.unsetStage.setText(s);
        this.parent.layoutFields(this.stagePane, this.unsetStage, this.fieldsStage, this.unsetStageShown);
    }

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getImageEnumerations(Editor.IMMERSION);
        this.immersionBox = EditorUtil.createComboBox(l);
        l = this.model.getImageEnumerations(Editor.CORRECTION);
        this.coatingBox = EditorUtil.createComboBox(l);
        l = this.model.getImageEnumerations(Editor.MEDIUM);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.mediumBox = EditorUtil.createComboBox(array);
    }

    private void initComponents() {
        this.resetBoxes();
        Object[] values = new String[]{"Yes", "No", "Not Set"};
        this.irisBox = EditorUtil.createComboBox(values);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.fieldsObjective = new LinkedHashMap<String, DataComponent>();
        this.fieldsEnv = new LinkedHashMap<String, DataComponent>();
        this.fieldsStage = new LinkedHashMap<String, DataComponent>();
        this.unsetObjective = null;
        this.unsetObjectiveShown = false;
        this.objectivePane = new JPanel();
        this.objectivePane.setBorder(BorderFactory.createTitledBorder("Objective"));
        this.objectivePane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.objectivePane.setLayout(new GridBagLayout());
        this.unsetEnv = null;
        this.unsetEnvShown = false;
        this.envPane = new JPanel();
        this.envPane.setBorder(BorderFactory.createTitledBorder("Environment"));
        this.envPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.envPane.setLayout(new GridBagLayout());
        this.unsetStage = null;
        this.unsetStageShown = false;
        this.stagePane = new JPanel();
        this.stagePane.setBorder(BorderFactory.createTitledBorder("Position"));
        this.stagePane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.stagePane.setLayout(new GridBagLayout());
    }

    private void transformObjective(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetObjective == null) {
            this.unsetObjective = this.parent.formatUnsetFieldsControl();
            this.unsetObjective.setActionID(0);
            this.unsetObjective.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (key.equals("Immersion")) {
                selected = this.model.getImageEnumerationSelected(Editor.IMMERSION, (String)value);
                if (selected != null) {
                    this.immersionBox.setSelectedItem(selected);
                    if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                        set = false;
                    }
                }
                this.immersionBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.immersionBox;
            } else if (key.equals("Correction")) {
                selected = this.model.getImageEnumerationSelected(Editor.CORRECTION, (String)value);
                if (selected != null) {
                    this.coatingBox.setSelectedItem(selected);
                    if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                        set = false;
                    }
                }
                area = this.coatingBox;
                this.coatingBox.setEditedColor(UIUtilities.EDITED_COLOR);
            } else if (key.equals("Medium")) {
                selected = this.model.getImageEnumerationSelected(Editor.MEDIUM, (String)value);
                if (selected != null) {
                    this.mediumBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.mediumBox.setSelectedIndex(this.mediumBox.getItemCount() - 1);
                }
                area = this.mediumBox;
                this.mediumBox.setEditedColor(UIUtilities.EDITED_COLOR);
            } else if (key.equals("Iris")) {
                if (value != null) {
                    boolean b = (Boolean)value;
                    if (b) {
                        this.irisBox.setSelectedItem("Yes");
                    } else {
                        this.irisBox.setSelectedItem("No");
                    }
                } else {
                    set = false;
                    this.irisBox.setSelectedItem("Not Set");
                }
                this.irisBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.irisBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            ((JComponent)area).setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsObjective.put(key, comp);
        }
    }

    private void transformStage(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetStage == null) {
            this.unsetStage = this.parent.formatUnsetFieldsControl();
            this.unsetStage.setActionID(1);
            this.unsetStage.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (value instanceof String) {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                    set = false;
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                ((NumericalTextField)area).setNegativeAccepted(true);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsStage.put(key, comp);
        }
    }

    private void transformEnv(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetEnv == null) {
            this.unsetEnv = this.parent.formatUnsetFieldsControl();
            this.unsetEnv.setActionID(2);
            this.unsetEnv.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if ("Temperature (\u2103)".equals(key)) {
                    ((NumericalTextField)area).setMinimum(-1.7976931348623157E308);
                    ((NumericalTextField)area).setNegativeAccepted(true);
                }
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                    set = false;
                }
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsEnv.put(key, comp);
        }
    }

    private void buildGUI() {
        this.fieldsObjective.clear();
        this.fieldsEnv.clear();
        this.fieldsStage.clear();
        ImageAcquisitionData data = this.model.getImageAcquisitionData();
        this.transformObjective(EditorUtil.transformObjective(data));
        this.transformEnv(EditorUtil.transformImageEnvironment(data));
        this.transformStage(EditorUtil.transformStageLabel(data));
        this.parent.layoutFields(this.objectivePane, this.unsetObjective, this.fieldsObjective, this.unsetObjectiveShown);
        this.parent.layoutFields(this.envPane, this.unsetEnv, this.fieldsEnv, this.unsetEnvShown);
        this.parent.layoutFields(this.stagePane, this.unsetStage, this.fieldsStage, this.unsetStageShown);
        this.add(this.objectivePane);
        this.add(this.envPane);
        this.add(this.stagePane);
        this.parent.attachListener(this.fieldsObjective);
        this.parent.attachListener(this.fieldsStage);
        this.parent.attachListener(this.fieldsEnv);
    }

    ImageAcquisitionComponent(AcquisitionDataUI parent, EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.parent = parent;
        this.model = model;
        this.initComponents();
    }

    void setImageAcquisitionData() {
        if (!this.init) {
            this.init = true;
            this.resetBoxes();
            this.removeAll();
            this.buildGUI();
        }
    }

    void setRootObject() {
        this.init = false;
        this.removeAll();
    }

    boolean hasDataToSave() {
        boolean b = this.parent.hasDataToSave(this.fieldsObjective);
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsEnv);
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsStage);
        return b;
    }

    ImageAcquisitionData prepareDataToSave() {
        Number number;
        Object value;
        DataComponent comp;
        String key;
        if (!this.hasDataToSave()) {
            return null;
        }
        ImageAcquisitionData data = this.model.getImageAcquisitionData();
        for (Map.Entry<String, DataComponent> entry : this.fieldsObjective.entrySet()) {
            EnumerationObject enumObject;
            key = entry.getKey();
            comp = entry.getValue();
            if (!comp.isDirty()) continue;
            value = comp.getAreaValue();
            if ("Model".equals(key)) {
                data.setModel((String)value);
                continue;
            }
            if ("Manufacturer".equals(key)) {
                data.setManufacturer((String)value);
                continue;
            }
            if ("Serial Number".equals(key)) {
                data.setSerialNumber((String)value);
                continue;
            }
            if ("Nominal Magnification".equals(key)) {
                data.setNominalMagnification(((Integer)value).intValue());
                continue;
            }
            if ("Calibrated Magnification".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setCalibratedMagnification((double)((Float)number).floatValue());
                continue;
            }
            if ("Lens NA".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setLensNA((double)((Float)number).floatValue());
                continue;
            }
            if ("Immersion".equals(key)) {
                enumObject = (EnumerationObject)value;
                data.setImmersion((Immersion)enumObject.getObject());
                continue;
            }
            if ("Correction".equals(key)) {
                enumObject = (EnumerationObject)value;
                data.setCorrection((Correction)enumObject.getObject());
                continue;
            }
            if ("Working Distance".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setWorkingDistance((double)((Float)number).floatValue());
                continue;
            }
            if ("Medium".equals(key)) {
                enumObject = (EnumerationObject)value;
                if (!(enumObject.getObject() instanceof Medium)) continue;
                data.setMedium((Medium)enumObject.getObject());
                continue;
            }
            if ("Refractive index".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setRefractiveIndex((double)((Float)number).floatValue());
                continue;
            }
            if ("Iris".equals(key)) {
                Boolean bool = this.parent.convertToBoolean((String)value);
                if (bool == null) continue;
                data.setIris(bool.booleanValue());
                continue;
            }
            if (!"Correction Collar".equals(key) || (number = UIUtilities.extractNumber((String)value, Float.class)) == null) continue;
            data.setCorrectionCollar((double)((Float)number).floatValue());
        }
        for (Map.Entry<String, DataComponent> entry : this.fieldsEnv.entrySet()) {
            float v;
            key = entry.getKey();
            comp = entry.getValue();
            if (!comp.isDirty()) continue;
            value = comp.getAreaValue();
            if ("Temperature (\u2103)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setTemperature((double)((Float)number).floatValue());
                continue;
            }
            if ("Air Pressure (mb)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setAirPressure((double)((Float)number).floatValue());
                continue;
            }
            if ("Humidy (%)".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                v = ((Float)number).floatValue() / 100.0f;
                data.setHumidity((double)v);
                continue;
            }
            if (!"CO2 Percent (%)".equals(key) || (number = UIUtilities.extractNumber((String)value, Float.class)) == null) continue;
            v = ((Float)number).floatValue() / 100.0f;
            data.setCo2Percent((double)v);
        }
        for (Map.Entry<String, DataComponent> entry : this.fieldsStage.entrySet()) {
            key = entry.getKey();
            comp = entry.getValue();
            if (!comp.isDirty()) continue;
            value = comp.getAreaValue();
            if ("Name".equals(key)) {
                data.setLabelName((String)value);
                continue;
            }
            if ("Position X".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setPositionX((double)((Float)number).floatValue());
                continue;
            }
            if ("Position Y".equals(key)) {
                number = UIUtilities.extractNumber((String)value, Float.class);
                if (number == null) continue;
                data.setPositionY((double)((Float)number).floatValue());
                continue;
            }
            if (!"Position Z".equals(key) || (number = UIUtilities.extractNumber((String)value, Float.class)) == null) continue;
            data.setPositionZ((double)((Float)number).floatValue());
        }
        return data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            int id = (Integer)evt.getNewValue();
            switch (id) {
                case 0: {
                    this.displayUnsetObjectiveFields();
                    break;
                }
                case 1: {
                    this.displayUnsetStageFields();
                    break;
                }
                case 2: {
                    this.displayUnsetEnvFields();
                }
            }
        }
    }
}

