/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import layout.TableLayout;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.PropertiesUI;
import org.openmicroscopy.shoola.agents.metadata.editor.TextualAnnotationsUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.util.ui.ScrollablePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import pojos.AnnotationData;
import pojos.DatasetData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeneralPaneUI
extends JScrollPane {
    private EditorControl controller;
    private EditorModel model;
    private EditorUI view;
    private PropertiesUI propertiesUI;
    private TextualAnnotationsUI textualAnnotationsUI;
    private AnnotationDataUI annotationUI;
    private JXTaskPane browserTaskPane;
    private List<AnnotationUI> components;
    private JPanel content;
    private int annotationLayoutIndex;
    private int textualAnnotationsLayoutIndex;
    private int browserIndex;
    private int protocolsIndex;
    private JPanel protocolComponent;
    private List<PreviewPanel> previews;
    private Map<JXTaskPane, Integer> panes;
    private Map<Integer, Double> indexes;
    private double defaultProtocolHeight;

    private void loadParents(boolean b) {
        if (b) {
            this.controller.loadParents();
        } else {
            this.view.setStatus(false);
            this.model.cancelParentsLoading();
        }
    }

    private void initComponents() {
        if (this.model.getBrowser() != null) {
            this.browserTaskPane = EditorUtil.createTaskPane("Contained in");
            this.browserTaskPane.add((Component)this.model.getBrowser().getUI());
            this.browserTaskPane.addPropertyChangeListener((PropertyChangeListener)this.controller);
        }
        this.protocolComponent = new JPanel();
        this.protocolComponent.setBackground(UIUtilities.BACKGROUND);
        this.propertiesUI = new PropertiesUI(this.model, this.controller);
        this.textualAnnotationsUI = new TextualAnnotationsUI(this.model, this.controller);
        this.annotationUI = new AnnotationDataUI(this.model, this.controller);
        this.components = new ArrayList<AnnotationUI>();
        this.components.add(this.propertiesUI);
        this.components.add(this.textualAnnotationsUI);
        this.components.add(this.annotationUI);
        Iterator<AnnotationUI> i = this.components.iterator();
        while (i.hasNext()) {
            i.next().addPropertyChangeListener("save", this.controller);
        }
        this.previews = new ArrayList<PreviewPanel>();
        this.panes = new HashMap<JXTaskPane, Integer>();
        this.indexes = new HashMap<Integer, Double>();
    }

    private void buildGUI() {
        this.content = new ScrollablePanel();
        this.content.setBackground(UIUtilities.BACKGROUND);
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 0.0, 5.0, 0.0}};
        int i = 0;
        this.content.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.content.add((Component)this.propertiesUI, "0, " + i);
        ++i;
        this.annotationLayoutIndex = ++i;
        this.content.add((Component)this.annotationUI, "0, " + i);
        ++i;
        this.textualAnnotationsLayoutIndex = ++i;
        this.content.add((Component)this.textualAnnotationsUI, "0, " + i);
        this.protocolsIndex = ++i;
        this.content.add((Component)this.protocolComponent, "0, " + i);
        ++i;
        this.browserIndex = ++i;
        this.content.add((Component)this.browserTaskPane, "0, " + i);
        this.getViewport().add(this.content);
        this.getViewport().setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private boolean isEditorFile(String nameSpace) {
        return "openmicroscopy.org/omero/editor/experiment".equals(nameSpace) || "openmicroscopy.org/omero/editor/protocol".equals(nameSpace);
    }

    private int buildProtocolTaskPanes() {
        Collection list = this.model.getAttachments();
        this.protocolComponent.removeAll();
        TableLayout layout = new TableLayout();
        double[] size = new double[]{-1.0};
        layout.setColumn(size);
        this.protocolComponent.setLayout((LayoutManager)layout);
        if (list.size() == 0) {
            return 0;
        }
        Iterator i = list.iterator();
        int index = 0;
        this.previews.clear();
        this.panes.clear();
        this.protocolComponent.setBorder(new TitledLineBorder("Protocols and Experiments"));
        while (i.hasNext()) {
            String description;
            FileAnnotationData fa = (FileAnnotationData)i.next();
            String ns = fa.getNameSpace();
            if (fa.getId() <= 0L || !this.isEditorFile(ns) || (description = fa.getDescription()) == null) continue;
            PreviewPanel preview = new PreviewPanel(description, fa.getId());
            this.previews.add(preview);
            preview.addPropertyChangeListener(this.controller);
            JXTaskPane pane = EditorUtil.createTaskPane(fa.getFileName());
            pane.addPropertyChangeListener((PropertyChangeListener)this.controller);
            this.defaultProtocolHeight = pane.getMinimumSize().getHeight() / 2.0 + 2.0;
            this.panes.put(pane, index);
            this.indexes.put(index, this.defaultProtocolHeight);
            pane.add((Component)preview);
            layout.insertRow(index, this.defaultProtocolHeight);
            this.protocolComponent.add((Component)pane, "0, " + index);
            layout.insertRow(++index, 5.0);
            this.protocolComponent.add((Component)new JLabel(), "0, " + index);
            ++index;
        }
        return index;
    }

    GeneralPaneUI(EditorUI view, EditorModel model, EditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void layoutUI() {
        this.propertiesUI.buildUI();
        this.annotationUI.buildUI();
        this.textualAnnotationsUI.buildUI();
        TableLayout layout = (TableLayout)this.content.getLayout();
        double h = 0.0;
        String s = "";
        boolean multi = this.model.isMultiSelection();
        Object refObject = this.model.getRefObject();
        if (refObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)refObject;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                this.browserTaskPane.setCollapsed(true);
            } else if (!multi) {
                h = -2.0;
                s = "Contained in Tag Sets";
            }
        } else if (refObject instanceof DatasetData) {
            if (!multi) {
                h = -2.0;
                s = "Contained in Projects";
            }
        } else if (refObject instanceof ImageData) {
            if (!multi) {
                h = -2.0;
                s = "Contained in Datasets";
                this.controller.loadChannelData();
            }
        } else if (refObject instanceof WellSampleData) {
            if (!multi) {
                this.controller.loadChannelData();
            }
        } else if (refObject instanceof ProjectData || refObject instanceof ScreenData || refObject instanceof WellSampleData) {
            this.browserTaskPane.setCollapsed(true);
        }
        this.browserTaskPane.setTitle(s);
        this.content.remove((Component)this.browserTaskPane);
        if (h != 0.0) {
            this.content.add((Component)this.browserTaskPane, "0, " + this.browserIndex);
        }
        int n = this.buildProtocolTaskPanes();
        double hp = 0.0;
        if (n > 0) {
            hp = -2.0;
        }
        layout.setRow(this.protocolsIndex, hp);
        if (h != 0.0 && !this.browserTaskPane.isCollapsed()) {
            this.loadParents(true);
        }
    }

    Map<Integer, List<AnnotationData>> prepareDataToSave() {
        if (!this.model.isMultiSelection()) {
            this.propertiesUI.updateDataObject();
        }
        ArrayList<AnnotationData> toAdd = new ArrayList<AnnotationData>();
        ArrayList<AnnotationData> toRemove = new ArrayList<AnnotationData>();
        List<AnnotationData> l = this.annotationUI.getAnnotationToSave();
        if (l != null && l.size() > 0) {
            toAdd.addAll(l);
        }
        if ((l = this.textualAnnotationsUI.getAnnotationToSave()) != null && l.size() > 0) {
            toAdd.addAll(l);
        }
        if ((l = this.annotationUI.getAnnotationToRemove()) != null && l.size() > 0) {
            toRemove.addAll(l);
        }
        if ((l = this.textualAnnotationsUI.getAnnotationToRemove()) != null && l.size() > 0) {
            toRemove.addAll(l);
        }
        HashMap<Integer, List<AnnotationData>> map = new HashMap<Integer, List<AnnotationData>>();
        map.put(0, toAdd);
        map.put(1, toRemove);
        return map;
    }

    void setRootObject() {
        this.clearData();
        this.textualAnnotationsUI.clearDisplay();
        this.propertiesUI.clearDisplay();
        this.annotationUI.clearDisplay();
        this.textualAnnotationsUI.clearDisplay();
        this.propertiesUI.buildUI();
        Object uo = this.model.getRefObject();
        TableLayout layout = (TableLayout)this.content.getLayout();
        if (uo instanceof AnnotationData) {
            layout.setRow(this.annotationLayoutIndex, 0.0);
            layout.setRow(this.textualAnnotationsLayoutIndex, 0.0);
            layout.setRow(this.browserIndex, 0.0);
        } else {
            layout.setRow(this.annotationLayoutIndex, -2.0);
            layout.setRow(this.textualAnnotationsLayoutIndex, -2.0);
            if (this.model.isMultiSelection()) {
                layout.setRow(this.browserIndex, 0.0);
            } else {
                layout.setRow(this.browserIndex, -2.0);
            }
        }
        this.revalidate();
        this.repaint();
    }

    void setThumbnails() {
        this.annotationUI.setThumbnails();
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        return this.annotationUI.getCurrentTagsSelection();
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        return this.annotationUI.getCurrentAttachmentsSelection();
    }

    void setChannelData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            this.propertiesUI.setChannelData(this.model.getChannelData());
        }
    }

    boolean hasDataToSave() {
        for (AnnotationUI ui : this.components) {
            if (!ui.hasDataToSave()) continue;
            return true;
        }
        for (PreviewPanel pp : this.previews) {
            if (!pp.hasDataToSave()) continue;
            return true;
        }
        return false;
    }

    void clearData() {
        for (AnnotationUI ui : this.components) {
            ui.clearData();
            ui.clearDisplay();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        if (source == null) {
            return;
        }
        if (source.equals(this.browserTaskPane)) {
            this.loadParents(!this.browserTaskPane.isCollapsed());
        } else {
            if (this.panes.size() == 0) {
                return;
            }
            Iterator<Map.Entry<JXTaskPane, Integer>> i = this.panes.entrySet().iterator();
            TableLayout layout = (TableLayout)this.protocolComponent.getLayout();
            while (i.hasNext()) {
                Map.Entry<JXTaskPane, Integer> entry = i.next();
                JXTaskPane pane = entry.getKey();
                int index = entry.getValue();
                if (pane != source) continue;
                double h = pane.isCollapsed() ? this.defaultProtocolHeight : -2.0;
                this.indexes.put(index, h);
                layout.setRow(index, h);
            }
            this.protocolComponent.validate();
            this.protocolComponent.repaint();
        }
    }

    void attachFile(File file) {
        this.annotationUI.attachFile(file);
    }

    void removeAttachedFile(Object file) {
        this.annotationUI.removeAttachedFile(file);
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        this.annotationUI.removeTag(tag);
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        this.annotationUI.handleObjectsSelection(type, objects);
    }
}

