/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.GeneralPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.ToolBar;
import org.openmicroscopy.shoola.agents.metadata.editor.UserUI;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorUI
extends JPanel {
    static final int TO_ADD = 0;
    static final int TO_REMOVE = 1;
    private static final int GENERAL_INDEX = 0;
    private static final int ACQUISITION_INDEX = 1;
    private EditorControl controller;
    private EditorModel model;
    private GeneralPaneUI generalPane;
    private AcquisitionDataUI acquisitionPane;
    private UserUI userUI;
    private ToolBar toolBar;
    private boolean saved;
    private JTabbedPane tabbedPane;
    private JTabbedPane userTabbedPane;
    private JComponent component;
    private JPanel defaultPane;

    private void initComponents() {
        this.userUI = new UserUI(this.model, this.controller);
        this.toolBar = new ToolBar(this.model, this.controller);
        this.generalPane = new GeneralPaneUI(this, this.model, this.controller);
        this.acquisitionPane = new AcquisitionDataUI(this, this.model, this.controller);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.tabbedPane.addTab("General", null, this.generalPane, "General Information.");
        this.tabbedPane.addTab("Acquisition", null, new JScrollPane(this.acquisitionPane), "Acquisition Metadata.");
        this.tabbedPane.setEnabledAt(1, false);
        this.defaultPane = new JPanel();
        this.defaultPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.component = this.defaultPane;
        this.userTabbedPane = new JTabbedPane();
        this.userTabbedPane.addTab("Profile", null, this.userUI, "User's details.");
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.component, "Center");
    }

    EditorUI() {
    }

    void initialize(EditorModel model, EditorControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void layoutUI() {
        Object uo = this.model.getRefObject();
        this.remove(this.component);
        this.setDataToSave(false);
        this.toolBar.setStatus(false);
        if (uo instanceof ExperimenterData) {
            this.toolBar.buildUI();
            this.userUI.buildUI();
            this.userUI.repaint();
            this.component = this.userTabbedPane;
        } else if (!(uo instanceof DataObject)) {
            this.toolBar.buildUI();
            this.component = this.defaultPane;
        } else {
            this.toolBar.buildUI();
            this.toolBar.setControls();
            this.generalPane.layoutUI();
            this.component = this.tabbedPane;
        }
        this.add((Component)this.component, "Center");
        this.validate();
        this.repaint();
    }

    void setRootObject() {
        Object uo = this.model.getRefObject();
        this.setDataToSave(false);
        this.toolBar.buildUI();
        this.toolBar.setStatus(false);
        if (!(uo instanceof DataObject)) {
            this.setDataToSave(false);
            this.toolBar.buildUI();
            this.toolBar.setStatus(false);
            this.remove(this.component);
            this.component = this.defaultPane;
            this.add((Component)this.component, "Center");
            this.revalidate();
            this.repaint();
        } else if (uo instanceof ExperimenterData) {
            this.layoutUI();
        } else {
            boolean load = false;
            if (this.model.isMultiSelection()) {
                this.tabbedPane.setSelectedIndex(0);
                this.tabbedPane.setEnabledAt(1, false);
            } else {
                if (uo instanceof ImageData) {
                    load = true;
                    this.tabbedPane.setEnabledAt(1, true);
                } else if (uo instanceof WellSampleData) {
                    ImageData img = ((WellSampleData)uo).getImage();
                    if (img != null && img.getId() >= 0L) {
                        load = true;
                        this.tabbedPane.setEnabledAt(1, true);
                    } else {
                        this.tabbedPane.setSelectedIndex(0);
                        this.tabbedPane.setEnabledAt(1, false);
                    }
                } else {
                    this.tabbedPane.setSelectedIndex(0);
                    this.tabbedPane.setEnabledAt(1, false);
                }
                load = true;
            }
            this.generalPane.setRootObject();
            this.acquisitionPane.setRootObject(load);
        }
    }

    void saveData() {
        this.saved = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.toolBar.setDataToSave(false);
        if (this.model.getRefObject() instanceof ExperimenterData) {
            ExperimenterData exp = this.userUI.getExperimenterToSave();
            this.model.fireDataObjectSaving(exp);
            return;
        }
        Map<Integer, List<AnnotationData>> m = this.generalPane.prepareDataToSave();
        List<AnnotationData> toAdd = m.get(0);
        List<AnnotationData> toRemove = m.get(1);
        List<Object> metadata = null;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData) {
            metadata = this.acquisitionPane.prepareDataToSave();
        }
        this.model.fireAnnotationSaving(toAdd, toRemove, metadata);
    }

    void setThumbnails() {
        this.generalPane.setThumbnails();
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        return this.generalPane.getCurrentTagsSelection();
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        return this.generalPane.getCurrentAttachmentsSelection();
    }

    void showChannelData() {
        this.generalPane.setChannelData();
        this.acquisitionPane.setChannelData();
    }

    void setDataToSave(boolean b) {
        this.toolBar.setDataToSave(b);
    }

    boolean hasDataToSave() {
        if (this.saved) {
            return false;
        }
        Object ref = this.model.getRefObject();
        if (!(ref instanceof DataObject)) {
            return false;
        }
        if (ref instanceof ExperimenterData) {
            return this.userUI.hasDataToSave();
        }
        boolean b = this.generalPane.hasDataToSave();
        if (b) {
            return b;
        }
        return this.acquisitionPane.hasDataToSave();
    }

    void clearData() {
        this.saved = false;
        this.generalPane.clearData();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void passwordChanged() {
        this.userUI.passwordChanged();
    }

    void setDiskSpace(List space) {
        this.userUI.setDiskSpace(space);
    }

    void handleTaskPaneCollapsed(JXTaskPane source) {
        this.generalPane.handleTaskPaneCollapsed(source);
    }

    void setStatus(boolean busy) {
        this.toolBar.setStatus(busy);
    }

    Collection getExistingTags() {
        return this.model.getExistingTags();
    }

    void attachFile(File file) {
        if (file == null) {
            return;
        }
        this.generalPane.attachFile(file);
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        this.generalPane.removeTag(tag);
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        this.generalPane.handleObjectsSelection(type, objects);
        if (TagAnnotationData.class.equals((Object)type)) {
            this.saveData();
        }
    }

    void removeAttachedFile(Object file) {
        if (file == null) {
            return;
        }
        this.generalPane.removeAttachedFile(file);
    }

    void setImageAcquisitionData() {
        this.acquisitionPane.setImageAcquisitionData();
    }

    void setChannelAcquisitionData(int index) {
        this.acquisitionPane.setChannelAcquisitionData(index);
    }

    boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    void createNewExperiment() {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        String name = this.model.getObjectPath();
        Object object = this.model.getRefObject();
        if ((object instanceof ProjectData || object instanceof DatasetData || object instanceof ImageData || object instanceof ScreenData || object instanceof PlateData) && name != null && name.trim().length() > 0) {
            name = name + "_exp";
            ShowEditorEvent event = new ShowEditorEvent((DataObject)object, name, 0);
            bus.post(event);
        }
    }
}

