/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.metadata.AcquisitionDataLoader;
import org.openmicroscopy.shoola.agents.metadata.AttachmentsLoader;
import org.openmicroscopy.shoola.agents.metadata.ChannelDataLoader;
import org.openmicroscopy.shoola.agents.metadata.DiskSpaceLoader;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.EnumerationLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.OriginalFileLoader;
import org.openmicroscopy.shoola.agents.metadata.PasswordEditor;
import org.openmicroscopy.shoola.agents.metadata.TagsLoader;
import org.openmicroscopy.shoola.agents.metadata.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.data.util.ViewedByDef;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;
import pojos.AnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.GroupData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.PermissionData;
import pojos.PixelsData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.RatingAnnotationData;
import pojos.ScreenData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorModel {
    private MetadataViewer parent;
    private Editor component;
    private Object refObject;
    private Map<Long, List> textualAnnotationsByUsers;
    private List textualAnnotationsByDate;
    private List<EditorLoader> loaders;
    private Map<Long, BufferedImage> thumbnails;
    private Collection existingTags;
    private Collection existingAttachments;
    private List emissionsWavelengths;
    private ViewerSorter sorter;
    private boolean thumbnailRequired;
    private Browser browser;
    private ImageAcquisitionData imageAcquisitionData;
    private Map<String, List<EnumerationObject>> channelEnumerations;
    private Map<String, List<EnumerationObject>> imageEnumerations;
    private Map<Integer, ChannelAcquisitionData> channelAcquisitionDatMap;

    private void sortAnnotationByDate(List annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp t1 = ((AnnotationData)o1).getLastModified();
                Timestamp t2 = ((AnnotationData)o2).getLastModified();
                long n1 = t1.getTime();
                long n2 = t2.getTime();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(annotations, c);
    }

    private void sortEnumerations(List<EnumerationObject> enumerations) {
        if (enumerations == null || enumerations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((EnumerationObject)o1).getValue();
                String s2 = ((EnumerationObject)o2).getValue();
                int v = 0;
                int result = s1.toLowerCase().compareTo(s2.toLowerCase());
                if (result < 0) {
                    v = -1;
                } else if (result > 0) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(enumerations, c);
    }

    EditorModel(Object refObject, MetadataViewer parent, boolean thumbnailRequired) {
        if (refObject == null) {
            throw new IllegalArgumentException("No object set.");
        }
        this.parent = parent;
        this.refObject = refObject;
        this.thumbnailRequired = thumbnailRequired;
        this.loaders = new ArrayList<EditorLoader>();
        this.sorter = new ViewerSorter();
        this.channelAcquisitionDatMap = new HashMap<Integer, ChannelAcquisitionData>();
    }

    boolean isMultiSelection() {
        return !this.parent.isSingleMode();
    }

    ObservableComponent getObservable() {
        return this.parent;
    }

    void setBrowser(Browser browser) {
        this.browser = browser;
    }

    Browser getBrowser() {
        return this.browser;
    }

    void initialize(Editor component) {
        this.component = component;
    }

    boolean isPermissionsShowable() {
        if (this.refObject == null) {
            return false;
        }
        return this.refObject instanceof ProjectData || this.refObject instanceof DatasetData;
    }

    PermissionData getRefObjectPermissions() {
        if (this.refObject instanceof DataObject) {
            return ((DataObject)this.refObject).getPermissions();
        }
        return null;
    }

    String getRefObjectName() {
        String name = "";
        if (this.refObject instanceof ImageData) {
            name = ((ImageData)this.refObject).getName();
        } else if (this.refObject instanceof DatasetData) {
            name = ((DatasetData)this.refObject).getName();
        } else if (this.refObject instanceof ProjectData) {
            name = ((ProjectData)this.refObject).getName();
        } else if (this.refObject instanceof TagAnnotationData) {
            name = ((TagAnnotationData)this.refObject).getTagValue();
        } else if (this.refObject instanceof ScreenData) {
            name = ((ScreenData)this.refObject).getName();
        } else if (this.refObject instanceof PlateData) {
            name = ((PlateData)this.refObject).getName();
        } else if (this.refObject instanceof FileAnnotationData) {
            name = ((FileAnnotationData)this.refObject).getFileName();
        } else if (this.refObject instanceof WellSampleData) {
            WellSampleData ws = (WellSampleData)this.refObject;
            ImageData img = ws.getImage();
            if (img != null && img.getId() >= 0L) {
                name = img.getName();
            }
            return "";
        }
        if (name == null) {
            return "";
        }
        return name.trim();
    }

    String getRefObjectDescription() {
        String description = "";
        if (this.refObject instanceof ImageData) {
            description = ((ImageData)this.refObject).getDescription();
        } else if (this.refObject instanceof DatasetData) {
            description = ((DatasetData)this.refObject).getDescription();
        } else if (this.refObject instanceof ProjectData) {
            description = ((ProjectData)this.refObject).getDescription();
        } else if (this.refObject instanceof ScreenData) {
            description = ((ScreenData)this.refObject).getDescription();
        } else if (this.refObject instanceof PlateData) {
            description = ((PlateData)this.refObject).getDescription();
        } else if (this.refObject instanceof TagAnnotationData) {
            description = ((TagAnnotationData)this.refObject).getTagDescription();
        }
        if (description == null) {
            return "";
        }
        return description.trim();
    }

    long getRefObjectID() {
        if (this.refObject instanceof DataObject) {
            return ((DataObject)this.refObject).getId();
        }
        return -1L;
    }

    Object getRefObject() {
        return this.refObject;
    }

    boolean isReadable() {
        return false;
    }

    boolean isWritable() {
        return false;
    }

    boolean isValidGroup(GroupData g) {
        if (g == null) {
            return false;
        }
        String name = g.getName();
        return !"user".equals(name) && !"default".equals(name);
    }

    boolean isCurrentUserOwner(Object object) {
        long userID = MetadataViewerAgent.getUserDetails().getId();
        if (object == null) {
            return false;
        }
        if (object instanceof ExperimenterData) {
            return ((ExperimenterData)object).getId() == userID;
        }
        if (object instanceof DataObject) {
            try {
                ExperimenterData exp = ((DataObject)object).getOwner();
                if (exp == null) {
                    return false;
                }
                return userID == exp.getId();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    String formatOwner(DataObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof ExperimenterData) {
            return EditorUtil.formatExperimenter((ExperimenterData)object);
        }
        return this.formatOwner((DataObject)object.getOwner());
    }

    String formatDate(DataObject object) {
        String date = "";
        Timestamp time = null;
        if (object == null) {
            return date;
        }
        if (object instanceof AnnotationData) {
            time = ((AnnotationData)object).getLastModified();
        } else if (object instanceof ImageData) {
            time = EditorUtil.getAcquisitionTime((ImageData)object);
        }
        if (time != null) {
            date = UIUtilities.formatShortDateTime(time);
        }
        return date;
    }

    int getUrlsCount() {
        Collection urls = this.getUrls();
        if (urls == null) {
            return 0;
        }
        return urls.size();
    }

    Collection getUrls() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getUrls();
    }

    int getTagsCount() {
        Collection tags = this.getTags();
        if (tags == null) {
            return 0;
        }
        return tags.size();
    }

    Collection getTags() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return new ArrayList();
        }
        Collection tags = data.getTags();
        if (tags == null || tags.size() == 0) {
            return new ArrayList();
        }
        return this.sorter.sort(tags);
    }

    int getAttachmentsCount() {
        Collection attachments = this.getAttachments();
        if (attachments == null) {
            return 0;
        }
        return attachments.size();
    }

    Collection getAttachments() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return new ArrayList();
        }
        Collection attachements = data.getAttachments();
        if (attachements == null) {
            return new ArrayList();
        }
        return this.sorter.sort(attachements);
    }

    int getViewedByCount() {
        Collection viewedBy = this.getViewedBy();
        if (viewedBy == null) {
            return 0;
        }
        return viewedBy.size();
    }

    Collection getViewedBy() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        Collection l = data.getViewedBy();
        if (l == null) {
            return null;
        }
        Iterator i = l.iterator();
        long userID = MetadataViewerAgent.getUserDetails().getId();
        ArrayList results = new ArrayList();
        HashMap<String, ViewedByDef> m = new HashMap<String, ViewedByDef>();
        ArrayList<String> names = new ArrayList<String>();
        while (i.hasNext()) {
            ViewedByDef def = (ViewedByDef)i.next();
            ExperimenterData exp = def.getExperimenter();
            if (exp.getId() == userID) continue;
            String value = this.formatOwner((DataObject)exp);
            names.add(value);
            m.put(value, def);
            def.setFormattedExperimenter(value);
        }
        l = this.sorter.sort(names);
        for (String value : l) {
            results.add(m.get(value));
        }
        return results;
    }

    int getRatingCount() {
        StructuredDataResults data = this.parent.getStructuredData();
        Collection ratings = data.getRatings();
        if (ratings == null) {
            return 0;
        }
        return ratings.size();
    }

    RatingAnnotationData getUserRatingAnnotation() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        Collection ratings = data.getRatings();
        if (ratings == null || ratings.size() == 0) {
            return null;
        }
        Iterator i = ratings.iterator();
        long id = MetadataViewerAgent.getUserDetails().getId();
        while (i.hasNext()) {
            RatingAnnotationData rate = (RatingAnnotationData)i.next();
            if (rate.getOwner().getId() != id) continue;
            return rate;
        }
        return null;
    }

    int getUserRating() {
        RatingAnnotationData data = this.getUserRatingAnnotation();
        if (data == null) {
            return 0;
        }
        return data.getRating();
    }

    int getRatingAverage() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return 0;
        }
        Collection ratings = data.getRatings();
        if (ratings == null || ratings.size() == 0) {
            return 0;
        }
        Iterator i = ratings.iterator();
        int value = 0;
        while (i.hasNext()) {
            RatingAnnotationData rate = (RatingAnnotationData)i.next();
            value += rate.getRating();
        }
        return value / ratings.size();
    }

    int getTextualAnnotationCount() {
        Collection annotations = this.getTextualAnnotations();
        if (annotations == null) {
            return 0;
        }
        return annotations.size();
    }

    Collection getTextualAnnotations() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getTextualAnnotations();
    }

    List getTextualAnnotationsByDate() {
        if (this.textualAnnotationsByDate != null) {
            return this.textualAnnotationsByDate;
        }
        this.textualAnnotationsByDate = (List)this.getTextualAnnotations();
        this.sortAnnotationByDate(this.textualAnnotationsByDate);
        return this.textualAnnotationsByDate;
    }

    TextualAnnotationData getLastUserAnnotation() {
        long userID;
        Map<Long, List> m = this.getTextualAnnotationByOwner();
        List l = m.get(userID = MetadataViewerAgent.getUserDetails().getId());
        if (l == null || l.size() == 0) {
            return null;
        }
        return (TextualAnnotationData)l.get(0);
    }

    Map<Long, List> getTextualAnnotationByOwner() {
        if (this.textualAnnotationsByUsers != null && this.textualAnnotationsByUsers.size() > 0) {
            return this.textualAnnotationsByUsers;
        }
        this.textualAnnotationsByUsers = new HashMap<Long, List>();
        Collection original = this.getTextualAnnotations();
        if (original == null) {
            return this.textualAnnotationsByUsers;
        }
        for (AnnotationData annotation : original) {
            Long ownerID = annotation.getOwner().getId();
            ArrayList<AnnotationData> userAnnos = this.textualAnnotationsByUsers.get(ownerID);
            if (userAnnos == null) {
                userAnnos = new ArrayList<AnnotationData>();
                this.textualAnnotationsByUsers.put(ownerID, userAnnos);
            }
            userAnnos.add(annotation);
        }
        for (Long ownerID : this.textualAnnotationsByUsers.keySet()) {
            this.sortAnnotationByDate(this.textualAnnotationsByUsers.get(ownerID));
        }
        return this.textualAnnotationsByUsers;
    }

    void setRootObject(Object refObject) {
        this.refObject = refObject;
        if (this.thumbnails != null) {
            this.thumbnails.clear();
        }
        this.thumbnails = null;
        if (this.existingTags != null) {
            this.existingTags.clear();
        }
        this.existingTags = null;
        if (this.textualAnnotationsByUsers != null) {
            this.textualAnnotationsByUsers.clear();
        }
        this.textualAnnotationsByUsers = null;
        if (this.textualAnnotationsByDate != null) {
            this.textualAnnotationsByDate.clear();
        }
        this.textualAnnotationsByDate = null;
        if (this.existingAttachments != null) {
            this.existingAttachments.clear();
        }
        this.existingAttachments = null;
        if (this.emissionsWavelengths != null) {
            this.emissionsWavelengths.clear();
        }
        this.emissionsWavelengths = null;
        this.channelAcquisitionDatMap.clear();
        this.imageAcquisitionData = null;
        if (refObject instanceof ImageData) {
            this.fireChannelEnumerationsLoading();
            this.fireImageEnumerationsLoading();
        }
    }

    ExperimenterData getRefObjectOwner() {
        if (this.refObject instanceof DataObject) {
            return this.getOwner((DataObject)this.refObject);
        }
        return null;
    }

    boolean isThumbnailsLoaded() {
        return this.thumbnails != null;
    }

    void setThumbnails(Map<Long, BufferedImage> thumbnails) {
        this.thumbnails = thumbnails;
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader loader = null;
        while (i.hasNext() && !((loader = i.next()) instanceof ThumbnailLoader)) {
        }
        if (loader != null) {
            this.loaders.remove(loader);
        }
    }

    Map<Long, BufferedImage> getThumbnails() {
        return this.thumbnails;
    }

    void loadThumbnails() {
        HashSet<Long> ids = new HashSet<Long>();
        Collection l = this.getViewedBy();
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        ViewedByDef def = null;
        while (i.hasNext()) {
            def = (ViewedByDef)i.next();
            ids.add(def.getExperimenter().getId());
        }
        ThumbnailLoader loader = new ThumbnailLoader(this.component, (ImageData)this.refObject, ids);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelThumbnailsLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof ThumbnailLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void loadUserThumbnail() {
        if (this.refObject instanceof ImageData && this.thumbnailRequired) {
            HashSet<Long> l = new HashSet<Long>();
            l.add(MetadataViewerAgent.getUserDetails().getId());
            ThumbnailLoader loader = new ThumbnailLoader(this.component, (ImageData)this.refObject, l, true);
            loader.load();
            this.loaders.add(loader);
        }
    }

    ViewedByDef getViewedDef(long userID) {
        Collection l = this.getViewedBy();
        Iterator i = l.iterator();
        ViewedByDef def = null;
        while (i.hasNext()) {
            def = (ViewedByDef)i.next();
            if (def.getExperimenter().getId() != userID) continue;
            return def;
        }
        return null;
    }

    void loadExistingTags() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof TagsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        TagsLoader loader = new TagsLoader(this.component);
        loader.load();
        this.loaders.add(loader);
    }

    void loadExistingAttachments() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof AttachmentsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        AttachmentsLoader loader = new AttachmentsLoader(this.component);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelExistingTagsLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof TagsLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void loadChannelData() {
        WellSampleData wsd;
        Object refObject = this.getRefObject();
        ImageData data = null;
        if (refObject instanceof ImageData) {
            data = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData && ((data = (wsd = (WellSampleData)refObject).getImage()) == null || data.getId() < 0L)) {
            data = null;
        }
        try {
            PixelsData pixs = data.getDefaultPixels();
            ChannelDataLoader loader = new ChannelDataLoader(this.component, pixs.getId());
            loader.load();
            this.loaders.add(loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cancelChannelDataLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof ChannelDataLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void setExistingTags(Collection tags) {
        if (tags != null) {
            this.existingTags = this.sorter.sort(tags);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof TagsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    void setExistingAttachments(Collection attachments) {
        if (attachments != null) {
            this.existingAttachments = this.sorter.sort(attachments);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof AttachmentsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingAttachments() {
        return this.existingAttachments;
    }

    void setChannelData(List data) {
        this.emissionsWavelengths = this.sorter.sort(data);
    }

    List getChannelData() {
        return this.emissionsWavelengths;
    }

    void fireAnnotationSaving(List<AnnotationData> toAdd, List<AnnotationData> toRemove, List<Object> metadata) {
        if (this.refObject instanceof DataObject) {
            this.parent.saveData(toAdd, toRemove, metadata, (DataObject)this.refObject);
        }
    }

    void fireDataObjectSaving(ExperimenterData exp) {
        this.parent.saveData(null, null, null, (DataObject)exp);
    }

    boolean isArchived() {
        if (!(this.refObject instanceof ImageData)) {
            return false;
        }
        ImageData img = (ImageData)this.refObject;
        return img.isArchived();
    }

    void download() {
        PixelsData data = ((ImageData)this.refObject).getDefaultPixels();
        OriginalFileLoader loader = new OriginalFileLoader(this.component, data.getId());
        loader.load();
        this.loaders.add(loader);
    }

    void loadDiskSpace() {
        long id = MetadataViewerAgent.getUserDetails().getId();
        DiskSpaceLoader loader = new DiskSpaceLoader(this.component, id);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelDiskSpaceLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof DiskSpaceLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void changePassword(String old, String confirm) {
        PasswordEditor loader = new PasswordEditor(this.component, old, confirm);
        ((EditorLoader)loader).load();
        this.loaders.add(loader);
    }

    boolean hasTagsAsChildren() {
        if (!(this.refObject instanceof TagAnnotationData)) {
            return false;
        }
        TagAnnotationData tag = (TagAnnotationData)this.refObject;
        Set tags = tag.getTags();
        return tags != null && tags.size() > 0;
    }

    ExperimenterData getOwner(DataObject data) {
        if (data == null) {
            return null;
        }
        long id = data.getOwner().getId();
        return MetadataViewerAgent.getExperimenter(id);
    }

    void loadParents() {
        this.parent.loadParents();
    }

    void cancelParentsLoading() {
    }

    boolean hasBeenViewedBy() {
        if (!(this.getRefObject() instanceof ImageData)) {
            return false;
        }
        return this.getViewedByCount() != 0;
    }

    void viewImage(ViewedByDef def) {
        ImageData img = (ImageData)this.getRefObject();
        ViewImage evt = new ViewImage(img, null);
        if (def != null) {
            evt.setSettings(def.getRndSettings(), def.getExperimenter().getId());
        }
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    void fireImageEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, 0);
        loader.load();
    }

    void fireChannelEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, 1);
        loader.load();
    }

    void fireImagAcquisitionDataLoading() {
        Object ref = this.getRefObject();
        ImageData data = null;
        if (ref instanceof WellSampleData) {
            data = ((WellSampleData)ref).getImage();
        } else if (ref instanceof ImageData) {
            data = (ImageData)ref;
        }
        if (data == null) {
            return;
        }
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, data);
        loader.load();
    }

    void fireChannelAcquisitionDataLoading(ChannelData channel) {
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, channel);
        loader.load();
    }

    void setImageAcquisitionData(ImageAcquisitionData data) {
        this.imageAcquisitionData = data;
    }

    ImageAcquisitionData getImageAcquisitionData() {
        return this.imageAcquisitionData;
    }

    void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        this.channelAcquisitionDatMap.put(index, data);
    }

    ChannelAcquisitionData getChannelAcquisitionData(int index) {
        return this.channelAcquisitionDatMap.get(index);
    }

    List<EnumerationObject> getImageEnumerations(String name) {
        if (this.imageEnumerations != null) {
            return this.imageEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    List<EnumerationObject> getChannelEnumerations(String name) {
        if (this.channelEnumerations != null) {
            return this.channelEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    Object getImageEnumerationSelected(String name, String value) {
        List<EnumerationObject> l = this.getImageEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        for (EnumerationObject o : l) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return null;
    }

    Object getChannelEnumerationSelected(String name, String value) {
        List<EnumerationObject> l = this.getChannelEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        for (EnumerationObject o : l) {
            if (!o.getValue().equals(value)) continue;
            return o;
        }
        return null;
    }

    void setChannelEnumerations(Map enumerations) {
        this.channelEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.channelEnumerations.put(key, values);
        }
    }

    void setImageEnumerations(Map enumerations) {
        this.imageEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.imageEnumerations.put(key, values);
        }
    }

    String getTagDescription(TagAnnotationData tag) {
        if (tag == null) {
            return "";
        }
        return tag.getTagDescription();
    }

    boolean isSingleMode() {
        return this.parent.isSingleMode();
    }

    String getObjectPath() {
        return this.parent.getObjectPath();
    }
}

