/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.HTMLFilter;
import org.openmicroscopy.shoola.util.filter.file.PDFFilter;
import org.openmicroscopy.shoola.util.filter.file.PowerPointFilter;
import org.openmicroscopy.shoola.util.filter.file.TEXTFilter;
import org.openmicroscopy.shoola.util.filter.file.WordFilter;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;
import pojos.ChannelData;
import pojos.FileAnnotationData;
import pojos.TagAnnotationData;

class EditorControl
implements ActionListener,
PropertyChangeListener {
    static final String SAVE_PROPERTY = "save";
    static final int ADD_LOCAL_DOCS = 0;
    static final int ADD_UPLOADED_DOCS = 1;
    static final int ADD_TAGS = 2;
    static final int SAVE = 3;
    static final int DOWNLOAD = 4;
    static final int ACQUISITION_METADATA = 5;
    static final int CREATE_NEW_EXPERIMENT = 6;
    private Editor model;
    private EditorUI view;
    private List<FileFilter> filters;

    EditorControl() {
    }

    private void createFileFilters() {
        this.filters = new ArrayList<FileFilter>();
        this.filters.add(new PDFFilter());
        this.filters.add(new TEXTFilter());
        this.filters.add(new XMLFilter());
        this.filters.add(new HTMLFilter());
        this.filters.add(new PowerPointFilter());
        this.filters.add(new ExcelFilter());
        this.filters.add(new WordFilter());
        this.filters.add(new EditorFileFilter());
    }

    private void selectFileToAttach() {
        JFrame owner = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(owner, 0, "Choose File", "Select the file to attach.", this.filters);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(42));
        chooser.setApproveButtonText("Attach");
        chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(chooser);
    }

    private void viewImage(long imageID) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new ViewImage(imageID, null));
    }

    private void viewImage(String imageName) {
    }

    private void viewProtocol(long protocolID) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new EditFileEvent(protocolID));
    }

    void initialize(Editor model, EditorUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = view;
        this.createFileFilters();
    }

    void loadChannelData() {
        this.model.loadChannelData();
    }

    void loadParents() {
        this.model.loadParents();
    }

    void loadImageAcquisitionData() {
        this.model.loadImageAcquisitionData();
    }

    void loadChannelAcquisitionData(ChannelData channel) {
        this.model.loadChannelAcquisitionData(channel);
    }

    void loadExistingTags() {
        this.model.loadExistingTags();
    }

    boolean isSingleMode() {
        return this.view.isSingleMode();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Long id;
        String name = evt.getPropertyName();
        if (SAVE_PROPERTY.equals(name) || "dataModified".equals(name) || "previewEdited".equals(name)) {
            this.view.setDataToSave(this.view.hasDataToSave());
        } else if ("saveData".equals(name)) {
            this.view.saveData();
        } else if ("clearSaveData".equals(name) || "onDataSave".equals(name)) {
            this.view.clearData();
        } else if ("collapsed".equals(name)) {
            this.view.handleTaskPaneCollapsed((JXTaskPane)evt.getSource());
        } else if ("approveSelection".equals(name)) {
            this.view.attachFile((File)evt.getNewValue());
        } else if ("removeAnnotation".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                DocComponent doc = (DocComponent)object;
                Object data = doc.getData();
                if (data instanceof File) {
                    this.view.removeAttachedFile(data);
                } else if (data instanceof FileAnnotationData) {
                    this.view.removeAttachedFile(data);
                } else if (data instanceof TagAnnotationData) {
                    this.view.removeTag((TagAnnotationData)data);
                }
            }
        } else if ("editTag".equals(name)) {
            Object object = evt.getNewValue();
            if (object instanceof DocComponent) {
                this.view.setDataToSave(this.view.hasDataToSave());
            }
        } else if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            switch (object.getIndex()) {
                case 2: {
                    long id2 = object.getId();
                    if (id2 < 0L) {
                        this.viewImage(object.getName());
                        break;
                    }
                    this.viewImage(id2);
                    break;
                }
                case 4: {
                    this.viewProtocol(object.getId());
                }
            }
        } else if ("selectedItems".equals(name)) {
            Map m = (Map)evt.getNewValue();
            if (m == null || m.size() != 1) {
                return;
            }
            Set set = m.entrySet();
            for (Map.Entry entry : set) {
                Class type = (Class)entry.getKey();
                this.view.handleObjectsSelection(type, (Collection)entry.getValue());
            }
        } else if ("openFile".equals(name) && (id = (Long)evt.getNewValue()) != null) {
            this.viewProtocol(id);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.selectFileToAttach();
                break;
            }
            case 1: {
                this.model.loadExistingAttachments();
                break;
            }
            case 3: {
                this.view.saveData();
                break;
            }
            case 4: {
                this.model.download();
                break;
            }
            case 2: {
                this.loadExistingTags();
                break;
            }
            case 6: {
                this.view.createNewExperiment();
            }
        }
    }
}

