/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.util.SelectionWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import pojos.AnnotationData;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;
import pojos.FileAnnotationData;
import pojos.ImageAcquisitionData;
import pojos.ImageData;
import pojos.TagAnnotationData;
import pojos.URLAnnotationData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;

    private void showSelectionWizard(Class type, Collection available, Collection selected, boolean addCreation) {
        IconManager icons = IconManager.getInstance();
        Registry reg = MetadataViewerAgent.getRegistry();
        String title = "";
        String text = "";
        Icon icon = null;
        if (TagAnnotationData.class.equals((Object)type)) {
            title = "Tags Selection";
            text = "Select the Tags to add or remove, \nor Create new Tags";
            icon = icons.getIcon(24);
        } else if (FileAnnotationData.class.equals((Object)type)) {
            title = "Attachments Selection";
            text = "Select the Attachments to add or remove.";
            icon = icons.getIcon(42);
        }
        SelectionWizard wizard = new SelectionWizard(reg.getTaskBar().getFrame(), available, selected, type, addCreation);
        if (this.model.isMultiSelection()) {
            wizard.setAcceptButtonText("Save");
        }
        wizard.setTitle(title, text, icon);
        wizard.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(wizard);
    }

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = new EditorUI();
        this.controller = new EditorControl();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.model, this.controller);
        this.model.getObservable().addPropertyChangeListener(this.controller);
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public void setStructuredDataResults() {
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.layoutUI();
        if (this.model.hasBeenViewedBy() && !this.model.isThumbnailsLoaded()) {
            this.model.loadThumbnails();
        }
    }

    @Override
    public void setRootObject(Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Root object not valid.");
        }
        this.model.setRootObject(refObject);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.view.setRootObject();
    }

    @Override
    public void setThumbnails(Map<Long, BufferedImage> thumbnails, long imageID) {
        Object ref = this.model.getRefObject();
        if (ref instanceof ImageData && ((ImageData)ref).getId() == imageID) {
            this.model.setThumbnails(thumbnails);
            this.view.setThumbnails();
        }
    }

    @Override
    public void setExistingTags(Collection tags) {
        this.model.setExistingTags(tags);
        List<TagAnnotationData> setTags = this.view.getCurrentTagsSelection();
        Iterator k = setTags.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (k.hasNext()) {
            ids.add(((TagAnnotationData)k.next()).getId());
        }
        ArrayList<TagAnnotationData> available = new ArrayList<TagAnnotationData>();
        if (tags != null) {
            for (TagAnnotationData data : tags) {
                String ns = data.getNameSpace();
                if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                    Set l = data.getTags();
                    if (l == null) continue;
                    for (TagAnnotationData tag : l) {
                        if (ids.contains(tag.getId())) continue;
                        available.add(tag);
                    }
                    continue;
                }
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        this.showSelectionWizard(TagAnnotationData.class, available, setTags, true);
        this.setStatus(false);
    }

    @Override
    public void setChannelsData(List channelData, boolean updateView) {
        this.model.setChannelData(channelData);
        if (updateView) {
            this.view.showChannelData();
        }
    }

    @Override
    public boolean hasDataToSave() {
        return this.view.hasDataToSave();
    }

    @Override
    public void setDownloadedFiles(Collection files) {
        this.setStatus(false);
        if (files == null || files.size() == 0) {
            return;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyDownload(files);
    }

    @Override
    public void setDiskSpace(List list) {
        if (list == null || list.size() != 2) {
            return;
        }
        this.view.setDiskSpace(list);
        this.view.layoutUI();
    }

    @Override
    public void passwordChanged(boolean changed) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        if (changed) {
            un.notifyInfo("Password change", "The password has been successfully modified.");
        } else {
            un.notifyInfo("Password change", "The password could not be modified. Please try again.");
        }
        this.view.passwordChanged();
    }

    @Override
    public void loadChannelData() {
        if (this.model.getChannelData() == null) {
            this.model.loadChannelData();
        } else {
            this.view.showChannelData();
        }
    }

    @Override
    public void setExistingAttachements(Collection attachments) {
        if (attachments == null) {
            return;
        }
        this.model.setExistingAttachments(attachments);
        List<FileAnnotationData> setAttachments = this.view.getCurrentAttachmentsSelection();
        Iterator k = setAttachments.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (k.hasNext()) {
            ids.add(((FileAnnotationData)k.next()).getId());
        }
        ArrayList<FileAnnotationData> available = new ArrayList<FileAnnotationData>();
        if (attachments != null) {
            for (FileAnnotationData data : attachments) {
                if (ids.contains(data.getId())) continue;
                available.add(data);
            }
        }
        this.showSelectionWizard(FileAnnotationData.class, available, setAttachments, true);
        this.setStatus(false);
    }

    @Override
    public void setSelectionMode(boolean single) {
        this.view.repaint();
    }

    @Override
    public void loadParents() {
        this.model.loadParents();
    }

    @Override
    public void setStatus(boolean busy) {
        this.view.setStatus(busy);
    }

    @Override
    public void loadExistingTags() {
        this.model.loadExistingTags();
        this.setStatus(true);
    }

    @Override
    public void deleteAnnotation(AnnotationData data) {
        if (data == null) {
            return;
        }
        String s = null;
        if (data instanceof FileAnnotationData) {
            s = "Do you want to delete the attachment?";
        } else if (data instanceof URLAnnotationData) {
            s = "Do you want to delete the URL?";
        }
        if (s == null) {
            return;
        }
        JFrame owner = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        MessageBox msg = new MessageBox(owner, "Delete", s);
        int option = msg.centerMsgBox();
        if (option == 1) {
            ArrayList<AnnotationData> toRemove = new ArrayList<AnnotationData>(1);
            toRemove.add(data);
        }
    }

    @Override
    public void setImageAcquisitionData(ImageAcquisitionData map) {
        if (map == null) {
            return;
        }
        this.model.setImageAcquisitionData(map);
        this.view.setImageAcquisitionData();
        this.view.setStatus(false);
    }

    @Override
    public void loadImageAcquisitionData() {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            ImageAcquisitionData data = this.model.getImageAcquisitionData();
            if (data != null) {
                return;
            }
            this.model.fireImagAcquisitionDataLoading();
            this.view.setStatus(true);
        }
    }

    @Override
    public void loadChannelAcquisitionData(ChannelData channel) {
        Object refObject = this.model.getRefObject();
        if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
            if (channel == null) {
                return;
            }
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(channel.getIndex());
            if (data != null) {
                return;
            }
            this.model.fireChannelAcquisitionDataLoading(channel);
            this.view.setStatus(true);
        }
    }

    @Override
    public void setChannelEnumerations(Map map) {
        this.model.setChannelEnumerations(map);
    }

    @Override
    public void setImageEnumerations(Map map) {
        this.model.setImageEnumerations(map);
    }

    @Override
    public void showManufacturer(JComponent comp, Point p) {
        TinyDialog d = new TinyDialog((Frame)MetadataViewerAgent.getRegistry().getTaskBar().getFrame(), comp, 1);
        d.pack();
        Dimension dim = d.getSize();
        d.setLocation(p.x - dim.width / 2, p.y - dim.height - 5);
        d.setVisible(true);
    }

    @Override
    public void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        this.model.setChannelAcquisitionData(index, data);
        this.view.setChannelAcquisitionData(index);
        this.view.setStatus(false);
    }

    @Override
    public void loadExistingAttachments() {
        this.model.loadExistingAttachments();
        this.setStatus(true);
    }

    @Override
    public void download() {
        this.model.download();
        this.setStatus(true);
    }
}

